# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:23:42 2022
#  Target Database = postgresql
#
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.ino_templ_by_no_type import iNoTemplByNoType
from bs_loco.db.tables.no_templ import tNoTempl

class dNoTemplByNoType:
    __slots__ = ("_dbcon", "_dbstmnt", "irec", "orec")

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = iNoTemplByNoType()
        self.orec     = None

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt:
            self._dbstmnt.destroy()
            self._dbstmnt = None

    def exec_deft(self,
                  notype_id: str,
                  criteria: str) -> "dNoTemplByNoType":
        """
        Execute the query by setting all the inputs.

        :param notype_id: str
        :param criteria: str
        :return: Self for convenience.
        """
        self.irec.notype_id = notype_id
        self.irec.criteria = criteria

        return self.exec()

    def exec(self, irec: iNoTemplByNoType = None) -> "dNoTemplByNoType":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("NoTemplByNoType", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  t.*
from
  loco.notempl t
where
  t.notype_id := t.notype_id
  [criteria]
order by
  corrtype_id""")

        self._dbstmnt.dynamic("[criteria]", self.irec.criteria)

        self._dbstmnt.bind_in("notype_id", self.irec.notype_id, str, 128)

        self._dbstmnt.bind_out("notype_id", str, 128)
        self._dbstmnt.bind_out("corrtype_id", str, 16)
        self._dbstmnt.bind_out("status", str, 1)
        self._dbstmnt.bind_out("lastcfg_id", int, 8)
        self._dbstmnt.bind_out("templ", dict)
        self._dbstmnt.bind_out("res_list", dict)
        self._dbstmnt.bind_out("modified_by", str, 128)
        self._dbstmnt.bind_out("tm_stamp", datetime.datetime)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    def fetch(self, must_exist: bool = False) -> bool:
        """
        Fetches the next row from the executed query.

        :param must_exist:
        :return: True if a row was fetched, else False.
        """
        if not self._dbcon.fetch(self._dbstmnt):
            if must_exist:
                raise mettle.lib.xMettle(f"Record not found: [table:NoTempl, proc:ByNoType, row:{self.irec}]", err_code=mettle.lib.xMettle.eCode.DBNotFound)
            return False

        self.orec = tNoTempl()

        self.orec.notype_id = self._dbstmnt.result[0]
        self.orec.corrtype_id = self._dbstmnt.result[1]
        self.orec.status = self._dbstmnt.result[2]
        self.orec.lastcfg_id = self._dbstmnt.result[3]
        self.orec.templ = self._dbstmnt.result[4]
        self.orec.res_list = self._dbstmnt.result[5]
        self.orec.modified_by = self._dbstmnt.result[6]
        self.orec.tm_stamp = self._dbstmnt.result[7]

        return True

    def fetch_iter(self) -> tNoTempl:
        """
        Yield all the rows one at a time.

        :return: Iterator for output rows
        """
        while self.fetch():
            yield self.orec

    def fetch_all(self, out_list: tNoTempl.List, clear_list: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param out_list:
        :param clear_list:
        :return: Number of rows fetched.
        """
        if clear_list:
            out_list.clear()

        while self.fetch():
            out_list.append(self.orec)

        return len(out_list)

