# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:23:42 2022
#  Target Database = postgresql
#
import asyncio
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.no_templ import tNoTempl
from bs_loco.db.tables.no_templ_key import tNoTemplKey

from .no_templ_lock_one import dNoTemplLockOne
from .no_templ_select_one import dNoTemplSelectOne
from .no_templ_update import dNoTemplUpdate
from .no_templ_insert import dNoTemplInsert

class dNoTempl:
    __slots__ = ("_dbcon", "rec")

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self.rec    = tNoTempl()
        self._dbcon = dbcon

    def __enter__(self):
        """
        DAO enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        DAO exit.
        """
        pass

    def lock_one(self, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Lock and select the record.

        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        _key = tNoTemplKey()

        self.rec._write_key(_key)

        return self.lock_one_by_key(_key, _lock4update, _expected)

    def lock_one_with(self, _rec: tNoTempl, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Lock and select the record using a record.

        :param _rec: The table rec to select with and into.
        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        _key = tNoTemplKey()
        _rec._write_key(_key)

        self.lock_one_by_key(_key, _lock4update, _expected)
        _rec._copy_from(self.rec)
        return True

    def lock_one_deft(self,
                      notype_id: str,
                      corrtype_id: str,
                      _lock4update: mettle.db.DBLock,
                      _expected: bool = True) -> bool:
        """
        Attempt to lock and select the record by it's primary key columns.

        :param notype_id: str
        :param corrtype_id: str
        :param _lock4update:  The db lock object to use. 
        :param _expected: bool
        """
        _key = tNoTemplKey()

        _key.notype_id = notype_id
        _key.corrtype_id = corrtype_id

        return self.lock_one_by_key(_key, _lock4update, _expected)

    def lock_one_by_key(self, _key: tNoTemplKey, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Attempt to lock and select the record with it's primary key.

        :param _key: Primary key of the table record.
        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        with dNoTemplLockOne(self._dbcon) as _qry:
            _dex = _lock4update.retrys - 1 if _lock4update.retrys > 0 else 0

            while _dex >= 0:
                try:
                    _qry.exec(_key)
                    if not _qry.fetch():
                        if not _expected:
                            return False

                        raise mettle.lib.xMettle(f"Lock not found: [table:dNoTempl, row:{_key}]", err_code=mettle.lib.xMettle.eCode.DBNotFound)

                    break
                except mettle.lib.xMettle as _x:
                    if _x.get_error_code() != mettle.lib.xMettle.eCode.DBLockNoWaitFailed:
                        raise _x

                    if _dex == 0:
                        raise mettle.lib.xMettle("Could not lock NoTempl record after %d attempt(s) at %d mili second intervals!" % (
_lock4update.retrys, _lock4update.mili_seconds), err_code = mettle.lib.xMettle.eCode.DBLockNoWaitFailed)

                    if _lock4update.mili_seconds > 0:
                        time.sleep(_lock4update.mili_seconds * 0.001)
                _dex -= 1

            self.rec = _qry.orec

            return True

    def try_select_one(self) -> bool:
        """
        Attempt to select the record.

        :return: True if the record was found.
        """
        _key = tNoTemplKey()

        self.rec._write_key(_key)

        return self.try_select_one_by_key(_key)

    def try_select_one_with(self, _rec: tNoTempl) -> bool:
        """
        Attempt to select the record using a table rec.

        :param _rec: The table rec to select with and into.
        :return: True if the row as selectd.
        """
        _key = tNoTemplKey()
        _rec._write_key(_key)

        if not self.try_select_one_by_key(_key):
            return False

        _rec._copy_from(self.rec)

        return True

    def try_select_one_deft(self,
                            notype_id: str,
                            corrtype_id: str) -> bool:
        """
        Attempt to select the record by it's primary key columns.

        :param notype_id: str
        :param corrtype_id: str
        :return: True if the row as selectd.
        """
        _key = tNoTemplKey()

        _key.notype_id = notype_id
        _key.corrtype_id = corrtype_id

        return self.try_select_one_by_key(_key)

    def try_select_one_by_key(self, _key: tNoTemplKey) -> bool:
        """
        Attempt to select the record with it's primary key.

        :param _key: Primary key of the table record.
        :returns: True if row was selected.
        """
        with dNoTemplSelectOne(self._dbcon) as _qry:
            _qry.exec(_key)
            if not _qry.fetch():
                return False

            self.rec = _qry.orec

        return True

    def select_one(self) -> "dNoTempl":
        """
        Selects the record, raises and error if it does not exist.

        :return: Self for convenience.
        """
        if not self.try_select_one():
            raise mettle.lib.xMettle(f"Not found: [table:dNoTempl, row:{self.rec}]", err_code=mettle.lib.xMettle.eCode.DBNotFound)

        return self

    def select_one_with(self, _rec: tNoTempl) -> "dNoTempl":
        """
        Attempt to select the record with the table record.

        :param _rec: Table record.
        :returns: Self for convenience.
        """
        if not self.try_select_one_with(_rec):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dNoTempl)")

        return self

    def select_one_deft(self,
                        notype_id: str,
                        corrtype_id: str) -> "dNoTempl":
        """
        Selects the record by its primary key columns, raises and error if it does not exist.

        :param notype_id: str
        :param corrtype_id: str
        """
        _key = tNoTemplKey()

        _key.notype_id = notype_id
        _key.corrtype_id = corrtype_id

        if not self.try_select_one_by_key(_key):
            raise mettle.lib.xMettle(f"Not found: [table:dNoTempl, row:{_key}]", err_code=mettle.lib.xMettle.eCode.DBNotFound)

        return self

    def select_one_by_key(self, _key: tNoTemplKey) -> "dNoTempl":
        """
        Attempt to select the record with it's primary key.

        :param _key: Primary key of the table record.
        :return: Self for convenience.
        """
        if not self.try_select_one_by_key(_key):
            raise mettle.lib.xMettle(f"Not found: [table:dNoTempl, row:{self.irec}]", xMettle.eCode.DBNotFound)

        return self

    def update_deft(self,
                    notype_id: str,
                    corrtype_id: str,
                    status: str,
                    lastcfg_id: int,
                    templ: dict,
                    res_list: dict,
                    modified_by: str):
        """
        Update the record by setting all column values.

        :param notype_id: str
        :param corrtype_id: str
        :param status: str
        :param lastcfg_id: int
        :param templ: dict
        :param res_list: dict
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        """
        self.rec.notype_id = notype_id
        self.rec.corrtype_id = corrtype_id
        self.rec.status = status
        self.rec.lastcfg_id = lastcfg_id
        self.rec.templ = templ
        self.rec.res_list = res_list
        self.rec.modified_by = modified_by

        self.update()

    def update(self, irec: tNoTempl = None):
        """
        Update the record in the database with the record or irec if it is not None.

        :param irec: If not None use this record to update the database.
        """
        if irec:
            self.rec._copy_from(irec)

        with dNoTemplUpdate(self._dbcon) as _qry:
            _qry.exec(self.rec)

        if irec:
            irec._copy_from(self.rec)

    def insert_deft(self,
                    notype_id: str,
                    corrtype_id: str,
                    status: str,
                    lastcfg_id: int,
                    templ: dict,
                    res_list: dict,
                    modified_by: str):
        """
        Insert the record setting all column values.

        :param notype_id: str
        :param corrtype_id: str
        :param status: str
        :param lastcfg_id: int
        :param templ: dict
        :param res_list: dict
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        """
        self.rec.notype_id = notype_id
        self.rec.corrtype_id = corrtype_id
        self.rec.status = status
        self.rec.lastcfg_id = lastcfg_id
        self.rec.templ = templ
        self.rec.res_list = res_list
        self.rec.modified_by = modified_by

        self.insert()

    def insert(self, irec: tNoTempl = None):
        """
        Insert the record in the database with the record or irec if it is not None.

        :param irec: If not None use this record to insert into the database.
        """
        if irec:
            self.rec._copy_from(irec)

        with dNoTemplInsert(self._dbcon) as _qry:
            _qry.exec(self.rec)

        if irec:
            irec._copy_from(self.rec)

