# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:23:42 2022
#  Target Database = postgresql
#
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.no_res import tNoRes

class dNoResUpdate:
    __slots__ = ("_dbcon", "_dbstmnt", "irec")

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tNoRes()

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt:
            self._dbstmnt.destroy()
            self._dbstmnt = None

    def exec_deft(self,
                  id: str,
                  filename: str,
                  mimetype: str,
                  content: bytearray,
                  modified_by: str) -> "dNoResUpdate":
        """
        Execute the query by setting all the inputs.

        :param id: str
        :param filename: str
        :param mimetype: str
        :param content: bytearray
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        :return: Self for convenience.
        """
        self.irec.id = id
        self.irec.filename = filename
        self.irec.mimetype = mimetype
        self.irec.content = content
        self.irec.modified_by = modified_by

        return self.exec()

    def exec(self, irec: tNoRes = None) -> "dNoResUpdate":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("NoResUpdate", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""update
  loco.NoRes
set
  filename = :filename,
  mimetype = :mimetype,
  content = :content,
  modified_by = :modified_by,
  tm_stamp = :tm_stamp
where
  id = :id""")

        self.irec.tm_stamp = self._dbcon.get_timestamp()

        self._dbstmnt.bind_in("id", self.irec.id, str, 128)
        self._dbstmnt.bind_in("filename", self.irec.filename, str, 256)
        self._dbstmnt.bind_in("mimetype", self.irec.mimetype, str, 128)
        self._dbstmnt.bind_in("content", self.irec.content, bytearray)
        self._dbstmnt.bind_in("modified_by", self.irec.modified_by, str, 128)
        self._dbstmnt.bind_in("tm_stamp", self.irec.tm_stamp, datetime.datetime)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

