# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:23:42 2022
#  Target Database = postgresql
#
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.no_res_key import tNoResKey
from bs_loco.db.tables.no_res import tNoRes

class dNoResSelectOne:
    __slots__ = ("_dbcon", "_dbstmnt", "irec", "orec")

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tNoResKey()
        self.orec     = None

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt:
            self._dbstmnt.destroy()
            self._dbstmnt = None

    def exec_deft(self,
                  id: str) -> "dNoResSelectOne":
        """
        Execute the query by setting all the inputs.

        :param id: str
        :return: Self for convenience.
        """
        self.irec.id = id

        return self.exec()

    def exec(self, irec: tNoResKey = None) -> "dNoResSelectOne":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("NoResSelectOne", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  id,
  filename,
  mimetype,
  content,
  modified_by,
  tm_stamp
from
  loco.NoRes
where
  id = :id""")

        self._dbstmnt.bind_in("id", self.irec.id, str, 128)

        self._dbstmnt.bind_out("id", str, 128)
        self._dbstmnt.bind_out("filename", str, 256)
        self._dbstmnt.bind_out("mimetype", str, 128)
        self._dbstmnt.bind_out("content", bytearray)
        self._dbstmnt.bind_out("modified_by", str, 128)
        self._dbstmnt.bind_out("tm_stamp", datetime.datetime)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    def fetch(self, must_exist: bool = False) -> bool:
        """
        Fetches the next row from the executed query.

        :param must_exist:
        :return: True if a row was fetched, else False.
        """
        if not self._dbcon.fetch(self._dbstmnt):
            if must_exist:
                raise mettle.lib.xMettle(f"Record not found: [table:NoRes, proc:SelectOne, row:{self.irec}]", err_code=mettle.lib.xMettle.eCode.DBNotFound)
            return False

        self.orec = tNoRes()

        self.orec.id = self._dbstmnt.result[0]
        self.orec.filename = self._dbstmnt.result[1]
        self.orec.mimetype = self._dbstmnt.result[2]
        self.orec.content = self._dbstmnt.result[3]
        self.orec.modified_by = self._dbstmnt.result[4]
        self.orec.tm_stamp = self._dbstmnt.result[5]

        return True

    def fetch_iter(self) -> tNoRes:
        """
        Yield all the rows one at a time.

        :return: Iterator for output rows
        """
        while self.fetch():
            yield self.orec

    def fetch_all(self, out_list: tNoRes.List, clear_list: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param out_list:
        :param clear_list:
        :return: Number of rows fetched.
        """
        if clear_list:
            out_list.clear()

        while self.fetch():
            out_list.append(self.orec)

        return len(out_list)

