# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:23:42 2022
#  Target Database = postgresql
#
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.msg_req_key import tMsgReqKey
from bs_loco.db.tables.msg_req import tMsgReq

class dMsgReqLockOne:
    __slots__ = ("_dbcon", "_dbstmnt", "irec", "orec")

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tMsgReqKey()
        self.orec     = None

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt:
            self._dbstmnt.destroy()
            self._dbstmnt = None

    def exec_deft(self,
                  id: int) -> "dMsgReqLockOne":
        """
        Execute the query by setting all the inputs.

        :param id: int
        :return: Self for convenience.
        """
        self.irec.id = id

        return self.exec()

    def exec(self, irec: tMsgReqKey = None) -> "dMsgReqLockOne":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("MsgReqLockOne", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  id,
  notype_id,
  priority,
  status,
  time_req,
  time_to_send,
  time_proc,
  msg_addr,
  msg_dict,
  cust_res,
  meta_data,
  modified_by,
  tm_stamp
from
  loco.MsgReq
where
  id = :id for update nowait""")

        self._dbstmnt.bind_in("id", self.irec.id, int, 8)

        self._dbstmnt.bind_out("id", int, 8)
        self._dbstmnt.bind_out("notype_id", str, 128)
        self._dbstmnt.bind_out("priority", int, 4)
        self._dbstmnt.bind_out("status", str, 1)
        self._dbstmnt.bind_out("time_req", datetime.datetime)
        self._dbstmnt.bind_out("time_to_send", datetime.datetime)
        self._dbstmnt.bind_out("time_proc", datetime.datetime)
        self._dbstmnt.bind_out("msg_addr", dict)
        self._dbstmnt.bind_out("msg_dict", dict)
        self._dbstmnt.bind_out("cust_res", bool)
        self._dbstmnt.bind_out("meta_data", dict)
        self._dbstmnt.bind_out("modified_by", str, 128)
        self._dbstmnt.bind_out("tm_stamp", datetime.datetime)

        self._dbcon.lock(self._dbstmnt)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    def fetch(self, must_exist: bool = False) -> bool:
        """
        Fetches the next row from the executed query.

        :param must_exist:
        :return: True if a row was fetched, else False.
        """
        if not self._dbcon.fetch(self._dbstmnt):
            if must_exist:
                raise mettle.lib.xMettle(f"Record not found: [table:MsgReq, proc:LockOne, row:{self.irec}]", err_code=mettle.lib.xMettle.eCode.DBNotFound)
            return False

        self.orec = tMsgReq()

        self.orec.id = self._dbstmnt.result[0]
        self.orec.notype_id = self._dbstmnt.result[1]
        self.orec.priority = self._dbstmnt.result[2]
        self.orec.status = self._dbstmnt.result[3]
        self.orec.time_req = self._dbstmnt.result[4]
        self.orec.time_to_send = self._dbstmnt.result[5]
        self.orec.time_proc = self._dbstmnt.result[6]
        self.orec.msg_addr = self._dbstmnt.result[7]
        self.orec.msg_dict = self._dbstmnt.result[8]
        self.orec.cust_res = self._dbstmnt.result[9]
        self.orec.meta_data = self._dbstmnt.result[10]
        self.orec.modified_by = self._dbstmnt.result[11]
        self.orec.tm_stamp = self._dbstmnt.result[12]

        return True

    def fetch_iter(self) -> tMsgReq:
        """
        Yield all the rows one at a time.

        :return: Iterator for output rows
        """
        while self.fetch():
            yield self.orec

    def fetch_all(self, out_list: tMsgReq.List, clear_list: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param out_list:
        :param clear_list:
        :return: Number of rows fetched.
        """
        if clear_list:
            out_list.clear()

        while self.fetch():
            out_list.append(self.orec)

        return len(out_list)

