# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:23:42 2022
#  Target Database = postgresql
#
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.msg_hist import tMsgHist

class dMsgHistInsert:
    __slots__ = ("_dbcon", "_dbstmnt", "irec")

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tMsgHist()

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt:
            self._dbstmnt.destroy()
            self._dbstmnt = None

    def exec_deft(self,
                  id: int,
                  status: str,
                  msgdate: datetime.datetime,
                  msg: dict) -> "dMsgHistInsert":
        """
        Execute the query by setting all the inputs.

        :param id: int
        :param status: str
        :param msgdate: datetime.datetime
        :param msg: dict
        :return: Self for convenience.
        """
        self.irec.id = id
        self.irec.status = status
        self.irec.msgdate = msgdate
        self.irec.msg = msg

        return self.exec()

    def exec(self, irec: tMsgHist = None) -> "dMsgHistInsert":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("MsgHistInsert", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""insert into loco.MsgHist (
  id,
  status,
  msgdate,
  msg
) values (
  :id,
  :status,
  :msgdate,
  :msg
)""")

        self._dbstmnt.bind_in("id", self.irec.id, int, 8)
        self._dbstmnt.bind_in("status", self.irec.status, str, 1)
        self._dbstmnt.bind_in("msgdate", self.irec.msgdate, datetime.datetime)
        self._dbstmnt.bind_in("msg", self.irec.msg, dict)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

