# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:23:42 2022
#  Target Database = postgresql
#
import asyncio
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.msg_hist import tMsgHist
from bs_loco.db.tables.msg_hist_key import tMsgHistKey

from .msg_hist_select_one import dMsgHistSelectOne
from .msg_hist_update import dMsgHistUpdate
from .msg_hist_insert import dMsgHistInsert

class dMsgHist:
    __slots__ = ("_dbcon", "rec")

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self.rec    = tMsgHist()
        self._dbcon = dbcon

    def __enter__(self):
        """
        DAO enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        DAO exit.
        """
        pass

    def try_select_one(self) -> bool:
        """
        Attempt to select the record.

        :return: True if the record was found.
        """
        _key = tMsgHistKey()

        self.rec._write_key(_key)

        return self.try_select_one_by_key(_key)

    def try_select_one_with(self, _rec: tMsgHist) -> bool:
        """
        Attempt to select the record using a table rec.

        :param _rec: The table rec to select with and into.
        :return: True if the row as selectd.
        """
        _key = tMsgHistKey()
        _rec._write_key(_key)

        if not self.try_select_one_by_key(_key):
            return False

        _rec._copy_from(self.rec)

        return True

    def try_select_one_deft(self,
                            id: int) -> bool:
        """
        Attempt to select the record by it's primary key columns.

        :param id: int
        :return: True if the row as selectd.
        """
        _key = tMsgHistKey()

        _key.id = id

        return self.try_select_one_by_key(_key)

    def try_select_one_by_key(self, _key: tMsgHistKey) -> bool:
        """
        Attempt to select the record with it's primary key.

        :param _key: Primary key of the table record.
        :returns: True if row was selected.
        """
        with dMsgHistSelectOne(self._dbcon) as _qry:
            _qry.exec(_key)
            if not _qry.fetch():
                return False

            self.rec = _qry.orec

        return True

    def select_one(self) -> "dMsgHist":
        """
        Selects the record, raises and error if it does not exist.

        :return: Self for convenience.
        """
        if not self.try_select_one():
            raise mettle.lib.xMettle(f"Not found: [table:dMsgHist, row:{self.rec}]", err_code=mettle.lib.xMettle.eCode.DBNotFound)

        return self

    def select_one_with(self, _rec: tMsgHist) -> "dMsgHist":
        """
        Attempt to select the record with the table record.

        :param _rec: Table record.
        :returns: Self for convenience.
        """
        if not self.try_select_one_with(_rec):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dMsgHist)")

        return self

    def select_one_deft(self,
                        id: int) -> "dMsgHist":
        """
        Selects the record by its primary key columns, raises and error if it does not exist.

        :param id: int
        """
        _key = tMsgHistKey()

        _key.id = id

        if not self.try_select_one_by_key(_key):
            raise mettle.lib.xMettle(f"Not found: [table:dMsgHist, row:{_key}]", err_code=mettle.lib.xMettle.eCode.DBNotFound)

        return self

    def select_one_by_key(self, _key: tMsgHistKey) -> "dMsgHist":
        """
        Attempt to select the record with it's primary key.

        :param _key: Primary key of the table record.
        :return: Self for convenience.
        """
        if not self.try_select_one_by_key(_key):
            raise mettle.lib.xMettle(f"Not found: [table:dMsgHist, row:{self.irec}]", xMettle.eCode.DBNotFound)

        return self

    def update_deft(self,
                    id: int,
                    status: str,
                    msgdate: datetime.datetime,
                    msg: dict):
        """
        Update the record by setting all column values.

        :param id: int
        :param status: str
        :param msgdate: datetime.datetime
        :param msg: dict
        """
        self.rec.id = id
        self.rec.status = status
        self.rec.msgdate = msgdate
        self.rec.msg = msg

        self.update()

    def update(self, irec: tMsgHist = None):
        """
        Update the record in the database with the record or irec if it is not None.

        :param irec: If not None use this record to update the database.
        """
        if irec:
            self.rec._copy_from(irec)

        with dMsgHistUpdate(self._dbcon) as _qry:
            _qry.exec(self.rec)

        if irec:
            irec._copy_from(self.rec)

    def insert_deft(self,
                    id: int,
                    status: str,
                    msgdate: datetime.datetime,
                    msg: dict):
        """
        Insert the record setting all column values.

        :param id: int
        :param status: str
        :param msgdate: datetime.datetime
        :param msg: dict
        """
        self.rec.id = id
        self.rec.status = status
        self.rec.msgdate = msgdate
        self.rec.msg = msg

        self.insert()

    def insert(self, irec: tMsgHist = None):
        """
        Insert the record in the database with the record or irec if it is not None.

        :param irec: If not None use this record to insert into the database.
        """
        if irec:
            self.rec._copy_from(irec)

        with dMsgHistInsert(self._dbcon) as _qry:
            _qry.exec(self.rec)

        if irec:
            irec._copy_from(self.rec)

