# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:23:42 2022
#  Target Database = postgresql
#
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.imsg_by_msg_req import iMsgByMsgReq
from bs_loco.db.tables.msg import tMsg

class dMsgByMsgReq:
    __slots__ = ("_dbcon", "_dbstmnt", "irec", "orec")

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = iMsgByMsgReq()
        self.orec     = None

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt:
            self._dbstmnt.destroy()
            self._dbstmnt = None

    def exec_deft(self,
                  msgreq_id: int) -> "dMsgByMsgReq":
        """
        Execute the query by setting all the inputs.

        :param msgreq_id: int
        :return: Self for convenience.
        """
        self.irec.msgreq_id = msgreq_id

        return self.exec()

    def exec(self, irec: iMsgByMsgReq = None) -> "dMsgByMsgReq":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("MsgByMsgReq", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  m.*
from
  loco.msg m
where
  m.msgreq_id = :msgreq_id""")

        self._dbstmnt.bind_in("msgreq_id", self.irec.msgreq_id, int, 8)

        self._dbstmnt.bind_out("id", int, 8)
        self._dbstmnt.bind_out("msgreq_id", int, 8)
        self._dbstmnt.bind_out("corrtype_id", str, 16)
        self._dbstmnt.bind_out("notype_id", str, 128)
        self._dbstmnt.bind_out("priority", int, 4)
        self._dbstmnt.bind_out("status", str, 1)
        self._dbstmnt.bind_out("retry_cnt", int, 4)
        self._dbstmnt.bind_out("fail_cnt", int, 4)
        self._dbstmnt.bind_out("time_sent", datetime.datetime)
        self._dbstmnt.bind_out("time_taken", float)
        self._dbstmnt.bind_out("corrprov_id", str, 16)
        self._dbstmnt.bind_out("msglog", dict)
        self._dbstmnt.bind_out("payload", dict)
        self._dbstmnt.bind_out("modified_by", str, 128)
        self._dbstmnt.bind_out("tm_stamp", datetime.datetime)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    def fetch(self, must_exist: bool = False) -> bool:
        """
        Fetches the next row from the executed query.

        :param must_exist:
        :return: True if a row was fetched, else False.
        """
        if not self._dbcon.fetch(self._dbstmnt):
            if must_exist:
                raise mettle.lib.xMettle(f"Record not found: [table:Msg, proc:ByMsgReq, row:{self.irec}]", err_code=mettle.lib.xMettle.eCode.DBNotFound)
            return False

        self.orec = tMsg()

        self.orec.id = self._dbstmnt.result[0]
        self.orec.msgreq_id = self._dbstmnt.result[1]
        self.orec.corrtype_id = self._dbstmnt.result[2]
        self.orec.notype_id = self._dbstmnt.result[3]
        self.orec.priority = self._dbstmnt.result[4]
        self.orec.status = self._dbstmnt.result[5]
        self.orec.retry_cnt = self._dbstmnt.result[6]
        self.orec.fail_cnt = self._dbstmnt.result[7]
        self.orec.time_sent = self._dbstmnt.result[8]
        self.orec.time_taken = self._dbstmnt.result[9]
        self.orec.corrprov_id = self._dbstmnt.result[10]
        self.orec.msglog = self._dbstmnt.result[11]
        self.orec.payload = self._dbstmnt.result[12]
        self.orec.modified_by = self._dbstmnt.result[13]
        self.orec.tm_stamp = self._dbstmnt.result[14]

        return True

    def fetch_iter(self) -> tMsg:
        """
        Yield all the rows one at a time.

        :return: Iterator for output rows
        """
        while self.fetch():
            yield self.orec

    def fetch_all(self, out_list: tMsg.List, clear_list: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param out_list:
        :param clear_list:
        :return: Number of rows fetched.
        """
        if clear_list:
            out_list.clear()

        while self.fetch():
            out_list.append(self.orec)

        return len(out_list)

