# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:23:42 2022
#  Target Database = postgresql
#
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.corr_prov_cfg import tCorrProvCfg

class dCorrProvCfgUpdate:
    __slots__ = ("_dbcon", "_dbstmnt", "irec")

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tCorrProvCfg()

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt:
            self._dbstmnt.destroy()
            self._dbstmnt = None

    def exec_deft(self,
                  id: int,
                  corrtype_id: str,
                  corrprov_id: str,
                  status: str,
                  notes: str,
                  activate: datetime.datetime,
                  deactivate: datetime.datetime,
                  cfg: dict,
                  modified_by: str) -> "dCorrProvCfgUpdate":
        """
        Execute the query by setting all the inputs.

        :param id: int
        :param corrtype_id: str
        :param corrprov_id: str
        :param status: str
        :param notes: str
        :param activate: datetime.datetime
        :param deactivate: datetime.datetime
        :param cfg: dict
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        :return: Self for convenience.
        """
        self.irec.id = id
        self.irec.corrtype_id = corrtype_id
        self.irec.corrprov_id = corrprov_id
        self.irec.status = status
        self.irec.notes = notes
        self.irec.activate = activate
        self.irec.deactivate = deactivate
        self.irec.cfg = cfg
        self.irec.modified_by = modified_by

        return self.exec()

    def exec(self, irec: tCorrProvCfg = None) -> "dCorrProvCfgUpdate":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("CorrProvCfgUpdate", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""update
  loco.CorrProvCfg
set
  corrtype_id = :corrtype_id,
  corrprov_id = :corrprov_id,
  status = :status,
  notes = :notes,
  activate = :activate,
  deactivate = :deactivate,
  cfg = :cfg,
  modified_by = :modified_by,
  tm_stamp = :tm_stamp
where
  id = :id""")

        self.irec.tm_stamp = self._dbcon.get_timestamp()

        self._dbstmnt.bind_in("id", self.irec.id, int, 8)
        self._dbstmnt.bind_in("corrtype_id", self.irec.corrtype_id, str, 16)
        self._dbstmnt.bind_in("corrprov_id", self.irec.corrprov_id, str, 16)
        self._dbstmnt.bind_in("status", self.irec.status, str, 1)
        self._dbstmnt.bind_in("notes", self.irec.notes, str, 4096)
        self._dbstmnt.bind_in("activate", self.irec.activate, datetime.datetime)
        self._dbstmnt.bind_in("deactivate", self.irec.deactivate, datetime.datetime)
        self._dbstmnt.bind_in("cfg", self.irec.cfg, dict)
        self._dbstmnt.bind_in("modified_by", self.irec.modified_by, str, 128)
        self._dbstmnt.bind_in("tm_stamp", self.irec.tm_stamp, datetime.datetime)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

