# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:23:42 2022
#  Target Database = postgresql
#
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.config import tConfig

class dConfigInsert:
    __slots__ = ("_dbcon", "_dbstmnt", "irec")

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tConfig()

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt:
            self._dbstmnt.destroy()
            self._dbstmnt = None

    def exec_deft(self,
                  id: str,
                  descr: str,
                  value: str,
                  grp: str,
                  modified_by: str,
                  tm_stamp: datetime.datetime) -> "dConfigInsert":
        """
        Execute the query by setting all the inputs.

        :param id: str
        :param descr: str
        :param value: str
        :param grp: str
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        :return: Self for convenience.
        """
        self.irec.id = id
        self.irec.descr = descr
        self.irec.value = value
        self.irec.grp = grp
        self.irec.modified_by = modified_by
        self.irec.tm_stamp = tm_stamp

        return self.exec()

    def exec(self, irec: tConfig = None) -> "dConfigInsert":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("ConfigInsert", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""insert into loco.Config (
  id,
  descr,
  value,
  grp,
  modified_by,
  tm_stamp
) values (
  :id,
  :descr,
  :value,
  :grp,
  :modified_by,
  :tm_stamp
)""")

        self.irec.tm_stamp = self._dbcon.get_timestamp()

        self._dbstmnt.bind_in("id", self.irec.id, str)
        self._dbstmnt.bind_in("descr", self.irec.descr, str)
        self._dbstmnt.bind_in("value", self.irec.value, str)
        self._dbstmnt.bind_in("grp", self.irec.grp, str)
        self._dbstmnt.bind_in("modified_by", self.irec.modified_by, str)
        self._dbstmnt.bind_in("tm_stamp", self.irec.tm_stamp, datetime.datetime)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

