'''
exceptions.py: exceptions defined by Handprint

Authors
-------

Michael Hucka <mhucka@caltech.edu> -- Caltech Library

Copyright
---------

Copyright (c) 2018-2020 by the California Institute of Technology.  This code
is open-source software released under a 3-clause BSD license.  Please see the
file "LICENSE" for more information.
'''


# Base class.
# .............................................................................
# The base class makes it possible to use a single test to distinguish between
# exceptions generated by Handprint and exceptions generated by something else.

class HandprintException(Exception):
    '''Base class for Handprint exceptions.'''
    pass


# Exception classes.
# .............................................................................

class CannotProceed(HandprintException):
    '''A recognizable condition caused an early exit from the program.'''
    pass

class UserCancelled(HandprintException):
    '''The user elected to cancel/quit the program.'''
    pass

class NetworkFailure(HandprintException):
    '''Unrecoverable problem involving network operations.'''
    pass

class NoContent(HandprintException):
    '''No content found at the given location.'''
    pass

class CorruptedContent(HandprintException):
    '''Content corruption has been detected.'''
    pass

class AuthFailure(HandprintException):
    '''Problem obtaining or using authentication credentials.'''
    pass

class ServiceFailure(HandprintException):
    '''Unrecoverable problem involving a remote service.'''
    pass

class RateLimitExceeded(HandprintException):
    '''The service flagged reports that its rate limits have been exceeded.'''
    pass

class InternalError(HandprintException):
    '''Unrecoverable problem involving eprints2bags itself.'''
    pass
