"use strict";
// cdk8s-server: http server which synthesizes cdk operators
// ------------------------------------------------------------------------------------
// request body should include an input manifest for a single resource
// response will include the synthesized output manifest
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
const yaml = require("yaml");
const server_1 = require("../server");
async function main() {
    var _a;
    const command = (_a = resolveAppFromCommandLine()) !== null && _a !== void 0 ? _a : resolveAppFromConfig();
    if (!command) {
        throw new Error('unable to determine how to execute your CDK8s app. You can either pass a command line as arguments (cdk8s-server COMMAND) or specify the "app" attribute in cdk8s.yaml');
    }
    // needed in docker
    process.on('SIGINT', () => process.exit());
    ;
    const server = new server_1.Server({ appCommand: command });
    const port = await server.listen();
    console.error(`Listening on ${port}`);
    console.error(`- App command: ${command}`);
    console.error('- Request body should include a single k8s resource in JSON format');
    console.error(`- Request will be piped through STDIN to "${command}"`);
    console.error('- Response is the STDOUT and expected to be a multi-resource yaml manifest');
}
main().catch((e) => {
    console.error(e.stack);
    process.exit(1);
});
function resolveAppFromConfig() {
    if (!fs.existsSync('cdk8s.yaml')) {
        return undefined;
    }
    const config = yaml.parse(fs.readFileSync('cdk8s.yaml', 'utf-8'));
    return config.app;
}
function resolveAppFromCommandLine() {
    if (process.argv.length < 3) {
        return undefined;
    }
    return process.argv.slice(2).join(' ');
}
//# sourceMappingURL=data:application/json;base64,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