# coding: utf-8

"""
    ChronosDB swagger

    ChronosDB time series database API  # noqa: E501

    The version of the OpenAPI document: 0.1
    Contact: apiteam@chronosdb.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class TSI(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'tsi': 'str',
        'space': 'str',
        'collection': 'str',
        'name': 'str'
    }

    attribute_map = {
        'tsi': 'tsi',
        'space': 'space',
        'collection': 'collection',
        'name': 'name'
    }

    def __init__(self, tsi=None, space=None, collection=None, name=None):  # noqa: E501
        """TSI - a model defined in OpenAPI"""  # noqa: E501

        self._tsi = None
        self._space = None
        self._collection = None
        self._name = None
        self.discriminator = None

        if tsi is not None:
            self.tsi = tsi
        if space is not None:
            self.space = space
        if collection is not None:
            self.collection = collection
        if name is not None:
            self.name = name

    @property
    def tsi(self):
        """Gets the tsi of this TSI.  # noqa: E501

        Time Series Identifier as a string where ts name, collection name and space name as separated by comma  # noqa: E501

        :return: The tsi of this TSI.  # noqa: E501
        :rtype: str
        """
        return self._tsi

    @tsi.setter
    def tsi(self, tsi):
        """Sets the tsi of this TSI.

        Time Series Identifier as a string where ts name, collection name and space name as separated by comma  # noqa: E501

        :param tsi: The tsi of this TSI.  # noqa: E501
        :type: str
        """
        if tsi is not None and len(tsi) < 1:
            raise ValueError("Invalid value for `tsi`, length must be greater than or equal to `1`")  # noqa: E501
        if tsi is not None and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{0,59}.[a-zA-Z][_a-zA-Z0-9]{4,60}.[a-zA-Z][_a-zA-Z0-9]{4,60}$', tsi):  # noqa: E501
            raise ValueError(r"Invalid value for `tsi`, must be a follow pattern or equal to `/^[a-zA-Z][_a-zA-Z0-9]{0,59}.[a-zA-Z][_a-zA-Z0-9]{4,60}.[a-zA-Z][_a-zA-Z0-9]{4,60}$/`")  # noqa: E501

        self._tsi = tsi

    @property
    def space(self):
        """Gets the space of this TSI.  # noqa: E501


        :return: The space of this TSI.  # noqa: E501
        :rtype: str
        """
        return self._space

    @space.setter
    def space(self, space):
        """Sets the space of this TSI.


        :param space: The space of this TSI.  # noqa: E501
        :type: str
        """
        if space is not None and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', space):  # noqa: E501
            raise ValueError(r"Invalid value for `space`, must be a follow pattern or equal to `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501

        self._space = space

    @property
    def collection(self):
        """Gets the collection of this TSI.  # noqa: E501


        :return: The collection of this TSI.  # noqa: E501
        :rtype: str
        """
        return self._collection

    @collection.setter
    def collection(self, collection):
        """Sets the collection of this TSI.


        :param collection: The collection of this TSI.  # noqa: E501
        :type: str
        """
        if collection is not None and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', collection):  # noqa: E501
            raise ValueError(r"Invalid value for `collection`, must be a follow pattern or equal to `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501

        self._collection = collection

    @property
    def name(self):
        """Gets the name of this TSI.  # noqa: E501

        unique series name in a collection  # noqa: E501

        :return: The name of this TSI.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this TSI.

        unique series name in a collection  # noqa: E501

        :param name: The name of this TSI.  # noqa: E501
        :type: str
        """
        if name is not None and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{0,59}$', name):  # noqa: E501
            raise ValueError(r"Invalid value for `name`, must be a follow pattern or equal to `/^[a-zA-Z][_a-zA-Z0-9]{0,59}$/`")  # noqa: E501

        self._name = name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TSI):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
