# coding: utf-8

"""
    ChronosDB swagger

    ChronosDB time series database API  # noqa: E501

    The version of the OpenAPI document: 0.1
    Contact: apiteam@chronosdb.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class TimeSeriesCore(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'tsid': 'str',
        'coll_id': 'str',
        'dtype': 'DType',
        'dparams': 'object',
        'itype': 'IType',
        'freq': 'Frequency',
        'fparams': 'object',
        'entity': 'int',
        'variable': 'str'
    }

    attribute_map = {
        'tsid': 'tsid',
        'coll_id': 'collId',
        'dtype': 'dtype',
        'dparams': 'dparams',
        'itype': 'itype',
        'freq': 'freq',
        'fparams': 'fparams',
        'entity': 'entity',
        'variable': 'variable'
    }

    def __init__(self, tsid=None, coll_id=None, dtype=None, dparams=None, itype=None, freq=None, fparams=None, entity=None, variable=None):  # noqa: E501
        """TimeSeriesCore - a model defined in OpenAPI"""  # noqa: E501

        self._tsid = None
        self._coll_id = None
        self._dtype = None
        self._dparams = None
        self._itype = None
        self._freq = None
        self._fparams = None
        self._entity = None
        self._variable = None
        self.discriminator = None

        if tsid is not None:
            self.tsid = tsid
        if coll_id is not None:
            self.coll_id = coll_id
        if dtype is not None:
            self.dtype = dtype
        if dparams is not None:
            self.dparams = dparams
        if itype is not None:
            self.itype = itype
        if freq is not None:
            self.freq = freq
        if fparams is not None:
            self.fparams = fparams
        if entity is not None:
            self.entity = entity
        if variable is not None:
            self.variable = variable

    @property
    def tsid(self):
        """Gets the tsid of this TimeSeriesCore.  # noqa: E501


        :return: The tsid of this TimeSeriesCore.  # noqa: E501
        :rtype: str
        """
        return self._tsid

    @tsid.setter
    def tsid(self, tsid):
        """Sets the tsid of this TimeSeriesCore.


        :param tsid: The tsid of this TimeSeriesCore.  # noqa: E501
        :type: str
        """
        if tsid is not None and not re.search(r'[0-9a-fA-F]{24}', tsid):  # noqa: E501
            raise ValueError(r"Invalid value for `tsid`, must be a follow pattern or equal to `/[0-9a-fA-F]{24}/`")  # noqa: E501

        self._tsid = tsid

    @property
    def coll_id(self):
        """Gets the coll_id of this TimeSeriesCore.  # noqa: E501


        :return: The coll_id of this TimeSeriesCore.  # noqa: E501
        :rtype: str
        """
        return self._coll_id

    @coll_id.setter
    def coll_id(self, coll_id):
        """Sets the coll_id of this TimeSeriesCore.


        :param coll_id: The coll_id of this TimeSeriesCore.  # noqa: E501
        :type: str
        """
        if coll_id is not None and not re.search(r'[0-9a-fA-F]{24}', coll_id):  # noqa: E501
            raise ValueError(r"Invalid value for `coll_id`, must be a follow pattern or equal to `/[0-9a-fA-F]{24}/`")  # noqa: E501

        self._coll_id = coll_id

    @property
    def dtype(self):
        """Gets the dtype of this TimeSeriesCore.  # noqa: E501


        :return: The dtype of this TimeSeriesCore.  # noqa: E501
        :rtype: DType
        """
        return self._dtype

    @dtype.setter
    def dtype(self, dtype):
        """Sets the dtype of this TimeSeriesCore.


        :param dtype: The dtype of this TimeSeriesCore.  # noqa: E501
        :type: DType
        """

        self._dtype = dtype

    @property
    def dparams(self):
        """Gets the dparams of this TimeSeriesCore.  # noqa: E501

        parameters of data type, e.g. enum  # noqa: E501

        :return: The dparams of this TimeSeriesCore.  # noqa: E501
        :rtype: object
        """
        return self._dparams

    @dparams.setter
    def dparams(self, dparams):
        """Sets the dparams of this TimeSeriesCore.

        parameters of data type, e.g. enum  # noqa: E501

        :param dparams: The dparams of this TimeSeriesCore.  # noqa: E501
        :type: object
        """

        self._dparams = dparams

    @property
    def itype(self):
        """Gets the itype of this TimeSeriesCore.  # noqa: E501


        :return: The itype of this TimeSeriesCore.  # noqa: E501
        :rtype: IType
        """
        return self._itype

    @itype.setter
    def itype(self, itype):
        """Sets the itype of this TimeSeriesCore.


        :param itype: The itype of this TimeSeriesCore.  # noqa: E501
        :type: IType
        """

        self._itype = itype

    @property
    def freq(self):
        """Gets the freq of this TimeSeriesCore.  # noqa: E501


        :return: The freq of this TimeSeriesCore.  # noqa: E501
        :rtype: Frequency
        """
        return self._freq

    @freq.setter
    def freq(self, freq):
        """Sets the freq of this TimeSeriesCore.


        :param freq: The freq of this TimeSeriesCore.  # noqa: E501
        :type: Frequency
        """

        self._freq = freq

    @property
    def fparams(self):
        """Gets the fparams of this TimeSeriesCore.  # noqa: E501

        parameters of time index type, e.g. time zone if applicable, pivot date, etc  # noqa: E501

        :return: The fparams of this TimeSeriesCore.  # noqa: E501
        :rtype: object
        """
        return self._fparams

    @fparams.setter
    def fparams(self, fparams):
        """Sets the fparams of this TimeSeriesCore.

        parameters of time index type, e.g. time zone if applicable, pivot date, etc  # noqa: E501

        :param fparams: The fparams of this TimeSeriesCore.  # noqa: E501
        :type: object
        """

        self._fparams = fparams

    @property
    def entity(self):
        """Gets the entity of this TimeSeriesCore.  # noqa: E501

        Entity is used in panel data to associate time series with a unit or individual, e.g. household or company, etc. It is used together with variable name to create a unique reference to time series in a panel collection, (entity, variable). Entity is immutable  # noqa: E501

        :return: The entity of this TimeSeriesCore.  # noqa: E501
        :rtype: int
        """
        return self._entity

    @entity.setter
    def entity(self, entity):
        """Sets the entity of this TimeSeriesCore.

        Entity is used in panel data to associate time series with a unit or individual, e.g. household or company, etc. It is used together with variable name to create a unique reference to time series in a panel collection, (entity, variable). Entity is immutable  # noqa: E501

        :param entity: The entity of this TimeSeriesCore.  # noqa: E501
        :type: int
        """

        self._entity = entity

    @property
    def variable(self):
        """Gets the variable of this TimeSeriesCore.  # noqa: E501

        variable is used in panel data to associate time series with a cross-sectional measure, e.g. eye color, etc. It is used together with variable name to create a unique reference to time series in a panel collection, (entity, variable). Variable is immutable  # noqa: E501

        :return: The variable of this TimeSeriesCore.  # noqa: E501
        :rtype: str
        """
        return self._variable

    @variable.setter
    def variable(self, variable):
        """Sets the variable of this TimeSeriesCore.

        variable is used in panel data to associate time series with a cross-sectional measure, e.g. eye color, etc. It is used together with variable name to create a unique reference to time series in a panel collection, (entity, variable). Variable is immutable  # noqa: E501

        :param variable: The variable of this TimeSeriesCore.  # noqa: E501
        :type: str
        """
        if variable is not None and not re.search(r'^[a-zA-Z0-9]{6,60}$', variable):  # noqa: E501
            raise ValueError(r"Invalid value for `variable`, must be a follow pattern or equal to `/^[a-zA-Z0-9]{6,60}$/`")  # noqa: E501

        self._variable = variable

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TimeSeriesCore):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
