# coding: utf-8

"""
    ChronosDB swagger

    ChronosDB time series database API  # noqa: E501

    The version of the OpenAPI document: 0.1
    Contact: apiteam@chronosdb.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class RawSingleTimeSeriesData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'tsid': 'str',
        'coll_id': 'str',
        'name': 'str',
        'nobs': 'int',
        'index': 'list[int]',
        'values': 'list[object]',
        'status': 'list[int]',
        'index_format': 'RawIndexFormat',
        'dtype': 'DType',
        'dparams': 'object',
        'itype': 'IType',
        'freq': 'Frequency',
        'fparams': 'object',
        'vintage': 'RawSingleTimeSeriesDataVintage'
    }

    attribute_map = {
        'tsid': 'tsid',
        'coll_id': 'collId',
        'name': 'name',
        'nobs': 'nobs',
        'index': 'index',
        'values': 'values',
        'status': 'status',
        'index_format': 'indexFormat',
        'dtype': 'dtype',
        'dparams': 'dparams',
        'itype': 'itype',
        'freq': 'freq',
        'fparams': 'fparams',
        'vintage': 'vintage'
    }

    def __init__(self, tsid=None, coll_id=None, name=None, nobs=None, index=None, values=None, status=None, index_format=None, dtype=None, dparams=None, itype=None, freq=None, fparams=None, vintage=None):  # noqa: E501
        """RawSingleTimeSeriesData - a model defined in OpenAPI"""  # noqa: E501

        self._tsid = None
        self._coll_id = None
        self._name = None
        self._nobs = None
        self._index = None
        self._values = None
        self._status = None
        self._index_format = None
        self._dtype = None
        self._dparams = None
        self._itype = None
        self._freq = None
        self._fparams = None
        self._vintage = None
        self.discriminator = None

        if tsid is not None:
            self.tsid = tsid
        if coll_id is not None:
            self.coll_id = coll_id
        if name is not None:
            self.name = name
        if nobs is not None:
            self.nobs = nobs
        if index is not None:
            self.index = index
        if values is not None:
            self.values = values
        self.status = status
        if index_format is not None:
            self.index_format = index_format
        if dtype is not None:
            self.dtype = dtype
        if dparams is not None:
            self.dparams = dparams
        if itype is not None:
            self.itype = itype
        if freq is not None:
            self.freq = freq
        if fparams is not None:
            self.fparams = fparams
        self.vintage = vintage

    @property
    def tsid(self):
        """Gets the tsid of this RawSingleTimeSeriesData.  # noqa: E501


        :return: The tsid of this RawSingleTimeSeriesData.  # noqa: E501
        :rtype: str
        """
        return self._tsid

    @tsid.setter
    def tsid(self, tsid):
        """Sets the tsid of this RawSingleTimeSeriesData.


        :param tsid: The tsid of this RawSingleTimeSeriesData.  # noqa: E501
        :type: str
        """
        if tsid is not None and not re.search(r'[0-9a-fA-F]{24}', tsid):  # noqa: E501
            raise ValueError(r"Invalid value for `tsid`, must be a follow pattern or equal to `/[0-9a-fA-F]{24}/`")  # noqa: E501

        self._tsid = tsid

    @property
    def coll_id(self):
        """Gets the coll_id of this RawSingleTimeSeriesData.  # noqa: E501


        :return: The coll_id of this RawSingleTimeSeriesData.  # noqa: E501
        :rtype: str
        """
        return self._coll_id

    @coll_id.setter
    def coll_id(self, coll_id):
        """Sets the coll_id of this RawSingleTimeSeriesData.


        :param coll_id: The coll_id of this RawSingleTimeSeriesData.  # noqa: E501
        :type: str
        """
        if coll_id is not None and not re.search(r'[0-9a-fA-F]{24}', coll_id):  # noqa: E501
            raise ValueError(r"Invalid value for `coll_id`, must be a follow pattern or equal to `/[0-9a-fA-F]{24}/`")  # noqa: E501

        self._coll_id = coll_id

    @property
    def name(self):
        """Gets the name of this RawSingleTimeSeriesData.  # noqa: E501

        time series unique name in a collection  # noqa: E501

        :return: The name of this RawSingleTimeSeriesData.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this RawSingleTimeSeriesData.

        time series unique name in a collection  # noqa: E501

        :param name: The name of this RawSingleTimeSeriesData.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def nobs(self):
        """Gets the nobs of this RawSingleTimeSeriesData.  # noqa: E501

        number of observations  # noqa: E501

        :return: The nobs of this RawSingleTimeSeriesData.  # noqa: E501
        :rtype: int
        """
        return self._nobs

    @nobs.setter
    def nobs(self, nobs):
        """Sets the nobs of this RawSingleTimeSeriesData.

        number of observations  # noqa: E501

        :param nobs: The nobs of this RawSingleTimeSeriesData.  # noqa: E501
        :type: int
        """
        if nobs is not None and nobs < 0:  # noqa: E501
            raise ValueError("Invalid value for `nobs`, must be a value greater than or equal to `0`")  # noqa: E501

        self._nobs = nobs

    @property
    def index(self):
        """Gets the index of this RawSingleTimeSeriesData.  # noqa: E501


        :return: The index of this RawSingleTimeSeriesData.  # noqa: E501
        :rtype: list[int]
        """
        return self._index

    @index.setter
    def index(self, index):
        """Sets the index of this RawSingleTimeSeriesData.


        :param index: The index of this RawSingleTimeSeriesData.  # noqa: E501
        :type: list[int]
        """

        self._index = index

    @property
    def values(self):
        """Gets the values of this RawSingleTimeSeriesData.  # noqa: E501


        :return: The values of this RawSingleTimeSeriesData.  # noqa: E501
        :rtype: list[object]
        """
        return self._values

    @values.setter
    def values(self, values):
        """Sets the values of this RawSingleTimeSeriesData.


        :param values: The values of this RawSingleTimeSeriesData.  # noqa: E501
        :type: list[object]
        """

        self._values = values

    @property
    def status(self):
        """Gets the status of this RawSingleTimeSeriesData.  # noqa: E501


        :return: The status of this RawSingleTimeSeriesData.  # noqa: E501
        :rtype: list[int]
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this RawSingleTimeSeriesData.


        :param status: The status of this RawSingleTimeSeriesData.  # noqa: E501
        :type: list[int]
        """

        self._status = status

    @property
    def index_format(self):
        """Gets the index_format of this RawSingleTimeSeriesData.  # noqa: E501


        :return: The index_format of this RawSingleTimeSeriesData.  # noqa: E501
        :rtype: RawIndexFormat
        """
        return self._index_format

    @index_format.setter
    def index_format(self, index_format):
        """Sets the index_format of this RawSingleTimeSeriesData.


        :param index_format: The index_format of this RawSingleTimeSeriesData.  # noqa: E501
        :type: RawIndexFormat
        """

        self._index_format = index_format

    @property
    def dtype(self):
        """Gets the dtype of this RawSingleTimeSeriesData.  # noqa: E501


        :return: The dtype of this RawSingleTimeSeriesData.  # noqa: E501
        :rtype: DType
        """
        return self._dtype

    @dtype.setter
    def dtype(self, dtype):
        """Sets the dtype of this RawSingleTimeSeriesData.


        :param dtype: The dtype of this RawSingleTimeSeriesData.  # noqa: E501
        :type: DType
        """

        self._dtype = dtype

    @property
    def dparams(self):
        """Gets the dparams of this RawSingleTimeSeriesData.  # noqa: E501


        :return: The dparams of this RawSingleTimeSeriesData.  # noqa: E501
        :rtype: object
        """
        return self._dparams

    @dparams.setter
    def dparams(self, dparams):
        """Sets the dparams of this RawSingleTimeSeriesData.


        :param dparams: The dparams of this RawSingleTimeSeriesData.  # noqa: E501
        :type: object
        """

        self._dparams = dparams

    @property
    def itype(self):
        """Gets the itype of this RawSingleTimeSeriesData.  # noqa: E501


        :return: The itype of this RawSingleTimeSeriesData.  # noqa: E501
        :rtype: IType
        """
        return self._itype

    @itype.setter
    def itype(self, itype):
        """Sets the itype of this RawSingleTimeSeriesData.


        :param itype: The itype of this RawSingleTimeSeriesData.  # noqa: E501
        :type: IType
        """

        self._itype = itype

    @property
    def freq(self):
        """Gets the freq of this RawSingleTimeSeriesData.  # noqa: E501


        :return: The freq of this RawSingleTimeSeriesData.  # noqa: E501
        :rtype: Frequency
        """
        return self._freq

    @freq.setter
    def freq(self, freq):
        """Sets the freq of this RawSingleTimeSeriesData.


        :param freq: The freq of this RawSingleTimeSeriesData.  # noqa: E501
        :type: Frequency
        """

        self._freq = freq

    @property
    def fparams(self):
        """Gets the fparams of this RawSingleTimeSeriesData.  # noqa: E501


        :return: The fparams of this RawSingleTimeSeriesData.  # noqa: E501
        :rtype: object
        """
        return self._fparams

    @fparams.setter
    def fparams(self, fparams):
        """Sets the fparams of this RawSingleTimeSeriesData.


        :param fparams: The fparams of this RawSingleTimeSeriesData.  # noqa: E501
        :type: object
        """

        self._fparams = fparams

    @property
    def vintage(self):
        """Gets the vintage of this RawSingleTimeSeriesData.  # noqa: E501


        :return: The vintage of this RawSingleTimeSeriesData.  # noqa: E501
        :rtype: RawSingleTimeSeriesDataVintage
        """
        return self._vintage

    @vintage.setter
    def vintage(self, vintage):
        """Sets the vintage of this RawSingleTimeSeriesData.


        :param vintage: The vintage of this RawSingleTimeSeriesData.  # noqa: E501
        :type: RawSingleTimeSeriesDataVintage
        """

        self._vintage = vintage

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RawSingleTimeSeriesData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
