# coding: utf-8

"""
    ChronosDB swagger

    ChronosDB time series database API  # noqa: E501

    The version of the OpenAPI document: 0.1
    Contact: apiteam@chronosdb.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openapi_client.api_client import ApiClient
from openapi_client.exceptions import (
    ApiTypeError,
    ApiValueError
)


class VintageApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def app_api_vintages_get(self, space_name, coll_name, name, **kwargs):  # noqa: E501
        """Retrieve a vintage tag with metadata  # noqa: E501

        Retrieve a vintage tag with metadata  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_vintages_get(space_name, coll_name, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str name: vintage tag (required)
        :param bool meta: should include vintage metadata
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Vintage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_vintages_get_with_http_info(space_name, coll_name, name, **kwargs)  # noqa: E501

    def app_api_vintages_get_with_http_info(self, space_name, coll_name, name, **kwargs):  # noqa: E501
        """Retrieve a vintage tag with metadata  # noqa: E501

        Retrieve a vintage tag with metadata  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_vintages_get_with_http_info(space_name, coll_name, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str name: vintage tag (required)
        :param bool meta: should include vintage metadata
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Vintage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'coll_name', 'name', 'meta']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_vintages_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_vintages_get`")  # noqa: E501
        # verify the required parameter 'coll_name' is set
        if ('coll_name' not in local_var_params or
                local_var_params['coll_name'] is None):
            raise ApiValueError("Missing the required parameter `coll_name` when calling `app_api_vintages_get`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in local_var_params or
                local_var_params['name'] is None):
            raise ApiValueError("Missing the required parameter `name` when calling `app_api_vintages_get`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_vintages_get`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'coll_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['coll_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_name` when calling `app_api_vintages_get`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501
        if 'coll_name' in local_var_params:
            path_params['coll_name'] = local_var_params['coll_name']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []
        if 'meta' in local_var_params:
            query_params.append(('meta', local_var_params['meta']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/vintage/{space_name}/{coll_name}/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Vintage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_vintages_get_list(self, space_name, coll_name, **kwargs):  # noqa: E501
        """List vintage tags in a collection  # noqa: E501

        List vintage tags in a collection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_vintages_get_list(space_name, coll_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str tsid: time series id
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[VintageSummary]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_vintages_get_list_with_http_info(space_name, coll_name, **kwargs)  # noqa: E501

    def app_api_vintages_get_list_with_http_info(self, space_name, coll_name, **kwargs):  # noqa: E501
        """List vintage tags in a collection  # noqa: E501

        List vintage tags in a collection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_vintages_get_list_with_http_info(space_name, coll_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str tsid: time series id
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[VintageSummary], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'coll_name', 'tsid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_vintages_get_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_vintages_get_list`")  # noqa: E501
        # verify the required parameter 'coll_name' is set
        if ('coll_name' not in local_var_params or
                local_var_params['coll_name'] is None):
            raise ApiValueError("Missing the required parameter `coll_name` when calling `app_api_vintages_get_list`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_vintages_get_list`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'coll_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['coll_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_name` when calling `app_api_vintages_get_list`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'tsid' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['tsid']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `tsid` when calling `app_api_vintages_get_list`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501
        if 'coll_name' in local_var_params:
            path_params['coll_name'] = local_var_params['coll_name']  # noqa: E501

        query_params = []
        if 'tsid' in local_var_params:
            query_params.append(('tsid', local_var_params['tsid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/vintage/{space_name}/{coll_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[VintageSummary]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_vintages_name_history(self, space_name, coll_name, name, **kwargs):  # noqa: E501
        """Retrieve a vintage tag with metadata  # noqa: E501

        Retrieve a vintage tag with metadata  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_vintages_name_history(space_name, coll_name, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str name: vintage tag (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_vintages_name_history_with_http_info(space_name, coll_name, name, **kwargs)  # noqa: E501

    def app_api_vintages_name_history_with_http_info(self, space_name, coll_name, name, **kwargs):  # noqa: E501
        """Retrieve a vintage tag with metadata  # noqa: E501

        Retrieve a vintage tag with metadata  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_vintages_name_history_with_http_info(space_name, coll_name, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str name: vintage tag (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'coll_name', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_vintages_name_history" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_vintages_name_history`")  # noqa: E501
        # verify the required parameter 'coll_name' is set
        if ('coll_name' not in local_var_params or
                local_var_params['coll_name'] is None):
            raise ApiValueError("Missing the required parameter `coll_name` when calling `app_api_vintages_name_history`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in local_var_params or
                local_var_params['name'] is None):
            raise ApiValueError("Missing the required parameter `name` when calling `app_api_vintages_name_history`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_vintages_name_history`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'coll_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['coll_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_name` when calling `app_api_vintages_name_history`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501
        if 'coll_name' in local_var_params:
            path_params['coll_name'] = local_var_params['coll_name']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/vintage/{space_name}/{coll_name}/{name}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_vintages_put(self, space_name, coll_name, name, vintage_update, **kwargs):  # noqa: E501
        """Update vintage tag  # noqa: E501

        Update a vintage tag for a revision of a time series. Vintage tag is a human-friendly label assigned to datetime when revision was recorded. Vintages are unique within the collection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_vintages_put(space_name, coll_name, name, vintage_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str name: vintage tag (required)
        :param VintageUpdate vintage_update: vintage tag (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: VintageSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_vintages_put_with_http_info(space_name, coll_name, name, vintage_update, **kwargs)  # noqa: E501

    def app_api_vintages_put_with_http_info(self, space_name, coll_name, name, vintage_update, **kwargs):  # noqa: E501
        """Update vintage tag  # noqa: E501

        Update a vintage tag for a revision of a time series. Vintage tag is a human-friendly label assigned to datetime when revision was recorded. Vintages are unique within the collection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_vintages_put_with_http_info(space_name, coll_name, name, vintage_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str name: vintage tag (required)
        :param VintageUpdate vintage_update: vintage tag (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(VintageSummary, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'coll_name', 'name', 'vintage_update']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_vintages_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_vintages_put`")  # noqa: E501
        # verify the required parameter 'coll_name' is set
        if ('coll_name' not in local_var_params or
                local_var_params['coll_name'] is None):
            raise ApiValueError("Missing the required parameter `coll_name` when calling `app_api_vintages_put`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in local_var_params or
                local_var_params['name'] is None):
            raise ApiValueError("Missing the required parameter `name` when calling `app_api_vintages_put`")  # noqa: E501
        # verify the required parameter 'vintage_update' is set
        if ('vintage_update' not in local_var_params or
                local_var_params['vintage_update'] is None):
            raise ApiValueError("Missing the required parameter `vintage_update` when calling `app_api_vintages_put`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_vintages_put`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'coll_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['coll_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_name` when calling `app_api_vintages_put`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501
        if 'coll_name' in local_var_params:
            path_params['coll_name'] = local_var_params['coll_name']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vintage_update' in local_var_params:
            body_params = local_var_params['vintage_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/vintage/{space_name}/{coll_name}/{name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VintageSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
