# coding: utf-8

"""
    ChronosDB swagger

    ChronosDB time series database API  # noqa: E501

    The version of the OpenAPI document: 0.1
    Contact: apiteam@chronosdb.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openapi_client.api_client import ApiClient
from openapi_client.exceptions import (
    ApiTypeError,
    ApiValueError
)


class TimeSeriesDataApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def app_api_timeseries_data_delete(self, space_name, coll_name, names, index, **kwargs):  # noqa: E501
        """Delete observations  # noqa: E501

        Delete observations from a time series  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_data_delete(space_name, coll_name, names, index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param list[str] names: list of series names (required)
        :param list[OneOfintegerstring] index: time index (required)
        :param str format: Format of data time index * `string` a string represenation specific to each index type, e.g. 2000-01 for monthly index. * `iso` a string with iso representation of datetime '' * `s`   a number of seconds from unix epoch 1970-01-01 * `ms`  a number of milliseconds from unix epoch 1970-01-01 * `us`  a number of microseconds from unix epoch 1970-01-01 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_timeseries_data_delete_with_http_info(space_name, coll_name, names, index, **kwargs)  # noqa: E501

    def app_api_timeseries_data_delete_with_http_info(self, space_name, coll_name, names, index, **kwargs):  # noqa: E501
        """Delete observations  # noqa: E501

        Delete observations from a time series  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_data_delete_with_http_info(space_name, coll_name, names, index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param list[str] names: list of series names (required)
        :param list[OneOfintegerstring] index: time index (required)
        :param str format: Format of data time index * `string` a string represenation specific to each index type, e.g. 2000-01 for monthly index. * `iso` a string with iso representation of datetime '' * `s`   a number of seconds from unix epoch 1970-01-01 * `ms`  a number of milliseconds from unix epoch 1970-01-01 * `us`  a number of microseconds from unix epoch 1970-01-01 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'coll_name', 'names', 'index', 'format']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_timeseries_data_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_timeseries_data_delete`")  # noqa: E501
        # verify the required parameter 'coll_name' is set
        if ('coll_name' not in local_var_params or
                local_var_params['coll_name'] is None):
            raise ApiValueError("Missing the required parameter `coll_name` when calling `app_api_timeseries_data_delete`")  # noqa: E501
        # verify the required parameter 'names' is set
        if ('names' not in local_var_params or
                local_var_params['names'] is None):
            raise ApiValueError("Missing the required parameter `names` when calling `app_api_timeseries_data_delete`")  # noqa: E501
        # verify the required parameter 'index' is set
        if ('index' not in local_var_params or
                local_var_params['index'] is None):
            raise ApiValueError("Missing the required parameter `index` when calling `app_api_timeseries_data_delete`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_timeseries_data_delete`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'coll_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['coll_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_name` when calling `app_api_timeseries_data_delete`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501
        if 'coll_name' in local_var_params:
            path_params['coll_name'] = local_var_params['coll_name']  # noqa: E501

        query_params = []
        if 'names' in local_var_params:
            query_params.append(('names', local_var_params['names']))  # noqa: E501
            collection_formats['names'] = 'multi'  # noqa: E501
        if 'index' in local_var_params:
            query_params.append(('index', local_var_params['index']))  # noqa: E501
            collection_formats['index'] = 'multi'  # noqa: E501
        if 'format' in local_var_params:
            query_params.append(('format', local_var_params['format']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/data', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_timeseries_data_get(self, series, **kwargs):  # noqa: E501
        """Retrieve time series data  # noqa: E501

        Retrieve time series data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_data_get(series, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param TSIList series: list of time series identifiers (required)
        :param str period_start: start of time index range, format depends on the freq requested 
        :param str period_end: end of time index range
        :param str transform: Time series transformation * `none` - as is * `diff` - Use the last value of the time period. * `rdiff` - relative diff, i.e. % changes * `log` - natural log * `ldiff` - log diff, i.e. % changes * `norm` - normalized to 100 
        :param str freq: frequency of returned series
        :param str to_lower_method: Method of converting to lower frequency. * `auto` - Determine the method based on the series classification. * `last` - Use the last value of the time period. * `first` - Use the first value of the time period. * `sum` - Aggregate the values of the time period. e.g. for flow type of variables * `pch` - Aggregate the percentage change over the period. * `mix` - Use the highest value in the time period. * `min` - Use the lowest value of the time period. 
        :param str to_higher_method: Method of converting to higher frequency. * `auto` - Determine the method based on the series classification. * `same` - Use the same value for the whole period. * `dist` - Divide equally over the time period. * `pch` - Distribute the percentage change over the period. * `linear` - Use a linear interpolation of the values from this to the next period. * `first` - Use the value for the first value of the period. * `quad` - Use quadratic interpolation to distribute the value over the period. * `cube` - Use a cubic interpolation of the values from this to the next period. 
        :param str missing_method: Method of filling in any missing values. * `none` - Do not fill in missing values. They will remain NaN in the value vector. * `auto` - Determine the method based on the series classification. * `previous` - Use the previous non-missing value. * `zero` - Use the value zero. 
        :param bool merge: Should merge time series
        :param datetime realtime: real time as of which values were valid
        :param str vintage: vintage tag used to identify real time when series was written.
        :param str output: output type
        :param str output_index_type: | format of output type * `auto` depending on output, * `string` string represenation as in * `epoch` integers specifying number of ms from unix epoch * `ISO` ISO8601 format 2008-09-15T15:53:00
        :param str output_index_format: format of output type
        :param float offset: the first number of item to skip
        :param float limit: the number of items to return
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[SingleTimeSeriesData]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_timeseries_data_get_with_http_info(series, **kwargs)  # noqa: E501

    def app_api_timeseries_data_get_with_http_info(self, series, **kwargs):  # noqa: E501
        """Retrieve time series data  # noqa: E501

        Retrieve time series data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_data_get_with_http_info(series, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param TSIList series: list of time series identifiers (required)
        :param str period_start: start of time index range, format depends on the freq requested 
        :param str period_end: end of time index range
        :param str transform: Time series transformation * `none` - as is * `diff` - Use the last value of the time period. * `rdiff` - relative diff, i.e. % changes * `log` - natural log * `ldiff` - log diff, i.e. % changes * `norm` - normalized to 100 
        :param str freq: frequency of returned series
        :param str to_lower_method: Method of converting to lower frequency. * `auto` - Determine the method based on the series classification. * `last` - Use the last value of the time period. * `first` - Use the first value of the time period. * `sum` - Aggregate the values of the time period. e.g. for flow type of variables * `pch` - Aggregate the percentage change over the period. * `mix` - Use the highest value in the time period. * `min` - Use the lowest value of the time period. 
        :param str to_higher_method: Method of converting to higher frequency. * `auto` - Determine the method based on the series classification. * `same` - Use the same value for the whole period. * `dist` - Divide equally over the time period. * `pch` - Distribute the percentage change over the period. * `linear` - Use a linear interpolation of the values from this to the next period. * `first` - Use the value for the first value of the period. * `quad` - Use quadratic interpolation to distribute the value over the period. * `cube` - Use a cubic interpolation of the values from this to the next period. 
        :param str missing_method: Method of filling in any missing values. * `none` - Do not fill in missing values. They will remain NaN in the value vector. * `auto` - Determine the method based on the series classification. * `previous` - Use the previous non-missing value. * `zero` - Use the value zero. 
        :param bool merge: Should merge time series
        :param datetime realtime: real time as of which values were valid
        :param str vintage: vintage tag used to identify real time when series was written.
        :param str output: output type
        :param str output_index_type: | format of output type * `auto` depending on output, * `string` string represenation as in * `epoch` integers specifying number of ms from unix epoch * `ISO` ISO8601 format 2008-09-15T15:53:00
        :param str output_index_format: format of output type
        :param float offset: the first number of item to skip
        :param float limit: the number of items to return
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[SingleTimeSeriesData], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['series', 'period_start', 'period_end', 'transform', 'freq', 'to_lower_method', 'to_higher_method', 'missing_method', 'merge', 'realtime', 'vintage', 'output', 'output_index_type', 'output_index_format', 'offset', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_timeseries_data_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'series' is set
        if ('series' not in local_var_params or
                local_var_params['series'] is None):
            raise ApiValueError("Missing the required parameter `series` when calling `app_api_timeseries_data_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'series' in local_var_params:
            query_params.append(('series', local_var_params['series']))  # noqa: E501
        if 'period_start' in local_var_params:
            query_params.append(('periodStart', local_var_params['period_start']))  # noqa: E501
        if 'period_end' in local_var_params:
            query_params.append(('periodEnd', local_var_params['period_end']))  # noqa: E501
        if 'transform' in local_var_params:
            query_params.append(('transform', local_var_params['transform']))  # noqa: E501
        if 'freq' in local_var_params:
            query_params.append(('freq', local_var_params['freq']))  # noqa: E501
        if 'to_lower_method' in local_var_params:
            query_params.append(('toLowerMethod', local_var_params['to_lower_method']))  # noqa: E501
        if 'to_higher_method' in local_var_params:
            query_params.append(('toHigherMethod', local_var_params['to_higher_method']))  # noqa: E501
        if 'missing_method' in local_var_params:
            query_params.append(('missingMethod', local_var_params['missing_method']))  # noqa: E501
        if 'merge' in local_var_params:
            query_params.append(('merge', local_var_params['merge']))  # noqa: E501
        if 'realtime' in local_var_params:
            query_params.append(('realtime', local_var_params['realtime']))  # noqa: E501
        if 'vintage' in local_var_params:
            query_params.append(('vintage', local_var_params['vintage']))  # noqa: E501
        if 'output' in local_var_params:
            query_params.append(('output', local_var_params['output']))  # noqa: E501
        if 'output_index_type' in local_var_params:
            query_params.append(('outputIndexType', local_var_params['output_index_type']))  # noqa: E501
        if 'output_index_format' in local_var_params:
            query_params.append(('outputIndexFormat', local_var_params['output_index_format']))  # noqa: E501
        if 'offset' in local_var_params:
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[SingleTimeSeriesData]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_timeseries_data_put(self, space_name, coll_name, single_time_series_data, **kwargs):  # noqa: E501
        """Save observations  # noqa: E501

        Save observations of time series  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_data_put(space_name, coll_name, single_time_series_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param list[SingleTimeSeriesData] single_time_series_data: time series data (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_timeseries_data_put_with_http_info(space_name, coll_name, single_time_series_data, **kwargs)  # noqa: E501

    def app_api_timeseries_data_put_with_http_info(self, space_name, coll_name, single_time_series_data, **kwargs):  # noqa: E501
        """Save observations  # noqa: E501

        Save observations of time series  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_data_put_with_http_info(space_name, coll_name, single_time_series_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param list[SingleTimeSeriesData] single_time_series_data: time series data (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'coll_name', 'single_time_series_data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_timeseries_data_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_timeseries_data_put`")  # noqa: E501
        # verify the required parameter 'coll_name' is set
        if ('coll_name' not in local_var_params or
                local_var_params['coll_name'] is None):
            raise ApiValueError("Missing the required parameter `coll_name` when calling `app_api_timeseries_data_put`")  # noqa: E501
        # verify the required parameter 'single_time_series_data' is set
        if ('single_time_series_data' not in local_var_params or
                local_var_params['single_time_series_data'] is None):
            raise ApiValueError("Missing the required parameter `single_time_series_data` when calling `app_api_timeseries_data_put`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_timeseries_data_put`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'coll_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['coll_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_name` when calling `app_api_timeseries_data_put`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501
        if 'coll_name' in local_var_params:
            path_params['coll_name'] = local_var_params['coll_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'single_time_series_data' in local_var_params:
            body_params = local_var_params['single_time_series_data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/data', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
