# coding: utf-8

"""
    ChronosDB swagger

    ChronosDB time series database API  # noqa: E501

    The version of the OpenAPI document: 0.1
    Contact: apiteam@chronosdb.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openapi_client.api_client import ApiClient
from openapi_client.exceptions import (
    ApiTypeError,
    ApiValueError
)


class TimeSeriesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def app_api_timeseries_delete(self, space_name, coll_name, name, **kwargs):  # noqa: E501
        """Delete a time series  # noqa: E501

        delete time series  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_delete(space_name, coll_name, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str name: a single series name (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_timeseries_delete_with_http_info(space_name, coll_name, name, **kwargs)  # noqa: E501

    def app_api_timeseries_delete_with_http_info(self, space_name, coll_name, name, **kwargs):  # noqa: E501
        """Delete a time series  # noqa: E501

        delete time series  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_delete_with_http_info(space_name, coll_name, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str name: a single series name (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'coll_name', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_timeseries_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_timeseries_delete`")  # noqa: E501
        # verify the required parameter 'coll_name' is set
        if ('coll_name' not in local_var_params or
                local_var_params['coll_name'] is None):
            raise ApiValueError("Missing the required parameter `coll_name` when calling `app_api_timeseries_delete`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in local_var_params or
                local_var_params['name'] is None):
            raise ApiValueError("Missing the required parameter `name` when calling `app_api_timeseries_delete`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_timeseries_delete`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'coll_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['coll_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_name` when calling `app_api_timeseries_delete`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{0,59}$', local_var_params['name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `name` when calling `app_api_timeseries_delete`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{0,59}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501
        if 'coll_name' in local_var_params:
            path_params['coll_name'] = local_var_params['coll_name']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/timeseries/{space_name}/{coll_name}/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_timeseries_get(self, space_name, coll_name, name, **kwargs):  # noqa: E501
        """Retrieve time series info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_get(space_name, coll_name, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str name: a single series name (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeSeries
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_timeseries_get_with_http_info(space_name, coll_name, name, **kwargs)  # noqa: E501

    def app_api_timeseries_get_with_http_info(self, space_name, coll_name, name, **kwargs):  # noqa: E501
        """Retrieve time series info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_get_with_http_info(space_name, coll_name, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str name: a single series name (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeSeries, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'coll_name', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_timeseries_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_timeseries_get`")  # noqa: E501
        # verify the required parameter 'coll_name' is set
        if ('coll_name' not in local_var_params or
                local_var_params['coll_name'] is None):
            raise ApiValueError("Missing the required parameter `coll_name` when calling `app_api_timeseries_get`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in local_var_params or
                local_var_params['name'] is None):
            raise ApiValueError("Missing the required parameter `name` when calling `app_api_timeseries_get`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_timeseries_get`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'coll_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['coll_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_name` when calling `app_api_timeseries_get`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{0,59}$', local_var_params['name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `name` when calling `app_api_timeseries_get`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{0,59}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501
        if 'coll_name' in local_var_params:
            path_params['coll_name'] = local_var_params['coll_name']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/timeseries/{space_name}/{coll_name}/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeSeries',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_timeseries_get_list(self, space_name, coll_name, **kwargs):  # noqa: E501
        """List time series in a collection  # noqa: E501

        List time series in a collection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_get_list(space_name, coll_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[TimeSeriesSummary]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_timeseries_get_list_with_http_info(space_name, coll_name, **kwargs)  # noqa: E501

    def app_api_timeseries_get_list_with_http_info(self, space_name, coll_name, **kwargs):  # noqa: E501
        """List time series in a collection  # noqa: E501

        List time series in a collection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_get_list_with_http_info(space_name, coll_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[TimeSeriesSummary], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'coll_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_timeseries_get_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_timeseries_get_list`")  # noqa: E501
        # verify the required parameter 'coll_name' is set
        if ('coll_name' not in local_var_params or
                local_var_params['coll_name'] is None):
            raise ApiValueError("Missing the required parameter `coll_name` when calling `app_api_timeseries_get_list`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_timeseries_get_list`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'coll_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['coll_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_name` when calling `app_api_timeseries_get_list`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501
        if 'coll_name' in local_var_params:
            path_params['coll_name'] = local_var_params['coll_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/timeseries/{space_name}/{coll_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TimeSeriesSummary]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_timeseries_name_history(self, space_name, coll_name, name, **kwargs):  # noqa: E501
        """retrive historical values  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_name_history(space_name, coll_name, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str name: a single series name (required)
        :param datetime real_start: start time from when values were valid
        :param datetime real_end: end time until when values were valid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_timeseries_name_history_with_http_info(space_name, coll_name, name, **kwargs)  # noqa: E501

    def app_api_timeseries_name_history_with_http_info(self, space_name, coll_name, name, **kwargs):  # noqa: E501
        """retrive historical values  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_name_history_with_http_info(space_name, coll_name, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str name: a single series name (required)
        :param datetime real_start: start time from when values were valid
        :param datetime real_end: end time until when values were valid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'coll_name', 'name', 'real_start', 'real_end']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_timeseries_name_history" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_timeseries_name_history`")  # noqa: E501
        # verify the required parameter 'coll_name' is set
        if ('coll_name' not in local_var_params or
                local_var_params['coll_name'] is None):
            raise ApiValueError("Missing the required parameter `coll_name` when calling `app_api_timeseries_name_history`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in local_var_params or
                local_var_params['name'] is None):
            raise ApiValueError("Missing the required parameter `name` when calling `app_api_timeseries_name_history`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_timeseries_name_history`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'coll_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['coll_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_name` when calling `app_api_timeseries_name_history`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{0,59}$', local_var_params['name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `name` when calling `app_api_timeseries_name_history`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{0,59}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501
        if 'coll_name' in local_var_params:
            path_params['coll_name'] = local_var_params['coll_name']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []
        if 'real_start' in local_var_params:
            query_params.append(('realStart', local_var_params['real_start']))  # noqa: E501
        if 'real_end' in local_var_params:
            query_params.append(('realEnd', local_var_params['real_end']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/timeseries/{space_name}/{coll_name}/{name}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_timeseries_post(self, space_name, coll_name, time_series, **kwargs):  # noqa: E501
        """Create a new time series  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_post(space_name, coll_name, time_series, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param TimeSeries time_series: Time series parameters. dtype and freq are required (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeSeries
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_timeseries_post_with_http_info(space_name, coll_name, time_series, **kwargs)  # noqa: E501

    def app_api_timeseries_post_with_http_info(self, space_name, coll_name, time_series, **kwargs):  # noqa: E501
        """Create a new time series  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_post_with_http_info(space_name, coll_name, time_series, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param TimeSeries time_series: Time series parameters. dtype and freq are required (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeSeries, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'coll_name', 'time_series']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_timeseries_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_timeseries_post`")  # noqa: E501
        # verify the required parameter 'coll_name' is set
        if ('coll_name' not in local_var_params or
                local_var_params['coll_name'] is None):
            raise ApiValueError("Missing the required parameter `coll_name` when calling `app_api_timeseries_post`")  # noqa: E501
        # verify the required parameter 'time_series' is set
        if ('time_series' not in local_var_params or
                local_var_params['time_series'] is None):
            raise ApiValueError("Missing the required parameter `time_series` when calling `app_api_timeseries_post`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_timeseries_post`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'coll_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['coll_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_name` when calling `app_api_timeseries_post`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501
        if 'coll_name' in local_var_params:
            path_params['coll_name'] = local_var_params['coll_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'time_series' in local_var_params:
            body_params = local_var_params['time_series']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/timeseries/{space_name}/{coll_name}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeSeries',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_timeseries_put(self, space_name, coll_name, name, time_series_update, **kwargs):  # noqa: E501
        """Update existing time series info  # noqa: E501

        Update existing time series info  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_put(space_name, coll_name, name, time_series_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str name: a single series name (required)
        :param TimeSeriesUpdate time_series_update: Time series updated info (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeSeries
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_timeseries_put_with_http_info(space_name, coll_name, name, time_series_update, **kwargs)  # noqa: E501

    def app_api_timeseries_put_with_http_info(self, space_name, coll_name, name, time_series_update, **kwargs):  # noqa: E501
        """Update existing time series info  # noqa: E501

        Update existing time series info  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_put_with_http_info(space_name, coll_name, name, time_series_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str name: a single series name (required)
        :param TimeSeriesUpdate time_series_update: Time series updated info (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeSeries, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'coll_name', 'name', 'time_series_update']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_timeseries_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_timeseries_put`")  # noqa: E501
        # verify the required parameter 'coll_name' is set
        if ('coll_name' not in local_var_params or
                local_var_params['coll_name'] is None):
            raise ApiValueError("Missing the required parameter `coll_name` when calling `app_api_timeseries_put`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in local_var_params or
                local_var_params['name'] is None):
            raise ApiValueError("Missing the required parameter `name` when calling `app_api_timeseries_put`")  # noqa: E501
        # verify the required parameter 'time_series_update' is set
        if ('time_series_update' not in local_var_params or
                local_var_params['time_series_update'] is None):
            raise ApiValueError("Missing the required parameter `time_series_update` when calling `app_api_timeseries_put`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_timeseries_put`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'coll_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['coll_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_name` when calling `app_api_timeseries_put`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{0,59}$', local_var_params['name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `name` when calling `app_api_timeseries_put`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{0,59}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501
        if 'coll_name' in local_var_params:
            path_params['coll_name'] = local_var_params['coll_name']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'time_series_update' in local_var_params:
            body_params = local_var_params['time_series_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/timeseries/{space_name}/{coll_name}/{name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeSeries',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
