# coding: utf-8

"""
    ChronosDB swagger

    ChronosDB time series database API  # noqa: E501

    The version of the OpenAPI document: 0.1
    Contact: apiteam@chronosdb.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openapi_client.api_client import ApiClient
from openapi_client.exceptions import (
    ApiTypeError,
    ApiValueError
)


class RawVintageApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def app_api_vintages_get_list_raw(self, coll_id, **kwargs):  # noqa: E501
        """List vintage tags in a collection   # noqa: E501

        List vintage tags in a collection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_vintages_get_list_raw(coll_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str tsid: time series id
        :param datetime realtime: realtime when values were valid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[VintageSummary]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_vintages_get_list_raw_with_http_info(coll_id, **kwargs)  # noqa: E501

    def app_api_vintages_get_list_raw_with_http_info(self, coll_id, **kwargs):  # noqa: E501
        """List vintage tags in a collection   # noqa: E501

        List vintage tags in a collection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_vintages_get_list_raw_with_http_info(coll_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str tsid: time series id
        :param datetime realtime: realtime when values were valid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[VintageSummary], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'tsid', 'realtime']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_vintages_get_list_raw" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'coll_id' is set
        if ('coll_id' not in local_var_params or
                local_var_params['coll_id'] is None):
            raise ApiValueError("Missing the required parameter `coll_id` when calling `app_api_vintages_get_list_raw`")  # noqa: E501

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_vintages_get_list_raw`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        if 'tsid' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['tsid']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `tsid` when calling `app_api_vintages_get_list_raw`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'coll_id' in local_var_params:
            path_params['collId'] = local_var_params['coll_id']  # noqa: E501

        query_params = []
        if 'tsid' in local_var_params:
            query_params.append(('tsid', local_var_params['tsid']))  # noqa: E501
        if 'realtime' in local_var_params:
            query_params.append(('realtime', local_var_params['realtime']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/vintage/{collId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[VintageSummary]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_vintages_get_raw(self, coll_id, vid, **kwargs):  # noqa: E501
        """Retrieve a vintage tag with metadata  # noqa: E501

        Retrieve a vintage tag with metadata  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_vintages_get_raw(coll_id, vid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str vid: vintage id (required)
        :param bool meta: should include vintage metadata
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Vintage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_vintages_get_raw_with_http_info(coll_id, vid, **kwargs)  # noqa: E501

    def app_api_vintages_get_raw_with_http_info(self, coll_id, vid, **kwargs):  # noqa: E501
        """Retrieve a vintage tag with metadata  # noqa: E501

        Retrieve a vintage tag with metadata  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_vintages_get_raw_with_http_info(coll_id, vid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str vid: vintage id (required)
        :param bool meta: should include vintage metadata
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Vintage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'vid', 'meta']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_vintages_get_raw" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'coll_id' is set
        if ('coll_id' not in local_var_params or
                local_var_params['coll_id'] is None):
            raise ApiValueError("Missing the required parameter `coll_id` when calling `app_api_vintages_get_raw`")  # noqa: E501
        # verify the required parameter 'vid' is set
        if ('vid' not in local_var_params or
                local_var_params['vid'] is None):
            raise ApiValueError("Missing the required parameter `vid` when calling `app_api_vintages_get_raw`")  # noqa: E501

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_vintages_get_raw`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'coll_id' in local_var_params:
            path_params['collId'] = local_var_params['coll_id']  # noqa: E501
        if 'vid' in local_var_params:
            path_params['vid'] = local_var_params['vid']  # noqa: E501

        query_params = []
        if 'meta' in local_var_params:
            query_params.append(('meta', local_var_params['meta']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/vintage/{collId}/{vid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Vintage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_vintages_object_history_raw(self, coll_id, vid, **kwargs):  # noqa: E501
        """History of vintage by tag id  # noqa: E501

        History of vintage by tag id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_vintages_object_history_raw(coll_id, vid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str vid: vintage id (required)
        :param datetime real_start: start time from when values were valid
        :param datetime real_end: end time until when values were valid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[VintageHistorical]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_vintages_object_history_raw_with_http_info(coll_id, vid, **kwargs)  # noqa: E501

    def app_api_vintages_object_history_raw_with_http_info(self, coll_id, vid, **kwargs):  # noqa: E501
        """History of vintage by tag id  # noqa: E501

        History of vintage by tag id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_vintages_object_history_raw_with_http_info(coll_id, vid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str vid: vintage id (required)
        :param datetime real_start: start time from when values were valid
        :param datetime real_end: end time until when values were valid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[VintageHistorical], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'vid', 'real_start', 'real_end']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_vintages_object_history_raw" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'coll_id' is set
        if ('coll_id' not in local_var_params or
                local_var_params['coll_id'] is None):
            raise ApiValueError("Missing the required parameter `coll_id` when calling `app_api_vintages_object_history_raw`")  # noqa: E501
        # verify the required parameter 'vid' is set
        if ('vid' not in local_var_params or
                local_var_params['vid'] is None):
            raise ApiValueError("Missing the required parameter `vid` when calling `app_api_vintages_object_history_raw`")  # noqa: E501

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_vintages_object_history_raw`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'coll_id' in local_var_params:
            path_params['collId'] = local_var_params['coll_id']  # noqa: E501
        if 'vid' in local_var_params:
            path_params['vid'] = local_var_params['vid']  # noqa: E501

        query_params = []
        if 'real_start' in local_var_params:
            query_params.append(('realStart', local_var_params['real_start']))  # noqa: E501
        if 'real_end' in local_var_params:
            query_params.append(('realEnd', local_var_params['real_end']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/vintage/{collId}/{vid}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[VintageHistorical]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_vintages_put_raw(self, coll_id, vid, vintage_update, **kwargs):  # noqa: E501
        """Update vintage tag  # noqa: E501

        Update a vintage tag for a revision of a time series. Vintage tag is a human-friendly label assigned to datetime when revision was recorded. Vintages are unique within the collection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_vintages_put_raw(coll_id, vid, vintage_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str vid: vintage id (required)
        :param VintageUpdate vintage_update: vintage tag (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: VintageSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_vintages_put_raw_with_http_info(coll_id, vid, vintage_update, **kwargs)  # noqa: E501

    def app_api_vintages_put_raw_with_http_info(self, coll_id, vid, vintage_update, **kwargs):  # noqa: E501
        """Update vintage tag  # noqa: E501

        Update a vintage tag for a revision of a time series. Vintage tag is a human-friendly label assigned to datetime when revision was recorded. Vintages are unique within the collection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_vintages_put_raw_with_http_info(coll_id, vid, vintage_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str vid: vintage id (required)
        :param VintageUpdate vintage_update: vintage tag (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(VintageSummary, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'vid', 'vintage_update']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_vintages_put_raw" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'coll_id' is set
        if ('coll_id' not in local_var_params or
                local_var_params['coll_id'] is None):
            raise ApiValueError("Missing the required parameter `coll_id` when calling `app_api_vintages_put_raw`")  # noqa: E501
        # verify the required parameter 'vid' is set
        if ('vid' not in local_var_params or
                local_var_params['vid'] is None):
            raise ApiValueError("Missing the required parameter `vid` when calling `app_api_vintages_put_raw`")  # noqa: E501
        # verify the required parameter 'vintage_update' is set
        if ('vintage_update' not in local_var_params or
                local_var_params['vintage_update'] is None):
            raise ApiValueError("Missing the required parameter `vintage_update` when calling `app_api_vintages_put_raw`")  # noqa: E501

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_vintages_put_raw`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'coll_id' in local_var_params:
            path_params['collId'] = local_var_params['coll_id']  # noqa: E501
        if 'vid' in local_var_params:
            path_params['vid'] = local_var_params['vid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vintage_update' in local_var_params:
            body_params = local_var_params['vintage_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/vintage/{collId}/{vid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VintageSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
