# coding: utf-8

"""
    ChronosDB swagger

    ChronosDB time series database API  # noqa: E501

    The version of the OpenAPI document: 0.1
    Contact: apiteam@chronosdb.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openapi_client.api_client import ApiClient
from openapi_client.exceptions import (
    ApiTypeError,
    ApiValueError
)


class RawUploadApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def app_api_upload_commit(self, upload_id, **kwargs):  # noqa: E501
        """commit staging  # noqa: E501

        commit staging  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_upload_commit(upload_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str upload_id: upload_id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_upload_commit_with_http_info(upload_id, **kwargs)  # noqa: E501

    def app_api_upload_commit_with_http_info(self, upload_id, **kwargs):  # noqa: E501
        """commit staging  # noqa: E501

        commit staging  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_upload_commit_with_http_info(upload_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str upload_id: upload_id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['upload_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_upload_commit" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'upload_id' is set
        if ('upload_id' not in local_var_params or
                local_var_params['upload_id'] is None):
            raise ApiValueError("Missing the required parameter `upload_id` when calling `app_api_upload_commit`")  # noqa: E501

        if 'upload_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['upload_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `upload_id` when calling `app_api_upload_commit`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'upload_id' in local_var_params:
            path_params['upload_id'] = local_var_params['upload_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/upload/{upload_id}/commit', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_upload_confirm_upload(self, upload_id, **kwargs):  # noqa: E501
        """regenerate upload url  # noqa: E501

        retrieve history of group object by its id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_upload_confirm_upload(upload_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str upload_id: upload_id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_upload_confirm_upload_with_http_info(upload_id, **kwargs)  # noqa: E501

    def app_api_upload_confirm_upload_with_http_info(self, upload_id, **kwargs):  # noqa: E501
        """regenerate upload url  # noqa: E501

        retrieve history of group object by its id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_upload_confirm_upload_with_http_info(upload_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str upload_id: upload_id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['upload_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_upload_confirm_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'upload_id' is set
        if ('upload_id' not in local_var_params or
                local_var_params['upload_id'] is None):
            raise ApiValueError("Missing the required parameter `upload_id` when calling `app_api_upload_confirm_upload`")  # noqa: E501

        if 'upload_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['upload_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `upload_id` when calling `app_api_upload_confirm_upload`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'upload_id' in local_var_params:
            path_params['upload_id'] = local_var_params['upload_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/upload/{upload_id}/confirm', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_upload_create(self, **kwargs):  # noqa: E501
        """create a new upload  # noqa: E501

        create a new upload  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_upload_create(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id
        :param UploadMethod method:
        :param str filename:
        :param str file_type:
        :param datetime file_size:
        :param float last_modified: last modified unix epoch
        :param str description:
        :param str vintage_name:
        :param bool create_missing:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_upload_create_with_http_info(**kwargs)  # noqa: E501

    def app_api_upload_create_with_http_info(self, **kwargs):  # noqa: E501
        """create a new upload  # noqa: E501

        create a new upload  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_upload_create_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id
        :param UploadMethod method:
        :param str filename:
        :param str file_type:
        :param datetime file_size:
        :param float last_modified: last modified unix epoch
        :param str description:
        :param str vintage_name:
        :param bool create_missing:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'method', 'filename', 'file_type', 'file_size', 'last_modified', 'description', 'vintage_name', 'create_missing']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_upload_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_upload_create`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'coll_id' in local_var_params:
            query_params.append(('coll_id', local_var_params['coll_id']))  # noqa: E501
        if 'method' in local_var_params:
            query_params.append(('method', local_var_params['method']))  # noqa: E501
        if 'filename' in local_var_params:
            query_params.append(('filename', local_var_params['filename']))  # noqa: E501
        if 'file_type' in local_var_params:
            query_params.append(('fileType', local_var_params['file_type']))  # noqa: E501
        if 'file_size' in local_var_params:
            query_params.append(('fileSize', local_var_params['file_size']))  # noqa: E501
        if 'last_modified' in local_var_params:
            query_params.append(('lastModified', local_var_params['last_modified']))  # noqa: E501
        if 'description' in local_var_params:
            query_params.append(('description', local_var_params['description']))  # noqa: E501
        if 'vintage_name' in local_var_params:
            query_params.append(('vintage_name', local_var_params['vintage_name']))  # noqa: E501
        if 'create_missing' in local_var_params:
            query_params.append(('create_missing', local_var_params['create_missing']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/upload', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_upload_get(self, upload_id, **kwargs):  # noqa: E501
        """retrieve upload object  # noqa: E501

        retrieve upload object by its id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_upload_get(upload_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str upload_id: upload_id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_upload_get_with_http_info(upload_id, **kwargs)  # noqa: E501

    def app_api_upload_get_with_http_info(self, upload_id, **kwargs):  # noqa: E501
        """retrieve upload object  # noqa: E501

        retrieve upload object by its id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_upload_get_with_http_info(upload_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str upload_id: upload_id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['upload_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_upload_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'upload_id' is set
        if ('upload_id' not in local_var_params or
                local_var_params['upload_id'] is None):
            raise ApiValueError("Missing the required parameter `upload_id` when calling `app_api_upload_get`")  # noqa: E501

        if 'upload_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['upload_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `upload_id` when calling `app_api_upload_get`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'upload_id' in local_var_params:
            path_params['upload_id'] = local_var_params['upload_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/upload/{upload_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_upload_get_list(self, **kwargs):  # noqa: E501
        """list upload objects  # noqa: E501

        list upload objects  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_upload_get_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id
        :param float offset: the first number of item to skip
        :param float limit: the number of items to return
        :param datetime since: since
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_upload_get_list_with_http_info(**kwargs)  # noqa: E501

    def app_api_upload_get_list_with_http_info(self, **kwargs):  # noqa: E501
        """list upload objects  # noqa: E501

        list upload objects  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_upload_get_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id
        :param float offset: the first number of item to skip
        :param float limit: the number of items to return
        :param datetime since: since
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse200, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'offset', 'limit', 'since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_upload_get_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_upload_get_list`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'coll_id' in local_var_params:
            query_params.append(('coll_id', local_var_params['coll_id']))  # noqa: E501
        if 'offset' in local_var_params:
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'since' in local_var_params:
            query_params.append(('since', local_var_params['since']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/upload', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_upload_get_processed(self, upload_id, **kwargs):  # noqa: E501
        """retrieve processed data  # noqa: E501

        retrieve processed data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_upload_get_processed(upload_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str upload_id: upload_id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_upload_get_processed_with_http_info(upload_id, **kwargs)  # noqa: E501

    def app_api_upload_get_processed_with_http_info(self, upload_id, **kwargs):  # noqa: E501
        """retrieve processed data  # noqa: E501

        retrieve processed data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_upload_get_processed_with_http_info(upload_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str upload_id: upload_id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(dict(str, object), status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['upload_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_upload_get_processed" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'upload_id' is set
        if ('upload_id' not in local_var_params or
                local_var_params['upload_id'] is None):
            raise ApiValueError("Missing the required parameter `upload_id` when calling `app_api_upload_get_processed`")  # noqa: E501

        if 'upload_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['upload_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `upload_id` when calling `app_api_upload_get_processed`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'upload_id' in local_var_params:
            path_params['upload_id'] = local_var_params['upload_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/upload/{upload_id}/processing', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_upload_get_staging(self, upload_id, **kwargs):  # noqa: E501
        """retrieve staging data  # noqa: E501

        retrieve staging data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_upload_get_staging(upload_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str upload_id: upload_id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_upload_get_staging_with_http_info(upload_id, **kwargs)  # noqa: E501

    def app_api_upload_get_staging_with_http_info(self, upload_id, **kwargs):  # noqa: E501
        """retrieve staging data  # noqa: E501

        retrieve staging data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_upload_get_staging_with_http_info(upload_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str upload_id: upload_id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(dict(str, object), status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['upload_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_upload_get_staging" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'upload_id' is set
        if ('upload_id' not in local_var_params or
                local_var_params['upload_id'] is None):
            raise ApiValueError("Missing the required parameter `upload_id` when calling `app_api_upload_get_staging`")  # noqa: E501

        if 'upload_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['upload_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `upload_id` when calling `app_api_upload_get_staging`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'upload_id' in local_var_params:
            path_params['upload_id'] = local_var_params['upload_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/upload/{upload_id}/staging', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_upload_post(self, upload_id, **kwargs):  # noqa: E501
        """upload object  # noqa: E501

        upload object by its id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_upload_post(upload_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str upload_id: upload_id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_upload_post_with_http_info(upload_id, **kwargs)  # noqa: E501

    def app_api_upload_post_with_http_info(self, upload_id, **kwargs):  # noqa: E501
        """upload object  # noqa: E501

        upload object by its id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_upload_post_with_http_info(upload_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str upload_id: upload_id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['upload_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_upload_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'upload_id' is set
        if ('upload_id' not in local_var_params or
                local_var_params['upload_id'] is None):
            raise ApiValueError("Missing the required parameter `upload_id` when calling `app_api_upload_post`")  # noqa: E501

        if 'upload_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['upload_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `upload_id` when calling `app_api_upload_post`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'upload_id' in local_var_params:
            path_params['upload_id'] = local_var_params['upload_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/upload/{upload_id}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_upload_post_processed(self, upload_id, request_body, **kwargs):  # noqa: E501
        """save processing results  # noqa: E501

        save processing results  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_upload_post_processed(upload_id, request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str upload_id: upload_id (required)
        :param dict(str, object) request_body: Time series updated info (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_upload_post_processed_with_http_info(upload_id, request_body, **kwargs)  # noqa: E501

    def app_api_upload_post_processed_with_http_info(self, upload_id, request_body, **kwargs):  # noqa: E501
        """save processing results  # noqa: E501

        save processing results  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_upload_post_processed_with_http_info(upload_id, request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str upload_id: upload_id (required)
        :param dict(str, object) request_body: Time series updated info (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['upload_id', 'request_body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_upload_post_processed" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'upload_id' is set
        if ('upload_id' not in local_var_params or
                local_var_params['upload_id'] is None):
            raise ApiValueError("Missing the required parameter `upload_id` when calling `app_api_upload_post_processed`")  # noqa: E501
        # verify the required parameter 'request_body' is set
        if ('request_body' not in local_var_params or
                local_var_params['request_body'] is None):
            raise ApiValueError("Missing the required parameter `request_body` when calling `app_api_upload_post_processed`")  # noqa: E501

        if 'upload_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['upload_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `upload_id` when calling `app_api_upload_post_processed`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'upload_id' in local_var_params:
            path_params['upload_id'] = local_var_params['upload_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request_body' in local_var_params:
            body_params = local_var_params['request_body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/upload/{upload_id}/processing', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_upload_put_staging(self, upload_id, request_body, **kwargs):  # noqa: E501
        """save staging results  # noqa: E501

        save staging results  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_upload_put_staging(upload_id, request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str upload_id: upload_id (required)
        :param dict(str, object) request_body: Time series updated info (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_upload_put_staging_with_http_info(upload_id, request_body, **kwargs)  # noqa: E501

    def app_api_upload_put_staging_with_http_info(self, upload_id, request_body, **kwargs):  # noqa: E501
        """save staging results  # noqa: E501

        save staging results  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_upload_put_staging_with_http_info(upload_id, request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str upload_id: upload_id (required)
        :param dict(str, object) request_body: Time series updated info (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['upload_id', 'request_body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_upload_put_staging" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'upload_id' is set
        if ('upload_id' not in local_var_params or
                local_var_params['upload_id'] is None):
            raise ApiValueError("Missing the required parameter `upload_id` when calling `app_api_upload_put_staging`")  # noqa: E501
        # verify the required parameter 'request_body' is set
        if ('request_body' not in local_var_params or
                local_var_params['request_body'] is None):
            raise ApiValueError("Missing the required parameter `request_body` when calling `app_api_upload_put_staging`")  # noqa: E501

        if 'upload_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['upload_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `upload_id` when calling `app_api_upload_put_staging`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'upload_id' in local_var_params:
            path_params['upload_id'] = local_var_params['upload_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request_body' in local_var_params:
            body_params = local_var_params['request_body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/upload/{upload_id}/staging', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_upload_regenerate_url(self, upload_id, **kwargs):  # noqa: E501
        """regenerate upload url  # noqa: E501

        retrieve history of group object by its id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_upload_regenerate_url(upload_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str upload_id: upload_id (required)
        :param str filename:
        :param str file_type:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_upload_regenerate_url_with_http_info(upload_id, **kwargs)  # noqa: E501

    def app_api_upload_regenerate_url_with_http_info(self, upload_id, **kwargs):  # noqa: E501
        """regenerate upload url  # noqa: E501

        retrieve history of group object by its id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_upload_regenerate_url_with_http_info(upload_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str upload_id: upload_id (required)
        :param str filename:
        :param str file_type:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['upload_id', 'filename', 'file_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_upload_regenerate_url" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'upload_id' is set
        if ('upload_id' not in local_var_params or
                local_var_params['upload_id'] is None):
            raise ApiValueError("Missing the required parameter `upload_id` when calling `app_api_upload_regenerate_url`")  # noqa: E501

        if 'upload_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['upload_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `upload_id` when calling `app_api_upload_regenerate_url`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'upload_id' in local_var_params:
            path_params['upload_id'] = local_var_params['upload_id']  # noqa: E501

        query_params = []
        if 'filename' in local_var_params:
            query_params.append(('filename', local_var_params['filename']))  # noqa: E501
        if 'file_type' in local_var_params:
            query_params.append(('fileType', local_var_params['file_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/upload/{upload_id}/url', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
