# coding: utf-8

"""
    ChronosDB swagger

    ChronosDB time series database API  # noqa: E501

    The version of the OpenAPI document: 0.1
    Contact: apiteam@chronosdb.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openapi_client.api_client import ApiClient
from openapi_client.exceptions import (
    ApiTypeError,
    ApiValueError
)


class RawTimeSeriesDataApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def app_api_raw_timeseries_data_delete(self, coll_id, index, index_format, **kwargs):  # noqa: E501
        """Delete observations, for internal use only  # noqa: E501

        Delete observations from a time series, for internal use only  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_raw_timeseries_data_delete(coll_id, index, index_format, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param list[int] index: time series index (required)
        :param IndexFormat index_format: (required)
        :param str tsid: time series id
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RawDataDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_raw_timeseries_data_delete_with_http_info(coll_id, index, index_format, **kwargs)  # noqa: E501

    def app_api_raw_timeseries_data_delete_with_http_info(self, coll_id, index, index_format, **kwargs):  # noqa: E501
        """Delete observations, for internal use only  # noqa: E501

        Delete observations from a time series, for internal use only  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_raw_timeseries_data_delete_with_http_info(coll_id, index, index_format, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param list[int] index: time series index (required)
        :param IndexFormat index_format: (required)
        :param str tsid: time series id
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RawDataDeleteResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'index', 'index_format', 'tsid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_raw_timeseries_data_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'coll_id' is set
        if ('coll_id' not in local_var_params or
                local_var_params['coll_id'] is None):
            raise ApiValueError("Missing the required parameter `coll_id` when calling `app_api_raw_timeseries_data_delete`")  # noqa: E501
        # verify the required parameter 'index' is set
        if ('index' not in local_var_params or
                local_var_params['index'] is None):
            raise ApiValueError("Missing the required parameter `index` when calling `app_api_raw_timeseries_data_delete`")  # noqa: E501
        # verify the required parameter 'index_format' is set
        if ('index_format' not in local_var_params or
                local_var_params['index_format'] is None):
            raise ApiValueError("Missing the required parameter `index_format` when calling `app_api_raw_timeseries_data_delete`")  # noqa: E501

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_raw_timeseries_data_delete`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        if 'tsid' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['tsid']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `tsid` when calling `app_api_raw_timeseries_data_delete`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'coll_id' in local_var_params:
            path_params['collId'] = local_var_params['coll_id']  # noqa: E501

        query_params = []
        if 'tsid' in local_var_params:
            query_params.append(('tsid', local_var_params['tsid']))  # noqa: E501
        if 'index' in local_var_params:
            query_params.append(('index', local_var_params['index']))  # noqa: E501
            collection_formats['index'] = 'multi'  # noqa: E501
        if 'index_format' in local_var_params:
            query_params.append(('indexFormat', local_var_params['index_format']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/data/{collId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RawDataDeleteResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_raw_timeseries_data_get(self, coll_id, tsids, **kwargs):  # noqa: E501
        """Retrieve raw time series data, for internal use only  # noqa: E501

        Retrieve raw time series data, for internal use only  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_raw_timeseries_data_get(coll_id, tsids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param list[str] tsids: array of tsid's in the collection, collId (required)
        :param datetime realtime: real time to retrieve the historical data
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: dict(str, RawSingleTimeSeriesData)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_raw_timeseries_data_get_with_http_info(coll_id, tsids, **kwargs)  # noqa: E501

    def app_api_raw_timeseries_data_get_with_http_info(self, coll_id, tsids, **kwargs):  # noqa: E501
        """Retrieve raw time series data, for internal use only  # noqa: E501

        Retrieve raw time series data, for internal use only  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_raw_timeseries_data_get_with_http_info(coll_id, tsids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param list[str] tsids: array of tsid's in the collection, collId (required)
        :param datetime realtime: real time to retrieve the historical data
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(dict(str, RawSingleTimeSeriesData), status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'tsids', 'realtime']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_raw_timeseries_data_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'coll_id' is set
        if ('coll_id' not in local_var_params or
                local_var_params['coll_id'] is None):
            raise ApiValueError("Missing the required parameter `coll_id` when calling `app_api_raw_timeseries_data_get`")  # noqa: E501
        # verify the required parameter 'tsids' is set
        if ('tsids' not in local_var_params or
                local_var_params['tsids'] is None):
            raise ApiValueError("Missing the required parameter `tsids` when calling `app_api_raw_timeseries_data_get`")  # noqa: E501

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_raw_timeseries_data_get`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'coll_id' in local_var_params:
            path_params['collId'] = local_var_params['coll_id']  # noqa: E501

        query_params = []
        if 'tsids' in local_var_params:
            query_params.append(('tsids', local_var_params['tsids']))  # noqa: E501
            collection_formats['tsids'] = 'multi'  # noqa: E501
        if 'realtime' in local_var_params:
            query_params.append(('realtime', local_var_params['realtime']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/data/{collId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, RawSingleTimeSeriesData)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_raw_timeseries_data_put(self, coll_id, method, raw_data_put_request, **kwargs):  # noqa: E501
        """Save raw observations, for internal use only  # noqa: E501

        Save raw observations of time series, for internal use only  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_raw_timeseries_data_put(coll_id, method, raw_data_put_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str method: data type is one of the following * `overwrite` overwrite entire series * `update`    update exisitng values and add new values * `append`    add only new values ignoring any existing values  (required)
        :param RawDataPutRequest raw_data_put_request: time series data (required)
        :param datetime realtime: real time at which data was written. This only works if there is no observations written after this real time
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RawDataPutResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_raw_timeseries_data_put_with_http_info(coll_id, method, raw_data_put_request, **kwargs)  # noqa: E501

    def app_api_raw_timeseries_data_put_with_http_info(self, coll_id, method, raw_data_put_request, **kwargs):  # noqa: E501
        """Save raw observations, for internal use only  # noqa: E501

        Save raw observations of time series, for internal use only  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_raw_timeseries_data_put_with_http_info(coll_id, method, raw_data_put_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str method: data type is one of the following * `overwrite` overwrite entire series * `update`    update exisitng values and add new values * `append`    add only new values ignoring any existing values  (required)
        :param RawDataPutRequest raw_data_put_request: time series data (required)
        :param datetime realtime: real time at which data was written. This only works if there is no observations written after this real time
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RawDataPutResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'method', 'raw_data_put_request', 'realtime']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_raw_timeseries_data_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'coll_id' is set
        if ('coll_id' not in local_var_params or
                local_var_params['coll_id'] is None):
            raise ApiValueError("Missing the required parameter `coll_id` when calling `app_api_raw_timeseries_data_put`")  # noqa: E501
        # verify the required parameter 'method' is set
        if ('method' not in local_var_params or
                local_var_params['method'] is None):
            raise ApiValueError("Missing the required parameter `method` when calling `app_api_raw_timeseries_data_put`")  # noqa: E501
        # verify the required parameter 'raw_data_put_request' is set
        if ('raw_data_put_request' not in local_var_params or
                local_var_params['raw_data_put_request'] is None):
            raise ApiValueError("Missing the required parameter `raw_data_put_request` when calling `app_api_raw_timeseries_data_put`")  # noqa: E501

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_raw_timeseries_data_put`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'coll_id' in local_var_params:
            path_params['collId'] = local_var_params['coll_id']  # noqa: E501

        query_params = []
        if 'method' in local_var_params:
            query_params.append(('method', local_var_params['method']))  # noqa: E501
        if 'realtime' in local_var_params:
            query_params.append(('realtime', local_var_params['realtime']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'raw_data_put_request' in local_var_params:
            body_params = local_var_params['raw_data_put_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/data/{collId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RawDataPutResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
