# coding: utf-8

"""
    ChronosDB swagger

    ChronosDB time series database API  # noqa: E501

    The version of the OpenAPI document: 0.1
    Contact: apiteam@chronosdb.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openapi_client.api_client import ApiClient
from openapi_client.exceptions import (
    ApiTypeError,
    ApiValueError
)


class RawTimeSeriesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def app_api_timeseries_raw_delete(self, coll_id, tsid, **kwargs):  # noqa: E501
        """Delete a time series  # noqa: E501

        delete time series  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_raw_delete(coll_id, tsid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str tsid: time series id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_timeseries_raw_delete_with_http_info(coll_id, tsid, **kwargs)  # noqa: E501

    def app_api_timeseries_raw_delete_with_http_info(self, coll_id, tsid, **kwargs):  # noqa: E501
        """Delete a time series  # noqa: E501

        delete time series  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_raw_delete_with_http_info(coll_id, tsid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str tsid: time series id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'tsid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_timeseries_raw_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'coll_id' is set
        if ('coll_id' not in local_var_params or
                local_var_params['coll_id'] is None):
            raise ApiValueError("Missing the required parameter `coll_id` when calling `app_api_timeseries_raw_delete`")  # noqa: E501
        # verify the required parameter 'tsid' is set
        if ('tsid' not in local_var_params or
                local_var_params['tsid'] is None):
            raise ApiValueError("Missing the required parameter `tsid` when calling `app_api_timeseries_raw_delete`")  # noqa: E501

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_timeseries_raw_delete`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'coll_id' in local_var_params:
            path_params['collId'] = local_var_params['coll_id']  # noqa: E501
        if 'tsid' in local_var_params:
            path_params['tsid'] = local_var_params['tsid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/timeseries/{collId}/{tsid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_timeseries_raw_get(self, coll_id, tsid, **kwargs):  # noqa: E501
        """Retrieve time series info  # noqa: E501

        Retrieve time series info  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_raw_get(coll_id, tsid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str tsid: time series id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeSeries
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_timeseries_raw_get_with_http_info(coll_id, tsid, **kwargs)  # noqa: E501

    def app_api_timeseries_raw_get_with_http_info(self, coll_id, tsid, **kwargs):  # noqa: E501
        """Retrieve time series info  # noqa: E501

        Retrieve time series info  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_raw_get_with_http_info(coll_id, tsid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str tsid: time series id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeSeries, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'tsid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_timeseries_raw_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'coll_id' is set
        if ('coll_id' not in local_var_params or
                local_var_params['coll_id'] is None):
            raise ApiValueError("Missing the required parameter `coll_id` when calling `app_api_timeseries_raw_get`")  # noqa: E501
        # verify the required parameter 'tsid' is set
        if ('tsid' not in local_var_params or
                local_var_params['tsid'] is None):
            raise ApiValueError("Missing the required parameter `tsid` when calling `app_api_timeseries_raw_get`")  # noqa: E501

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_timeseries_raw_get`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'coll_id' in local_var_params:
            path_params['collId'] = local_var_params['coll_id']  # noqa: E501
        if 'tsid' in local_var_params:
            path_params['tsid'] = local_var_params['tsid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/timeseries/{collId}/{tsid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeSeries',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_timeseries_raw_get_list(self, coll_id, **kwargs):  # noqa: E501
        """List time series in a collection  # noqa: E501

        List time series in a collection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_raw_get_list(coll_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param list[str] tsids: array of time series id
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[TimeSeriesSummary]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_timeseries_raw_get_list_with_http_info(coll_id, **kwargs)  # noqa: E501

    def app_api_timeseries_raw_get_list_with_http_info(self, coll_id, **kwargs):  # noqa: E501
        """List time series in a collection  # noqa: E501

        List time series in a collection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_raw_get_list_with_http_info(coll_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param list[str] tsids: array of time series id
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[TimeSeriesSummary], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'tsids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_timeseries_raw_get_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'coll_id' is set
        if ('coll_id' not in local_var_params or
                local_var_params['coll_id'] is None):
            raise ApiValueError("Missing the required parameter `coll_id` when calling `app_api_timeseries_raw_get_list`")  # noqa: E501

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_timeseries_raw_get_list`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'coll_id' in local_var_params:
            path_params['collId'] = local_var_params['coll_id']  # noqa: E501

        query_params = []
        if 'tsids' in local_var_params:
            query_params.append(('tsids', local_var_params['tsids']))  # noqa: E501
            collection_formats['tsids'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/timeseries/{collId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TimeSeriesSummary]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_timeseries_raw_object_history(self, coll_id, tsid, **kwargs):  # noqa: E501
        """retrieve historical values  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_raw_object_history(coll_id, tsid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str tsid: time series id (required)
        :param datetime real_start: start time from when values were valid
        :param datetime real_end: end time until when values were valid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_timeseries_raw_object_history_with_http_info(coll_id, tsid, **kwargs)  # noqa: E501

    def app_api_timeseries_raw_object_history_with_http_info(self, coll_id, tsid, **kwargs):  # noqa: E501
        """retrieve historical values  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_raw_object_history_with_http_info(coll_id, tsid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str tsid: time series id (required)
        :param datetime real_start: start time from when values were valid
        :param datetime real_end: end time until when values were valid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'tsid', 'real_start', 'real_end']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_timeseries_raw_object_history" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'coll_id' is set
        if ('coll_id' not in local_var_params or
                local_var_params['coll_id'] is None):
            raise ApiValueError("Missing the required parameter `coll_id` when calling `app_api_timeseries_raw_object_history`")  # noqa: E501
        # verify the required parameter 'tsid' is set
        if ('tsid' not in local_var_params or
                local_var_params['tsid'] is None):
            raise ApiValueError("Missing the required parameter `tsid` when calling `app_api_timeseries_raw_object_history`")  # noqa: E501

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_timeseries_raw_object_history`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'coll_id' in local_var_params:
            path_params['collId'] = local_var_params['coll_id']  # noqa: E501
        if 'tsid' in local_var_params:
            path_params['tsid'] = local_var_params['tsid']  # noqa: E501

        query_params = []
        if 'real_start' in local_var_params:
            query_params.append(('realStart', local_var_params['real_start']))  # noqa: E501
        if 'real_end' in local_var_params:
            query_params.append(('realEnd', local_var_params['real_end']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/timeseries/{collId}/{tsid}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_timeseries_raw_permanent_delete(self, coll_id, tsid, **kwargs):  # noqa: E501
        """retrieve historical values  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_raw_permanent_delete(coll_id, tsid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str tsid: time series id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_timeseries_raw_permanent_delete_with_http_info(coll_id, tsid, **kwargs)  # noqa: E501

    def app_api_timeseries_raw_permanent_delete_with_http_info(self, coll_id, tsid, **kwargs):  # noqa: E501
        """retrieve historical values  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_raw_permanent_delete_with_http_info(coll_id, tsid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str tsid: time series id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'tsid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_timeseries_raw_permanent_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'coll_id' is set
        if ('coll_id' not in local_var_params or
                local_var_params['coll_id'] is None):
            raise ApiValueError("Missing the required parameter `coll_id` when calling `app_api_timeseries_raw_permanent_delete`")  # noqa: E501
        # verify the required parameter 'tsid' is set
        if ('tsid' not in local_var_params or
                local_var_params['tsid'] is None):
            raise ApiValueError("Missing the required parameter `tsid` when calling `app_api_timeseries_raw_permanent_delete`")  # noqa: E501

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_timeseries_raw_permanent_delete`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'coll_id' in local_var_params:
            path_params['collId'] = local_var_params['coll_id']  # noqa: E501
        if 'tsid' in local_var_params:
            path_params['tsid'] = local_var_params['tsid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/timeseries/{collId}/{tsid}/permanent', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_timeseries_raw_post(self, coll_id, time_series, **kwargs):  # noqa: E501
        """Create a new time series  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_raw_post(coll_id, time_series, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param TimeSeries time_series: Time series parameters. dtype and freq are required (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeSeries
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_timeseries_raw_post_with_http_info(coll_id, time_series, **kwargs)  # noqa: E501

    def app_api_timeseries_raw_post_with_http_info(self, coll_id, time_series, **kwargs):  # noqa: E501
        """Create a new time series  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_raw_post_with_http_info(coll_id, time_series, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param TimeSeries time_series: Time series parameters. dtype and freq are required (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeSeries, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'time_series']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_timeseries_raw_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'coll_id' is set
        if ('coll_id' not in local_var_params or
                local_var_params['coll_id'] is None):
            raise ApiValueError("Missing the required parameter `coll_id` when calling `app_api_timeseries_raw_post`")  # noqa: E501
        # verify the required parameter 'time_series' is set
        if ('time_series' not in local_var_params or
                local_var_params['time_series'] is None):
            raise ApiValueError("Missing the required parameter `time_series` when calling `app_api_timeseries_raw_post`")  # noqa: E501

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_timeseries_raw_post`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'coll_id' in local_var_params:
            path_params['collId'] = local_var_params['coll_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'time_series' in local_var_params:
            body_params = local_var_params['time_series']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/timeseries/{collId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeSeries',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_timeseries_raw_put(self, coll_id, tsid, time_series_update, **kwargs):  # noqa: E501
        """Update existing time series info  # noqa: E501

        Update existing time series info  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_raw_put(coll_id, tsid, time_series_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str tsid: time series id (required)
        :param TimeSeriesUpdate time_series_update: Time series updated info (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeSeries
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_timeseries_raw_put_with_http_info(coll_id, tsid, time_series_update, **kwargs)  # noqa: E501

    def app_api_timeseries_raw_put_with_http_info(self, coll_id, tsid, time_series_update, **kwargs):  # noqa: E501
        """Update existing time series info  # noqa: E501

        Update existing time series info  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_raw_put_with_http_info(coll_id, tsid, time_series_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str tsid: time series id (required)
        :param TimeSeriesUpdate time_series_update: Time series updated info (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeSeries, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'tsid', 'time_series_update']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_timeseries_raw_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'coll_id' is set
        if ('coll_id' not in local_var_params or
                local_var_params['coll_id'] is None):
            raise ApiValueError("Missing the required parameter `coll_id` when calling `app_api_timeseries_raw_put`")  # noqa: E501
        # verify the required parameter 'tsid' is set
        if ('tsid' not in local_var_params or
                local_var_params['tsid'] is None):
            raise ApiValueError("Missing the required parameter `tsid` when calling `app_api_timeseries_raw_put`")  # noqa: E501
        # verify the required parameter 'time_series_update' is set
        if ('time_series_update' not in local_var_params or
                local_var_params['time_series_update'] is None):
            raise ApiValueError("Missing the required parameter `time_series_update` when calling `app_api_timeseries_raw_put`")  # noqa: E501

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_timeseries_raw_put`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'coll_id' in local_var_params:
            path_params['collId'] = local_var_params['coll_id']  # noqa: E501
        if 'tsid' in local_var_params:
            path_params['tsid'] = local_var_params['tsid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'time_series_update' in local_var_params:
            body_params = local_var_params['time_series_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/timeseries/{collId}/{tsid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeSeries',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_timeseries_raw_undelete(self, coll_id, tsid, **kwargs):  # noqa: E501
        """retrieve historical values  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_raw_undelete(coll_id, tsid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str tsid: time series id (required)
        :param str name: new name for the time series
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_timeseries_raw_undelete_with_http_info(coll_id, tsid, **kwargs)  # noqa: E501

    def app_api_timeseries_raw_undelete_with_http_info(self, coll_id, tsid, **kwargs):  # noqa: E501
        """retrieve historical values  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_timeseries_raw_undelete_with_http_info(coll_id, tsid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str tsid: time series id (required)
        :param str name: new name for the time series
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'tsid', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_timeseries_raw_undelete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'coll_id' is set
        if ('coll_id' not in local_var_params or
                local_var_params['coll_id'] is None):
            raise ApiValueError("Missing the required parameter `coll_id` when calling `app_api_timeseries_raw_undelete`")  # noqa: E501
        # verify the required parameter 'tsid' is set
        if ('tsid' not in local_var_params or
                local_var_params['tsid'] is None):
            raise ApiValueError("Missing the required parameter `tsid` when calling `app_api_timeseries_raw_undelete`")  # noqa: E501

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_timeseries_raw_undelete`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        if 'name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{0,59}$', local_var_params['name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `name` when calling `app_api_timeseries_raw_undelete`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{0,59}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'coll_id' in local_var_params:
            path_params['collId'] = local_var_params['coll_id']  # noqa: E501
        if 'tsid' in local_var_params:
            path_params['tsid'] = local_var_params['tsid']  # noqa: E501

        query_params = []
        if 'name' in local_var_params:
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/timeseries/{collId}/{tsid}/undelete', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
