# coding: utf-8

"""
    ChronosDB swagger

    ChronosDB time series database API  # noqa: E501

    The version of the OpenAPI document: 0.1
    Contact: apiteam@chronosdb.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openapi_client.api_client import ApiClient
from openapi_client.exceptions import (
    ApiTypeError,
    ApiValueError
)


class RawSpaceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def app_api_space_object_history(self, space_id, **kwargs):  # noqa: E501
        """retrieve history of space object by its id, space_id  # noqa: E501

        retrieve history of space object by its id, space_id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_space_object_history(space_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_id: space id (required)
        :param datetime real_start: start time from when values were valid
        :param datetime real_end: end time until when values were valid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[SpaceHistorical]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_space_object_history_with_http_info(space_id, **kwargs)  # noqa: E501

    def app_api_space_object_history_with_http_info(self, space_id, **kwargs):  # noqa: E501
        """retrieve history of space object by its id, space_id  # noqa: E501

        retrieve history of space object by its id, space_id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_space_object_history_with_http_info(space_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_id: space id (required)
        :param datetime real_start: start time from when values were valid
        :param datetime real_end: end time until when values were valid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[SpaceHistorical], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_id', 'real_start', 'real_end']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_space_object_history" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_id' is set
        if ('space_id' not in local_var_params or
                local_var_params['space_id'] is None):
            raise ApiValueError("Missing the required parameter `space_id` when calling `app_api_space_object_history`")  # noqa: E501

        if 'space_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['space_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_id` when calling `app_api_space_object_history`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_id' in local_var_params:
            path_params['spaceId'] = local_var_params['space_id']  # noqa: E501

        query_params = []
        if 'real_start' in local_var_params:
            query_params.append(('realStart', local_var_params['real_start']))  # noqa: E501
        if 'real_end' in local_var_params:
            query_params.append(('realEnd', local_var_params['real_end']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/space/{spaceId}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[SpaceHistorical]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_space_raw_add_member(self, space_id, **kwargs):  # noqa: E501
        """Add a new space member  # noqa: E501

        Add a new space member  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_space_raw_add_member(space_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_id: space id (required)
        :param SpaceMemberPost space_member_post: space member details
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Space
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_space_raw_add_member_with_http_info(space_id, **kwargs)  # noqa: E501

    def app_api_space_raw_add_member_with_http_info(self, space_id, **kwargs):  # noqa: E501
        """Add a new space member  # noqa: E501

        Add a new space member  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_space_raw_add_member_with_http_info(space_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_id: space id (required)
        :param SpaceMemberPost space_member_post: space member details
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Space, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_id', 'space_member_post']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_space_raw_add_member" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_id' is set
        if ('space_id' not in local_var_params or
                local_var_params['space_id'] is None):
            raise ApiValueError("Missing the required parameter `space_id` when calling `app_api_space_raw_add_member`")  # noqa: E501

        if 'space_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['space_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_id` when calling `app_api_space_raw_add_member`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_id' in local_var_params:
            path_params['spaceId'] = local_var_params['space_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'space_member_post' in local_var_params:
            body_params = local_var_params['space_member_post']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/space/{spaceId}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Space',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_space_raw_delete(self, space_id, **kwargs):  # noqa: E501
        """Delete a space  # noqa: E501

        Delete a space  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_space_raw_delete(space_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_id: space id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_space_raw_delete_with_http_info(space_id, **kwargs)  # noqa: E501

    def app_api_space_raw_delete_with_http_info(self, space_id, **kwargs):  # noqa: E501
        """Delete a space  # noqa: E501

        Delete a space  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_space_raw_delete_with_http_info(space_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_id: space id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_space_raw_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_id' is set
        if ('space_id' not in local_var_params or
                local_var_params['space_id'] is None):
            raise ApiValueError("Missing the required parameter `space_id` when calling `app_api_space_raw_delete`")  # noqa: E501

        if 'space_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['space_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_id` when calling `app_api_space_raw_delete`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_id' in local_var_params:
            path_params['spaceId'] = local_var_params['space_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/space/{spaceId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_space_raw_delete_member(self, space_id, type, id, **kwargs):  # noqa: E501
        """Delete a space member  # noqa: E501

        Delete a space member  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_space_raw_delete_member(space_id, type, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_id: space id (required)
        :param str type: | format of output type * `u` user, * `g` group  (required)
        :param str id: id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Space
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_space_raw_delete_member_with_http_info(space_id, type, id, **kwargs)  # noqa: E501

    def app_api_space_raw_delete_member_with_http_info(self, space_id, type, id, **kwargs):  # noqa: E501
        """Delete a space member  # noqa: E501

        Delete a space member  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_space_raw_delete_member_with_http_info(space_id, type, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_id: space id (required)
        :param str type: | format of output type * `u` user, * `g` group  (required)
        :param str id: id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Space, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_id', 'type', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_space_raw_delete_member" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_id' is set
        if ('space_id' not in local_var_params or
                local_var_params['space_id'] is None):
            raise ApiValueError("Missing the required parameter `space_id` when calling `app_api_space_raw_delete_member`")  # noqa: E501
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `app_api_space_raw_delete_member`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `app_api_space_raw_delete_member`")  # noqa: E501

        if 'space_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['space_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_id` when calling `app_api_space_raw_delete_member`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        if 'id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id` when calling `app_api_space_raw_delete_member`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_id' in local_var_params:
            path_params['spaceId'] = local_var_params['space_id']  # noqa: E501
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/space/{spaceId}/members/{type}/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Space',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_space_raw_get(self, space_id, **kwargs):  # noqa: E501
        """Get space details  # noqa: E501

        Get space details  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_space_raw_get(space_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_id: space id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Space
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_space_raw_get_with_http_info(space_id, **kwargs)  # noqa: E501

    def app_api_space_raw_get_with_http_info(self, space_id, **kwargs):  # noqa: E501
        """Get space details  # noqa: E501

        Get space details  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_space_raw_get_with_http_info(space_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_id: space id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Space, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_space_raw_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_id' is set
        if ('space_id' not in local_var_params or
                local_var_params['space_id'] is None):
            raise ApiValueError("Missing the required parameter `space_id` when calling `app_api_space_raw_get`")  # noqa: E501

        if 'space_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['space_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_id` when calling `app_api_space_raw_get`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_id' in local_var_params:
            path_params['spaceId'] = local_var_params['space_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/space/{spaceId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Space',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_space_raw_get_list(self, **kwargs):  # noqa: E501
        """list spaces  # noqa: E501

        list spaces  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_space_raw_get_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str member: a member of group/space/collection/etc.
        :param bool own_only: ownOnly
        :param Visibility visibility: visibility
        :param str query: Search query
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Space]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_space_raw_get_list_with_http_info(**kwargs)  # noqa: E501

    def app_api_space_raw_get_list_with_http_info(self, **kwargs):  # noqa: E501
        """list spaces  # noqa: E501

        list spaces  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_space_raw_get_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str member: a member of group/space/collection/etc.
        :param bool own_only: ownOnly
        :param Visibility visibility: visibility
        :param str query: Search query
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Space], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['member', 'own_only', 'visibility', 'query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_space_raw_get_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if 'member' in local_var_params and not re.search(r'^([ug]):([0-9a-fA-F]{24})$', local_var_params['member']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `member` when calling `app_api_space_raw_get_list`, must conform to the pattern `/^([ug]):([0-9a-fA-F]{24})$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'member' in local_var_params:
            query_params.append(('member', local_var_params['member']))  # noqa: E501
        if 'own_only' in local_var_params:
            query_params.append(('ownOnly', local_var_params['own_only']))  # noqa: E501
        if 'visibility' in local_var_params:
            query_params.append(('visibility', local_var_params['visibility']))  # noqa: E501
        if 'query' in local_var_params:
            query_params.append(('query', local_var_params['query']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/space', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Space]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_space_raw_post(self, space, **kwargs):  # noqa: E501
        """Create a new space  # noqa: E501

        Create a new space  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_space_raw_post(space, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Space space: Space definition (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Space
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_space_raw_post_with_http_info(space, **kwargs)  # noqa: E501

    def app_api_space_raw_post_with_http_info(self, space, **kwargs):  # noqa: E501
        """Create a new space  # noqa: E501

        Create a new space  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_space_raw_post_with_http_info(space, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Space space: Space definition (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Space, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_space_raw_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space' is set
        if ('space' not in local_var_params or
                local_var_params['space'] is None):
            raise ApiValueError("Missing the required parameter `space` when calling `app_api_space_raw_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'space' in local_var_params:
            body_params = local_var_params['space']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/space', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Space',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_space_raw_put(self, space_id, space, **kwargs):  # noqa: E501
        """Update an existing space  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_space_raw_put(space_id, space, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_id: space id (required)
        :param Space space: Optional description in *Markdown* (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Space
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_space_raw_put_with_http_info(space_id, space, **kwargs)  # noqa: E501

    def app_api_space_raw_put_with_http_info(self, space_id, space, **kwargs):  # noqa: E501
        """Update an existing space  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_space_raw_put_with_http_info(space_id, space, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_id: space id (required)
        :param Space space: Optional description in *Markdown* (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Space, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_id', 'space']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_space_raw_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_id' is set
        if ('space_id' not in local_var_params or
                local_var_params['space_id'] is None):
            raise ApiValueError("Missing the required parameter `space_id` when calling `app_api_space_raw_put`")  # noqa: E501
        # verify the required parameter 'space' is set
        if ('space' not in local_var_params or
                local_var_params['space'] is None):
            raise ApiValueError("Missing the required parameter `space` when calling `app_api_space_raw_put`")  # noqa: E501

        if 'space_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['space_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_id` when calling `app_api_space_raw_put`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_id' in local_var_params:
            path_params['spaceId'] = local_var_params['space_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'space' in local_var_params:
            body_params = local_var_params['space']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/space/{spaceId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Space',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_space_raw_undelete(self, space_id, **kwargs):  # noqa: E501
        """Undelete space  # noqa: E501

        Undelete space  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_space_raw_undelete(space_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_id: space id (required)
        :param str name: new name for space
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_space_raw_undelete_with_http_info(space_id, **kwargs)  # noqa: E501

    def app_api_space_raw_undelete_with_http_info(self, space_id, **kwargs):  # noqa: E501
        """Undelete space  # noqa: E501

        Undelete space  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_space_raw_undelete_with_http_info(space_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_id: space id (required)
        :param str name: new name for space
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_id', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_space_raw_undelete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_id' is set
        if ('space_id' not in local_var_params or
                local_var_params['space_id'] is None):
            raise ApiValueError("Missing the required parameter `space_id` when calling `app_api_space_raw_undelete`")  # noqa: E501

        if 'space_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['space_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_id` when calling `app_api_space_raw_undelete`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        if 'name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `name` when calling `app_api_space_raw_undelete`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_id' in local_var_params:
            path_params['spaceId'] = local_var_params['space_id']  # noqa: E501

        query_params = []
        if 'name' in local_var_params:
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/space/{spaceId}/undelete', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
