# coding: utf-8

"""
    ChronosDB swagger

    ChronosDB time series database API  # noqa: E501

    The version of the OpenAPI document: 0.1
    Contact: apiteam@chronosdb.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openapi_client.api_client import ApiClient
from openapi_client.exceptions import (
    ApiTypeError,
    ApiValueError
)


class RawGroupApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def app_api_group_object_history(self, gid, **kwargs):  # noqa: E501
        """retrieve history of group object by its id  # noqa: E501

        retrieve history of group object by its id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_group_object_history(gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str gid: The group's unique id. (required)
        :param datetime real_start: start time from when values were valid
        :param datetime real_end: end time until when values were valid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[GroupHistorical]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_group_object_history_with_http_info(gid, **kwargs)  # noqa: E501

    def app_api_group_object_history_with_http_info(self, gid, **kwargs):  # noqa: E501
        """retrieve history of group object by its id  # noqa: E501

        retrieve history of group object by its id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_group_object_history_with_http_info(gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str gid: The group's unique id. (required)
        :param datetime real_start: start time from when values were valid
        :param datetime real_end: end time until when values were valid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[GroupHistorical], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['gid', 'real_start', 'real_end']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_group_object_history" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'gid' is set
        if ('gid' not in local_var_params or
                local_var_params['gid'] is None):
            raise ApiValueError("Missing the required parameter `gid` when calling `app_api_group_object_history`")  # noqa: E501

        if 'gid' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['gid']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `gid` when calling `app_api_group_object_history`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'gid' in local_var_params:
            path_params['gid'] = local_var_params['gid']  # noqa: E501

        query_params = []
        if 'real_start' in local_var_params:
            query_params.append(('realStart', local_var_params['real_start']))  # noqa: E501
        if 'real_end' in local_var_params:
            query_params.append(('realEnd', local_var_params['real_end']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/group/{gid}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GroupHistorical]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_group_raw_add_member(self, gid, **kwargs):  # noqa: E501
        """Add a new group member  # noqa: E501

        Add a new group member  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_group_raw_add_member(gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str gid: The group's unique id. (required)
        :param GroupMemberPost group_member_post: group member details
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Group
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_group_raw_add_member_with_http_info(gid, **kwargs)  # noqa: E501

    def app_api_group_raw_add_member_with_http_info(self, gid, **kwargs):  # noqa: E501
        """Add a new group member  # noqa: E501

        Add a new group member  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_group_raw_add_member_with_http_info(gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str gid: The group's unique id. (required)
        :param GroupMemberPost group_member_post: group member details
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Group, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['gid', 'group_member_post']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_group_raw_add_member" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'gid' is set
        if ('gid' not in local_var_params or
                local_var_params['gid'] is None):
            raise ApiValueError("Missing the required parameter `gid` when calling `app_api_group_raw_add_member`")  # noqa: E501

        if 'gid' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['gid']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `gid` when calling `app_api_group_raw_add_member`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'gid' in local_var_params:
            path_params['gid'] = local_var_params['gid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'group_member_post' in local_var_params:
            body_params = local_var_params['group_member_post']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/group/{gid}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Group',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_group_raw_create_group(self, **kwargs):  # noqa: E501
        """Create a new group  # noqa: E501

        Create a new group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_group_raw_create_group(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Group group:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Group
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_group_raw_create_group_with_http_info(**kwargs)  # noqa: E501

    def app_api_group_raw_create_group_with_http_info(self, **kwargs):  # noqa: E501
        """Create a new group  # noqa: E501

        Create a new group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_group_raw_create_group_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Group group:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Group, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_group_raw_create_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'group' in local_var_params:
            body_params = local_var_params['group']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/group', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Group',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_group_raw_delete_group(self, gid, **kwargs):  # noqa: E501
        """Delete a group  # noqa: E501

        Delete a group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_group_raw_delete_group(gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str gid: The group's unique id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_group_raw_delete_group_with_http_info(gid, **kwargs)  # noqa: E501

    def app_api_group_raw_delete_group_with_http_info(self, gid, **kwargs):  # noqa: E501
        """Delete a group  # noqa: E501

        Delete a group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_group_raw_delete_group_with_http_info(gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str gid: The group's unique id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['gid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_group_raw_delete_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'gid' is set
        if ('gid' not in local_var_params or
                local_var_params['gid'] is None):
            raise ApiValueError("Missing the required parameter `gid` when calling `app_api_group_raw_delete_group`")  # noqa: E501

        if 'gid' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['gid']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `gid` when calling `app_api_group_raw_delete_group`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'gid' in local_var_params:
            path_params['gid'] = local_var_params['gid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/group/{gid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_group_raw_delete_member(self, gid, type, id, **kwargs):  # noqa: E501
        """Delete a group member  # noqa: E501

        Delete a group member  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_group_raw_delete_member(gid, type, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str gid: The group's unique id. (required)
        :param str type: | format of output type * `u` user, * `g` group  (required)
        :param str id: id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Group
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_group_raw_delete_member_with_http_info(gid, type, id, **kwargs)  # noqa: E501

    def app_api_group_raw_delete_member_with_http_info(self, gid, type, id, **kwargs):  # noqa: E501
        """Delete a group member  # noqa: E501

        Delete a group member  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_group_raw_delete_member_with_http_info(gid, type, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str gid: The group's unique id. (required)
        :param str type: | format of output type * `u` user, * `g` group  (required)
        :param str id: id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Group, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['gid', 'type', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_group_raw_delete_member" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'gid' is set
        if ('gid' not in local_var_params or
                local_var_params['gid'] is None):
            raise ApiValueError("Missing the required parameter `gid` when calling `app_api_group_raw_delete_member`")  # noqa: E501
        # verify the required parameter 'type' is set
        if ('type' not in local_var_params or
                local_var_params['type'] is None):
            raise ApiValueError("Missing the required parameter `type` when calling `app_api_group_raw_delete_member`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in local_var_params or
                local_var_params['id'] is None):
            raise ApiValueError("Missing the required parameter `id` when calling `app_api_group_raw_delete_member`")  # noqa: E501

        if 'gid' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['gid']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `gid` when calling `app_api_group_raw_delete_member`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        if 'id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `id` when calling `app_api_group_raw_delete_member`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'gid' in local_var_params:
            path_params['gid'] = local_var_params['gid']  # noqa: E501
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/group/{gid}/members/{type}/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Group',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_group_raw_get_group(self, gid, **kwargs):  # noqa: E501
        """Retrieve a group  # noqa: E501

        Retrieve a group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_group_raw_get_group(gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str gid: The group's unique id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Group
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_group_raw_get_group_with_http_info(gid, **kwargs)  # noqa: E501

    def app_api_group_raw_get_group_with_http_info(self, gid, **kwargs):  # noqa: E501
        """Retrieve a group  # noqa: E501

        Retrieve a group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_group_raw_get_group_with_http_info(gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str gid: The group's unique id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Group, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['gid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_group_raw_get_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'gid' is set
        if ('gid' not in local_var_params or
                local_var_params['gid'] is None):
            raise ApiValueError("Missing the required parameter `gid` when calling `app_api_group_raw_get_group`")  # noqa: E501

        if 'gid' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['gid']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `gid` when calling `app_api_group_raw_get_group`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'gid' in local_var_params:
            path_params['gid'] = local_var_params['gid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/group/{gid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Group',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_group_raw_list_groups(self, **kwargs):  # noqa: E501
        """Retrieve all groups for a member  # noqa: E501

        Retrieve all groups for a member  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_group_raw_list_groups(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str query: Search query
        :param str member: a member of group/space/collection/etc.
        :param bool own_only: ownOnly
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[GroupSummary]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_group_raw_list_groups_with_http_info(**kwargs)  # noqa: E501

    def app_api_group_raw_list_groups_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve all groups for a member  # noqa: E501

        Retrieve all groups for a member  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_group_raw_list_groups_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str query: Search query
        :param str member: a member of group/space/collection/etc.
        :param bool own_only: ownOnly
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[GroupSummary], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['query', 'member', 'own_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_group_raw_list_groups" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if 'member' in local_var_params and not re.search(r'^([ug]):([0-9a-fA-F]{24})$', local_var_params['member']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `member` when calling `app_api_group_raw_list_groups`, must conform to the pattern `/^([ug]):([0-9a-fA-F]{24})$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'query' in local_var_params:
            query_params.append(('query', local_var_params['query']))  # noqa: E501
        if 'member' in local_var_params:
            query_params.append(('member', local_var_params['member']))  # noqa: E501
        if 'own_only' in local_var_params:
            query_params.append(('ownOnly', local_var_params['own_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/group', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GroupSummary]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_group_raw_undelete(self, gid, **kwargs):  # noqa: E501
        """Undelete group  # noqa: E501

        Undelete group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_group_raw_undelete(gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str gid: The group's unique id. (required)
        :param str groupname: new name for group
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_group_raw_undelete_with_http_info(gid, **kwargs)  # noqa: E501

    def app_api_group_raw_undelete_with_http_info(self, gid, **kwargs):  # noqa: E501
        """Undelete group  # noqa: E501

        Undelete group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_group_raw_undelete_with_http_info(gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str gid: The group's unique id. (required)
        :param str groupname: new name for group
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['gid', 'groupname']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_group_raw_undelete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'gid' is set
        if ('gid' not in local_var_params or
                local_var_params['gid'] is None):
            raise ApiValueError("Missing the required parameter `gid` when calling `app_api_group_raw_undelete`")  # noqa: E501

        if 'gid' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['gid']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `gid` when calling `app_api_group_raw_undelete`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        if 'groupname' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['groupname']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `groupname` when calling `app_api_group_raw_undelete`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'gid' in local_var_params:
            path_params['gid'] = local_var_params['gid']  # noqa: E501

        query_params = []
        if 'groupname' in local_var_params:
            query_params.append(('groupname', local_var_params['groupname']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/group/{gid}/undelete', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_group_raw_update_group(self, gid, **kwargs):  # noqa: E501
        """Update a group  # noqa: E501

        Update a group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_group_raw_update_group(gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str gid: The group's unique id. (required)
        :param Group group: an updated group
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Group
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_group_raw_update_group_with_http_info(gid, **kwargs)  # noqa: E501

    def app_api_group_raw_update_group_with_http_info(self, gid, **kwargs):  # noqa: E501
        """Update a group  # noqa: E501

        Update a group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_group_raw_update_group_with_http_info(gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str gid: The group's unique id. (required)
        :param Group group: an updated group
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Group, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['gid', 'group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_group_raw_update_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'gid' is set
        if ('gid' not in local_var_params or
                local_var_params['gid'] is None):
            raise ApiValueError("Missing the required parameter `gid` when calling `app_api_group_raw_update_group`")  # noqa: E501

        if 'gid' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['gid']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `gid` when calling `app_api_group_raw_update_group`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'gid' in local_var_params:
            path_params['gid'] = local_var_params['gid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'group' in local_var_params:
            body_params = local_var_params['group']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/group/{gid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Group',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
