# coding: utf-8

"""
    ChronosDB swagger

    ChronosDB time series database API  # noqa: E501

    The version of the OpenAPI document: 0.1
    Contact: apiteam@chronosdb.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openapi_client.api_client import ApiClient
from openapi_client.exceptions import (
    ApiTypeError,
    ApiValueError
)


class RawAnnotationsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def app_api_annotation_raw_add_target(self, coll_id, aid, **kwargs):  # noqa: E501
        """Add a target  # noqa: E501

        Add observation target  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_raw_add_target(coll_id, aid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str aid: annotation id (required)
        :param str tsid: time series id
        :param int index: time series index
        :param Frequency freq: frequency
        :param datetime real_start: start time from when values were valid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Annotation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_annotation_raw_add_target_with_http_info(coll_id, aid, **kwargs)  # noqa: E501

    def app_api_annotation_raw_add_target_with_http_info(self, coll_id, aid, **kwargs):  # noqa: E501
        """Add a target  # noqa: E501

        Add observation target  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_raw_add_target_with_http_info(coll_id, aid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str aid: annotation id (required)
        :param str tsid: time series id
        :param int index: time series index
        :param Frequency freq: frequency
        :param datetime real_start: start time from when values were valid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Annotation, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'aid', 'tsid', 'index', 'freq', 'real_start']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_annotation_raw_add_target" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'coll_id' is set
        if ('coll_id' not in local_var_params or
                local_var_params['coll_id'] is None):
            raise ApiValueError("Missing the required parameter `coll_id` when calling `app_api_annotation_raw_add_target`")  # noqa: E501
        # verify the required parameter 'aid' is set
        if ('aid' not in local_var_params or
                local_var_params['aid'] is None):
            raise ApiValueError("Missing the required parameter `aid` when calling `app_api_annotation_raw_add_target`")  # noqa: E501

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_annotation_raw_add_target`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        if 'tsid' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['tsid']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `tsid` when calling `app_api_annotation_raw_add_target`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'coll_id' in local_var_params:
            path_params['collId'] = local_var_params['coll_id']  # noqa: E501
        if 'aid' in local_var_params:
            path_params['aid'] = local_var_params['aid']  # noqa: E501

        query_params = []
        if 'tsid' in local_var_params:
            query_params.append(('tsid', local_var_params['tsid']))  # noqa: E501
        if 'index' in local_var_params:
            query_params.append(('index', local_var_params['index']))  # noqa: E501
        if 'freq' in local_var_params:
            query_params.append(('freq', local_var_params['freq']))  # noqa: E501
        if 'real_start' in local_var_params:
            query_params.append(('realStart', local_var_params['real_start']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/annotation/{collId}/{aid}/targets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Annotation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_annotation_raw_create(self, coll_id, annotation, **kwargs):  # noqa: E501
        """Create an annotation  # noqa: E501

        Create an annotation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_raw_create(coll_id, annotation, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param Annotation annotation: Annotation (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Annotation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_annotation_raw_create_with_http_info(coll_id, annotation, **kwargs)  # noqa: E501

    def app_api_annotation_raw_create_with_http_info(self, coll_id, annotation, **kwargs):  # noqa: E501
        """Create an annotation  # noqa: E501

        Create an annotation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_raw_create_with_http_info(coll_id, annotation, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param Annotation annotation: Annotation (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Annotation, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'annotation']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_annotation_raw_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'coll_id' is set
        if ('coll_id' not in local_var_params or
                local_var_params['coll_id'] is None):
            raise ApiValueError("Missing the required parameter `coll_id` when calling `app_api_annotation_raw_create`")  # noqa: E501
        # verify the required parameter 'annotation' is set
        if ('annotation' not in local_var_params or
                local_var_params['annotation'] is None):
            raise ApiValueError("Missing the required parameter `annotation` when calling `app_api_annotation_raw_create`")  # noqa: E501

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_annotation_raw_create`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'coll_id' in local_var_params:
            path_params['collId'] = local_var_params['coll_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'annotation' in local_var_params:
            body_params = local_var_params['annotation']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/annotation/{collId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Annotation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_annotation_raw_delete(self, coll_id, aid, **kwargs):  # noqa: E501
        """Delete annotation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_raw_delete(coll_id, aid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str aid: annotation id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_annotation_raw_delete_with_http_info(coll_id, aid, **kwargs)  # noqa: E501

    def app_api_annotation_raw_delete_with_http_info(self, coll_id, aid, **kwargs):  # noqa: E501
        """Delete annotation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_raw_delete_with_http_info(coll_id, aid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str aid: annotation id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'aid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_annotation_raw_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'coll_id' is set
        if ('coll_id' not in local_var_params or
                local_var_params['coll_id'] is None):
            raise ApiValueError("Missing the required parameter `coll_id` when calling `app_api_annotation_raw_delete`")  # noqa: E501
        # verify the required parameter 'aid' is set
        if ('aid' not in local_var_params or
                local_var_params['aid'] is None):
            raise ApiValueError("Missing the required parameter `aid` when calling `app_api_annotation_raw_delete`")  # noqa: E501

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_annotation_raw_delete`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'coll_id' in local_var_params:
            path_params['collId'] = local_var_params['coll_id']  # noqa: E501
        if 'aid' in local_var_params:
            path_params['aid'] = local_var_params['aid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/annotation/{collId}/{aid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_annotation_raw_get(self, coll_id, aid, **kwargs):  # noqa: E501
        """Get an annotation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_raw_get(coll_id, aid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str aid: annotation id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Annotation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_annotation_raw_get_with_http_info(coll_id, aid, **kwargs)  # noqa: E501

    def app_api_annotation_raw_get_with_http_info(self, coll_id, aid, **kwargs):  # noqa: E501
        """Get an annotation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_raw_get_with_http_info(coll_id, aid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str aid: annotation id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Annotation, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'aid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_annotation_raw_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'coll_id' is set
        if ('coll_id' not in local_var_params or
                local_var_params['coll_id'] is None):
            raise ApiValueError("Missing the required parameter `coll_id` when calling `app_api_annotation_raw_get`")  # noqa: E501
        # verify the required parameter 'aid' is set
        if ('aid' not in local_var_params or
                local_var_params['aid'] is None):
            raise ApiValueError("Missing the required parameter `aid` when calling `app_api_annotation_raw_get`")  # noqa: E501

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_annotation_raw_get`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'coll_id' in local_var_params:
            path_params['collId'] = local_var_params['coll_id']  # noqa: E501
        if 'aid' in local_var_params:
            path_params['aid'] = local_var_params['aid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/annotation/{collId}/{aid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Annotation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_annotation_raw_get_list(self, coll_id, **kwargs):  # noqa: E501
        """List annotations  # noqa: E501

        List annotations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_raw_get_list(coll_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str tsid: time series id
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[AnnotationSummary]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_annotation_raw_get_list_with_http_info(coll_id, **kwargs)  # noqa: E501

    def app_api_annotation_raw_get_list_with_http_info(self, coll_id, **kwargs):  # noqa: E501
        """List annotations  # noqa: E501

        List annotations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_raw_get_list_with_http_info(coll_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str tsid: time series id
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[AnnotationSummary], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'tsid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_annotation_raw_get_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'coll_id' is set
        if ('coll_id' not in local_var_params or
                local_var_params['coll_id'] is None):
            raise ApiValueError("Missing the required parameter `coll_id` when calling `app_api_annotation_raw_get_list`")  # noqa: E501

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_annotation_raw_get_list`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'coll_id' in local_var_params:
            path_params['collId'] = local_var_params['coll_id']  # noqa: E501

        query_params = []
        if 'tsid' in local_var_params:
            query_params.append(('tsid', local_var_params['tsid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/annotation/{collId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AnnotationSummary]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_annotation_raw_history(self, coll_id, aid, **kwargs):  # noqa: E501
        """History of annotation changes  # noqa: E501

        History of annotation changes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_raw_history(coll_id, aid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str aid: annotation id (required)
        :param datetime real_start: start time from when values were valid
        :param datetime real_end: end time until when values were valid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Annotation]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_annotation_raw_history_with_http_info(coll_id, aid, **kwargs)  # noqa: E501

    def app_api_annotation_raw_history_with_http_info(self, coll_id, aid, **kwargs):  # noqa: E501
        """History of annotation changes  # noqa: E501

        History of annotation changes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_raw_history_with_http_info(coll_id, aid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str aid: annotation id (required)
        :param datetime real_start: start time from when values were valid
        :param datetime real_end: end time until when values were valid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Annotation], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'aid', 'real_start', 'real_end']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_annotation_raw_history" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'coll_id' is set
        if ('coll_id' not in local_var_params or
                local_var_params['coll_id'] is None):
            raise ApiValueError("Missing the required parameter `coll_id` when calling `app_api_annotation_raw_history`")  # noqa: E501
        # verify the required parameter 'aid' is set
        if ('aid' not in local_var_params or
                local_var_params['aid'] is None):
            raise ApiValueError("Missing the required parameter `aid` when calling `app_api_annotation_raw_history`")  # noqa: E501

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_annotation_raw_history`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'coll_id' in local_var_params:
            path_params['collId'] = local_var_params['coll_id']  # noqa: E501
        if 'aid' in local_var_params:
            path_params['aid'] = local_var_params['aid']  # noqa: E501

        query_params = []
        if 'real_start' in local_var_params:
            query_params.append(('realStart', local_var_params['real_start']))  # noqa: E501
        if 'real_end' in local_var_params:
            query_params.append(('realEnd', local_var_params['real_end']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/annotation/{collId}/{aid}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Annotation]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_annotation_raw_remove_target(self, coll_id, aid, **kwargs):  # noqa: E501
        """delete a target  # noqa: E501

        delete observation targets  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_raw_remove_target(coll_id, aid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str aid: annotation id (required)
        :param str tsid: time series id
        :param int index: time series index
        :param Frequency freq: frequency
        :param datetime real_start: start time from when values were valid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Annotation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_annotation_raw_remove_target_with_http_info(coll_id, aid, **kwargs)  # noqa: E501

    def app_api_annotation_raw_remove_target_with_http_info(self, coll_id, aid, **kwargs):  # noqa: E501
        """delete a target  # noqa: E501

        delete observation targets  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_raw_remove_target_with_http_info(coll_id, aid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str aid: annotation id (required)
        :param str tsid: time series id
        :param int index: time series index
        :param Frequency freq: frequency
        :param datetime real_start: start time from when values were valid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Annotation, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'aid', 'tsid', 'index', 'freq', 'real_start']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_annotation_raw_remove_target" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'coll_id' is set
        if ('coll_id' not in local_var_params or
                local_var_params['coll_id'] is None):
            raise ApiValueError("Missing the required parameter `coll_id` when calling `app_api_annotation_raw_remove_target`")  # noqa: E501
        # verify the required parameter 'aid' is set
        if ('aid' not in local_var_params or
                local_var_params['aid'] is None):
            raise ApiValueError("Missing the required parameter `aid` when calling `app_api_annotation_raw_remove_target`")  # noqa: E501

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_annotation_raw_remove_target`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        if 'tsid' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['tsid']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `tsid` when calling `app_api_annotation_raw_remove_target`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'coll_id' in local_var_params:
            path_params['collId'] = local_var_params['coll_id']  # noqa: E501
        if 'aid' in local_var_params:
            path_params['aid'] = local_var_params['aid']  # noqa: E501

        query_params = []
        if 'tsid' in local_var_params:
            query_params.append(('tsid', local_var_params['tsid']))  # noqa: E501
        if 'index' in local_var_params:
            query_params.append(('index', local_var_params['index']))  # noqa: E501
        if 'freq' in local_var_params:
            query_params.append(('freq', local_var_params['freq']))  # noqa: E501
        if 'real_start' in local_var_params:
            query_params.append(('realStart', local_var_params['real_start']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/annotation/{collId}/{aid}/targets', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Annotation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_annotation_raw_update(self, coll_id, aid, annotation_update, **kwargs):  # noqa: E501
        """Update an annotation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_raw_update(coll_id, aid, annotation_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str aid: annotation id (required)
        :param AnnotationUpdate annotation_update: Annotation (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_annotation_raw_update_with_http_info(coll_id, aid, annotation_update, **kwargs)  # noqa: E501

    def app_api_annotation_raw_update_with_http_info(self, coll_id, aid, annotation_update, **kwargs):  # noqa: E501
        """Update an annotation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_raw_update_with_http_info(coll_id, aid, annotation_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str coll_id: collection id (required)
        :param str aid: annotation id (required)
        :param AnnotationUpdate annotation_update: Annotation (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['coll_id', 'aid', 'annotation_update']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_annotation_raw_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'coll_id' is set
        if ('coll_id' not in local_var_params or
                local_var_params['coll_id'] is None):
            raise ApiValueError("Missing the required parameter `coll_id` when calling `app_api_annotation_raw_update`")  # noqa: E501
        # verify the required parameter 'aid' is set
        if ('aid' not in local_var_params or
                local_var_params['aid'] is None):
            raise ApiValueError("Missing the required parameter `aid` when calling `app_api_annotation_raw_update`")  # noqa: E501
        # verify the required parameter 'annotation_update' is set
        if ('annotation_update' not in local_var_params or
                local_var_params['annotation_update'] is None):
            raise ApiValueError("Missing the required parameter `annotation_update` when calling `app_api_annotation_raw_update`")  # noqa: E501

        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_annotation_raw_update`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'coll_id' in local_var_params:
            path_params['collId'] = local_var_params['coll_id']  # noqa: E501
        if 'aid' in local_var_params:
            path_params['aid'] = local_var_params['aid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'annotation_update' in local_var_params:
            body_params = local_var_params['annotation_update']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/annotation/{collId}/{aid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
