# coding: utf-8

"""
    ChronosDB swagger

    ChronosDB time series database API  # noqa: E501

    The version of the OpenAPI document: 0.1
    Contact: apiteam@chronosdb.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openapi_client.api_client import ApiClient
from openapi_client.exceptions import (
    ApiTypeError,
    ApiValueError
)


class PermissionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def app_api_permission_get(self, **kwargs):  # noqa: E501
        """List permissions for object  # noqa: E501

        List explicit permissions for object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_permission_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_id: space id
        :param str coll_id: collection id
        :param str tsid: time series id
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Policy]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_permission_get_with_http_info(**kwargs)  # noqa: E501

    def app_api_permission_get_with_http_info(self, **kwargs):  # noqa: E501
        """List permissions for object  # noqa: E501

        List explicit permissions for object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_permission_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_id: space id
        :param str coll_id: collection id
        :param str tsid: time series id
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Policy], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_id', 'coll_id', 'tsid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_permission_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if 'space_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['space_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_id` when calling `app_api_permission_get`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_permission_get`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        if 'tsid' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['tsid']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `tsid` when calling `app_api_permission_get`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'space_id' in local_var_params:
            query_params.append(('space_id', local_var_params['space_id']))  # noqa: E501
        if 'coll_id' in local_var_params:
            query_params.append(('coll_id', local_var_params['coll_id']))  # noqa: E501
        if 'tsid' in local_var_params:
            query_params.append(('tsid', local_var_params['tsid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/permissions/object', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Policy]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_permission_remove_permission(self, obj_type, subobject, action, effect, **kwargs):  # noqa: E501
        """delete permission  # noqa: E501

        delete permission  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_permission_remove_permission(obj_type, subobject, action, effect, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ObjectType obj_type: object (required)
        :param bool subobject: subobject mark (required)
        :param str action: action can be Verb or Role (required)
        :param str effect: permission effect (required)
        :param str uid: user id
        :param str gid: group id
        :param str space_id: space id
        :param str coll_id: collection id
        :param str tsid: time series id
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_permission_remove_permission_with_http_info(obj_type, subobject, action, effect, **kwargs)  # noqa: E501

    def app_api_permission_remove_permission_with_http_info(self, obj_type, subobject, action, effect, **kwargs):  # noqa: E501
        """delete permission  # noqa: E501

        delete permission  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_permission_remove_permission_with_http_info(obj_type, subobject, action, effect, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ObjectType obj_type: object (required)
        :param bool subobject: subobject mark (required)
        :param str action: action can be Verb or Role (required)
        :param str effect: permission effect (required)
        :param str uid: user id
        :param str gid: group id
        :param str space_id: space id
        :param str coll_id: collection id
        :param str tsid: time series id
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['obj_type', 'subobject', 'action', 'effect', 'uid', 'gid', 'space_id', 'coll_id', 'tsid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_permission_remove_permission" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'obj_type' is set
        if ('obj_type' not in local_var_params or
                local_var_params['obj_type'] is None):
            raise ApiValueError("Missing the required parameter `obj_type` when calling `app_api_permission_remove_permission`")  # noqa: E501
        # verify the required parameter 'subobject' is set
        if ('subobject' not in local_var_params or
                local_var_params['subobject'] is None):
            raise ApiValueError("Missing the required parameter `subobject` when calling `app_api_permission_remove_permission`")  # noqa: E501
        # verify the required parameter 'action' is set
        if ('action' not in local_var_params or
                local_var_params['action'] is None):
            raise ApiValueError("Missing the required parameter `action` when calling `app_api_permission_remove_permission`")  # noqa: E501
        # verify the required parameter 'effect' is set
        if ('effect' not in local_var_params or
                local_var_params['effect'] is None):
            raise ApiValueError("Missing the required parameter `effect` when calling `app_api_permission_remove_permission`")  # noqa: E501

        if 'uid' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['uid']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `uid` when calling `app_api_permission_remove_permission`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        if 'gid' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['gid']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `gid` when calling `app_api_permission_remove_permission`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        if 'space_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['space_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_id` when calling `app_api_permission_remove_permission`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        if 'coll_id' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['coll_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_id` when calling `app_api_permission_remove_permission`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        if 'tsid' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['tsid']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `tsid` when calling `app_api_permission_remove_permission`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'uid' in local_var_params:
            query_params.append(('uid', local_var_params['uid']))  # noqa: E501
        if 'gid' in local_var_params:
            query_params.append(('gid', local_var_params['gid']))  # noqa: E501
        if 'obj_type' in local_var_params:
            query_params.append(('obj_type', local_var_params['obj_type']))  # noqa: E501
        if 'subobject' in local_var_params:
            query_params.append(('subobject', local_var_params['subobject']))  # noqa: E501
        if 'space_id' in local_var_params:
            query_params.append(('space_id', local_var_params['space_id']))  # noqa: E501
        if 'coll_id' in local_var_params:
            query_params.append(('coll_id', local_var_params['coll_id']))  # noqa: E501
        if 'tsid' in local_var_params:
            query_params.append(('tsid', local_var_params['tsid']))  # noqa: E501
        if 'action' in local_var_params:
            query_params.append(('action', local_var_params['action']))  # noqa: E501
        if 'effect' in local_var_params:
            query_params.append(('effect', local_var_params['effect']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/permissions', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_permission_set_permission(self, policy_update, **kwargs):  # noqa: E501
        """Set permissions  # noqa: E501

        Set permissions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_permission_set_permission(policy_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param PolicyUpdate policy_update: Policy definition (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_permission_set_permission_with_http_info(policy_update, **kwargs)  # noqa: E501

    def app_api_permission_set_permission_with_http_info(self, policy_update, **kwargs):  # noqa: E501
        """Set permissions  # noqa: E501

        Set permissions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_permission_set_permission_with_http_info(policy_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param PolicyUpdate policy_update: Policy definition (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['policy_update']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_permission_set_permission" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'policy_update' is set
        if ('policy_update' not in local_var_params or
                local_var_params['policy_update'] is None):
            raise ApiValueError("Missing the required parameter `policy_update` when calling `app_api_permission_set_permission`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'policy_update' in local_var_params:
            body_params = local_var_params['policy_update']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/raw/permissions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
