# coding: utf-8

"""
    ChronosDB swagger

    ChronosDB time series database API  # noqa: E501

    The version of the OpenAPI document: 0.1
    Contact: apiteam@chronosdb.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openapi_client.api_client import ApiClient
from openapi_client.exceptions import (
    ApiTypeError,
    ApiValueError
)


class CollectionApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def app_api_collection_delete(self, space_name, coll_name, **kwargs):  # noqa: E501
        """Delete a collection  # noqa: E501

        Delete a space  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_collection_delete(space_name, coll_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_collection_delete_with_http_info(space_name, coll_name, **kwargs)  # noqa: E501

    def app_api_collection_delete_with_http_info(self, space_name, coll_name, **kwargs):  # noqa: E501
        """Delete a collection  # noqa: E501

        Delete a space  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_collection_delete_with_http_info(space_name, coll_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'coll_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_collection_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_collection_delete`")  # noqa: E501
        # verify the required parameter 'coll_name' is set
        if ('coll_name' not in local_var_params or
                local_var_params['coll_name'] is None):
            raise ApiValueError("Missing the required parameter `coll_name` when calling `app_api_collection_delete`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_collection_delete`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'coll_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['coll_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_name` when calling `app_api_collection_delete`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501
        if 'coll_name' in local_var_params:
            path_params['coll_name'] = local_var_params['coll_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{space_name}/{coll_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_collection_get(self, space_name, coll_name, **kwargs):  # noqa: E501
        """Get collection details  # noqa: E501

        Get collection details  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_collection_get(space_name, coll_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Collection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_collection_get_with_http_info(space_name, coll_name, **kwargs)  # noqa: E501

    def app_api_collection_get_with_http_info(self, space_name, coll_name, **kwargs):  # noqa: E501
        """Get collection details  # noqa: E501

        Get collection details  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_collection_get_with_http_info(space_name, coll_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Collection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'coll_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_collection_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_collection_get`")  # noqa: E501
        # verify the required parameter 'coll_name' is set
        if ('coll_name' not in local_var_params or
                local_var_params['coll_name'] is None):
            raise ApiValueError("Missing the required parameter `coll_name` when calling `app_api_collection_get`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_collection_get`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'coll_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['coll_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_name` when calling `app_api_collection_get`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501
        if 'coll_name' in local_var_params:
            path_params['coll_name'] = local_var_params['coll_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{space_name}/{coll_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Collection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_collection_get_list(self, space_name, **kwargs):  # noqa: E501
        """list collections  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_collection_get_list(space_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str query: Search query
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[CollectionSummary]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_collection_get_list_with_http_info(space_name, **kwargs)  # noqa: E501

    def app_api_collection_get_list_with_http_info(self, space_name, **kwargs):  # noqa: E501
        """list collections  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_collection_get_list_with_http_info(space_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str query: Search query
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[CollectionSummary], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_collection_get_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_collection_get_list`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_collection_get_list`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501

        query_params = []
        if 'query' in local_var_params:
            query_params.append(('query', local_var_params['query']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{space_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CollectionSummary]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_collection_name_history(self, space_name, coll_name, **kwargs):  # noqa: E501
        """Retrieve historical values of collection details  # noqa: E501

        Retrieve historical values of collection details  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_collection_name_history(space_name, coll_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param datetime real_start: start time from when values were valid
        :param datetime real_end: end time until when values were valid
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_collection_name_history_with_http_info(space_name, coll_name, **kwargs)  # noqa: E501

    def app_api_collection_name_history_with_http_info(self, space_name, coll_name, **kwargs):  # noqa: E501
        """Retrieve historical values of collection details  # noqa: E501

        Retrieve historical values of collection details  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_collection_name_history_with_http_info(space_name, coll_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param datetime real_start: start time from when values were valid
        :param datetime real_end: end time until when values were valid
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'coll_name', 'real_start', 'real_end']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_collection_name_history" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_collection_name_history`")  # noqa: E501
        # verify the required parameter 'coll_name' is set
        if ('coll_name' not in local_var_params or
                local_var_params['coll_name'] is None):
            raise ApiValueError("Missing the required parameter `coll_name` when calling `app_api_collection_name_history`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_collection_name_history`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'coll_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['coll_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_name` when calling `app_api_collection_name_history`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501
        if 'coll_name' in local_var_params:
            path_params['coll_name'] = local_var_params['coll_name']  # noqa: E501

        query_params = []
        if 'real_start' in local_var_params:
            query_params.append(('realStart', local_var_params['real_start']))  # noqa: E501
        if 'real_end' in local_var_params:
            query_params.append(('realEnd', local_var_params['real_end']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{space_name}/{coll_name}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_collection_post(self, space_name, collection, **kwargs):  # noqa: E501
        """Create a new collection  # noqa: E501

        Create a new collection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_collection_post(space_name, collection, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param Collection collection: Definition of collection (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Collection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_collection_post_with_http_info(space_name, collection, **kwargs)  # noqa: E501

    def app_api_collection_post_with_http_info(self, space_name, collection, **kwargs):  # noqa: E501
        """Create a new collection  # noqa: E501

        Create a new collection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_collection_post_with_http_info(space_name, collection, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param Collection collection: Definition of collection (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Collection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'collection']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_collection_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_collection_post`")  # noqa: E501
        # verify the required parameter 'collection' is set
        if ('collection' not in local_var_params or
                local_var_params['collection'] is None):
            raise ApiValueError("Missing the required parameter `collection` when calling `app_api_collection_post`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_collection_post`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'collection' in local_var_params:
            body_params = local_var_params['collection']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{space_name}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Collection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_collection_put(self, space_name, coll_name, collection, **kwargs):  # noqa: E501
        """Update an existing collection  # noqa: E501

        Update an existing collection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_collection_put(space_name, coll_name, collection, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param Collection collection: ok (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Collection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_collection_put_with_http_info(space_name, coll_name, collection, **kwargs)  # noqa: E501

    def app_api_collection_put_with_http_info(self, space_name, coll_name, collection, **kwargs):  # noqa: E501
        """Update an existing collection  # noqa: E501

        Update an existing collection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_collection_put_with_http_info(space_name, coll_name, collection, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param Collection collection: ok (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Collection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'coll_name', 'collection']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_collection_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_collection_put`")  # noqa: E501
        # verify the required parameter 'coll_name' is set
        if ('coll_name' not in local_var_params or
                local_var_params['coll_name'] is None):
            raise ApiValueError("Missing the required parameter `coll_name` when calling `app_api_collection_put`")  # noqa: E501
        # verify the required parameter 'collection' is set
        if ('collection' not in local_var_params or
                local_var_params['collection'] is None):
            raise ApiValueError("Missing the required parameter `collection` when calling `app_api_collection_put`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_collection_put`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'coll_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['coll_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_name` when calling `app_api_collection_put`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501
        if 'coll_name' in local_var_params:
            path_params['coll_name'] = local_var_params['coll_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'collection' in local_var_params:
            body_params = local_var_params['collection']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/collection/{space_name}/{coll_name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Collection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
