# coding: utf-8

"""
    ChronosDB swagger

    ChronosDB time series database API  # noqa: E501

    The version of the OpenAPI document: 0.1
    Contact: apiteam@chronosdb.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openapi_client.api_client import ApiClient
from openapi_client.exceptions import (
    ApiTypeError,
    ApiValueError
)


class AnnotationsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def app_api_annotation_add_target(self, space_name, coll_name, symbol, **kwargs):  # noqa: E501
        """Add observation target  # noqa: E501

        Add observation target  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_add_target(space_name, coll_name, symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str symbol: annotation symbol (required)
        :param str tsid: time series id
        :param int index: time series index
        :param Frequency freq: frequency
        :param str vid: vintage id
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Annotation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_annotation_add_target_with_http_info(space_name, coll_name, symbol, **kwargs)  # noqa: E501

    def app_api_annotation_add_target_with_http_info(self, space_name, coll_name, symbol, **kwargs):  # noqa: E501
        """Add observation target  # noqa: E501

        Add observation target  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_add_target_with_http_info(space_name, coll_name, symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str symbol: annotation symbol (required)
        :param str tsid: time series id
        :param int index: time series index
        :param Frequency freq: frequency
        :param str vid: vintage id
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Annotation, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'coll_name', 'symbol', 'tsid', 'index', 'freq', 'vid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_annotation_add_target" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_annotation_add_target`")  # noqa: E501
        # verify the required parameter 'coll_name' is set
        if ('coll_name' not in local_var_params or
                local_var_params['coll_name'] is None):
            raise ApiValueError("Missing the required parameter `coll_name` when calling `app_api_annotation_add_target`")  # noqa: E501
        # verify the required parameter 'symbol' is set
        if ('symbol' not in local_var_params or
                local_var_params['symbol'] is None):
            raise ApiValueError("Missing the required parameter `symbol` when calling `app_api_annotation_add_target`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_annotation_add_target`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'coll_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['coll_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_name` when calling `app_api_annotation_add_target`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'symbol' in local_var_params and not re.search(r'^[0-9a-zA-Z]{1,10}$', local_var_params['symbol']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `symbol` when calling `app_api_annotation_add_target`, must conform to the pattern `/^[0-9a-zA-Z]{1,10}$/`")  # noqa: E501
        if 'tsid' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['tsid']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `tsid` when calling `app_api_annotation_add_target`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        if 'vid' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['vid']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `vid` when calling `app_api_annotation_add_target`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501
        if 'coll_name' in local_var_params:
            path_params['coll_name'] = local_var_params['coll_name']  # noqa: E501
        if 'symbol' in local_var_params:
            path_params['symbol'] = local_var_params['symbol']  # noqa: E501

        query_params = []
        if 'tsid' in local_var_params:
            query_params.append(('tsid', local_var_params['tsid']))  # noqa: E501
        if 'index' in local_var_params:
            query_params.append(('index', local_var_params['index']))  # noqa: E501
        if 'freq' in local_var_params:
            query_params.append(('freq', local_var_params['freq']))  # noqa: E501
        if 'vid' in local_var_params:
            query_params.append(('vid', local_var_params['vid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/annotation/{space_name}/{coll_name}/{symbol}/targets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Annotation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_annotation_create(self, space_name, coll_name, annotation, **kwargs):  # noqa: E501
        """Create an annotation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_create(space_name, coll_name, annotation, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param Annotation annotation: Annotation (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Annotation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_annotation_create_with_http_info(space_name, coll_name, annotation, **kwargs)  # noqa: E501

    def app_api_annotation_create_with_http_info(self, space_name, coll_name, annotation, **kwargs):  # noqa: E501
        """Create an annotation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_create_with_http_info(space_name, coll_name, annotation, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param Annotation annotation: Annotation (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Annotation, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'coll_name', 'annotation']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_annotation_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_annotation_create`")  # noqa: E501
        # verify the required parameter 'coll_name' is set
        if ('coll_name' not in local_var_params or
                local_var_params['coll_name'] is None):
            raise ApiValueError("Missing the required parameter `coll_name` when calling `app_api_annotation_create`")  # noqa: E501
        # verify the required parameter 'annotation' is set
        if ('annotation' not in local_var_params or
                local_var_params['annotation'] is None):
            raise ApiValueError("Missing the required parameter `annotation` when calling `app_api_annotation_create`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_annotation_create`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'coll_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['coll_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_name` when calling `app_api_annotation_create`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501
        if 'coll_name' in local_var_params:
            path_params['coll_name'] = local_var_params['coll_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'annotation' in local_var_params:
            body_params = local_var_params['annotation']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/annotation/{space_name}/{coll_name}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Annotation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_annotation_delete(self, space_name, coll_name, symbol, **kwargs):  # noqa: E501
        """Delete annotation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_delete(space_name, coll_name, symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str symbol: annotation symbol (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_annotation_delete_with_http_info(space_name, coll_name, symbol, **kwargs)  # noqa: E501

    def app_api_annotation_delete_with_http_info(self, space_name, coll_name, symbol, **kwargs):  # noqa: E501
        """Delete annotation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_delete_with_http_info(space_name, coll_name, symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str symbol: annotation symbol (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'coll_name', 'symbol']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_annotation_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_annotation_delete`")  # noqa: E501
        # verify the required parameter 'coll_name' is set
        if ('coll_name' not in local_var_params or
                local_var_params['coll_name'] is None):
            raise ApiValueError("Missing the required parameter `coll_name` when calling `app_api_annotation_delete`")  # noqa: E501
        # verify the required parameter 'symbol' is set
        if ('symbol' not in local_var_params or
                local_var_params['symbol'] is None):
            raise ApiValueError("Missing the required parameter `symbol` when calling `app_api_annotation_delete`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_annotation_delete`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'coll_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['coll_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_name` when calling `app_api_annotation_delete`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'symbol' in local_var_params and not re.search(r'^[0-9a-zA-Z]{1,10}$', local_var_params['symbol']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `symbol` when calling `app_api_annotation_delete`, must conform to the pattern `/^[0-9a-zA-Z]{1,10}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501
        if 'coll_name' in local_var_params:
            path_params['coll_name'] = local_var_params['coll_name']  # noqa: E501
        if 'symbol' in local_var_params:
            path_params['symbol'] = local_var_params['symbol']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/annotation/{space_name}/{coll_name}/{symbol}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_annotation_get(self, space_name, coll_name, symbol, **kwargs):  # noqa: E501
        """Get an annotation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_get(space_name, coll_name, symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str symbol: annotation symbol (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Annotation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_annotation_get_with_http_info(space_name, coll_name, symbol, **kwargs)  # noqa: E501

    def app_api_annotation_get_with_http_info(self, space_name, coll_name, symbol, **kwargs):  # noqa: E501
        """Get an annotation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_get_with_http_info(space_name, coll_name, symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str symbol: annotation symbol (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Annotation, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'coll_name', 'symbol']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_annotation_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_annotation_get`")  # noqa: E501
        # verify the required parameter 'coll_name' is set
        if ('coll_name' not in local_var_params or
                local_var_params['coll_name'] is None):
            raise ApiValueError("Missing the required parameter `coll_name` when calling `app_api_annotation_get`")  # noqa: E501
        # verify the required parameter 'symbol' is set
        if ('symbol' not in local_var_params or
                local_var_params['symbol'] is None):
            raise ApiValueError("Missing the required parameter `symbol` when calling `app_api_annotation_get`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_annotation_get`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'coll_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['coll_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_name` when calling `app_api_annotation_get`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'symbol' in local_var_params and not re.search(r'^[0-9a-zA-Z]{1,10}$', local_var_params['symbol']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `symbol` when calling `app_api_annotation_get`, must conform to the pattern `/^[0-9a-zA-Z]{1,10}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501
        if 'coll_name' in local_var_params:
            path_params['coll_name'] = local_var_params['coll_name']  # noqa: E501
        if 'symbol' in local_var_params:
            path_params['symbol'] = local_var_params['symbol']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/annotation/{space_name}/{coll_name}/{symbol}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Annotation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_annotation_get_list(self, space_name, coll_name, **kwargs):  # noqa: E501
        """List annotations  # noqa: E501

        List annotations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_get_list(space_name, coll_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Annotation]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_annotation_get_list_with_http_info(space_name, coll_name, **kwargs)  # noqa: E501

    def app_api_annotation_get_list_with_http_info(self, space_name, coll_name, **kwargs):  # noqa: E501
        """List annotations  # noqa: E501

        List annotations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_get_list_with_http_info(space_name, coll_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Annotation], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'coll_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_annotation_get_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_annotation_get_list`")  # noqa: E501
        # verify the required parameter 'coll_name' is set
        if ('coll_name' not in local_var_params or
                local_var_params['coll_name'] is None):
            raise ApiValueError("Missing the required parameter `coll_name` when calling `app_api_annotation_get_list`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_annotation_get_list`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'coll_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['coll_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_name` when calling `app_api_annotation_get_list`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501
        if 'coll_name' in local_var_params:
            path_params['coll_name'] = local_var_params['coll_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/annotation/{space_name}/{coll_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Annotation]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_annotation_remove_target(self, space_name, coll_name, symbol, **kwargs):  # noqa: E501
        """delete observation targets  # noqa: E501

        delete observation targets  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_remove_target(space_name, coll_name, symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str symbol: annotation symbol (required)
        :param str tsid: time series id
        :param int index: time series index
        :param Frequency freq: frequency
        :param str vid: vintage id
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Annotation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_annotation_remove_target_with_http_info(space_name, coll_name, symbol, **kwargs)  # noqa: E501

    def app_api_annotation_remove_target_with_http_info(self, space_name, coll_name, symbol, **kwargs):  # noqa: E501
        """delete observation targets  # noqa: E501

        delete observation targets  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_remove_target_with_http_info(space_name, coll_name, symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str symbol: annotation symbol (required)
        :param str tsid: time series id
        :param int index: time series index
        :param Frequency freq: frequency
        :param str vid: vintage id
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Annotation, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'coll_name', 'symbol', 'tsid', 'index', 'freq', 'vid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_annotation_remove_target" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_annotation_remove_target`")  # noqa: E501
        # verify the required parameter 'coll_name' is set
        if ('coll_name' not in local_var_params or
                local_var_params['coll_name'] is None):
            raise ApiValueError("Missing the required parameter `coll_name` when calling `app_api_annotation_remove_target`")  # noqa: E501
        # verify the required parameter 'symbol' is set
        if ('symbol' not in local_var_params or
                local_var_params['symbol'] is None):
            raise ApiValueError("Missing the required parameter `symbol` when calling `app_api_annotation_remove_target`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_annotation_remove_target`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'coll_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['coll_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_name` when calling `app_api_annotation_remove_target`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'symbol' in local_var_params and not re.search(r'^[0-9a-zA-Z]{1,10}$', local_var_params['symbol']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `symbol` when calling `app_api_annotation_remove_target`, must conform to the pattern `/^[0-9a-zA-Z]{1,10}$/`")  # noqa: E501
        if 'tsid' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['tsid']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `tsid` when calling `app_api_annotation_remove_target`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        if 'vid' in local_var_params and not re.search(r'[0-9a-fA-F]{24}', local_var_params['vid']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `vid` when calling `app_api_annotation_remove_target`, must conform to the pattern `/[0-9a-fA-F]{24}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501
        if 'coll_name' in local_var_params:
            path_params['coll_name'] = local_var_params['coll_name']  # noqa: E501
        if 'symbol' in local_var_params:
            path_params['symbol'] = local_var_params['symbol']  # noqa: E501

        query_params = []
        if 'tsid' in local_var_params:
            query_params.append(('tsid', local_var_params['tsid']))  # noqa: E501
        if 'index' in local_var_params:
            query_params.append(('index', local_var_params['index']))  # noqa: E501
        if 'freq' in local_var_params:
            query_params.append(('freq', local_var_params['freq']))  # noqa: E501
        if 'vid' in local_var_params:
            query_params.append(('vid', local_var_params['vid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/annotation/{space_name}/{coll_name}/{symbol}/targets', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Annotation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def app_api_annotation_update(self, space_name, coll_name, symbol, annotation_update, **kwargs):  # noqa: E501
        """Update an annotation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_update(space_name, coll_name, symbol, annotation_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str symbol: annotation symbol (required)
        :param AnnotationUpdate annotation_update: Annotation (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.app_api_annotation_update_with_http_info(space_name, coll_name, symbol, annotation_update, **kwargs)  # noqa: E501

    def app_api_annotation_update_with_http_info(self, space_name, coll_name, symbol, annotation_update, **kwargs):  # noqa: E501
        """Update an annotation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.app_api_annotation_update_with_http_info(space_name, coll_name, symbol, annotation_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str space_name: space name (required)
        :param str coll_name: collection name (required)
        :param str symbol: annotation symbol (required)
        :param AnnotationUpdate annotation_update: Annotation (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['space_name', 'coll_name', 'symbol', 'annotation_update']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method app_api_annotation_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_name' is set
        if ('space_name' not in local_var_params or
                local_var_params['space_name'] is None):
            raise ApiValueError("Missing the required parameter `space_name` when calling `app_api_annotation_update`")  # noqa: E501
        # verify the required parameter 'coll_name' is set
        if ('coll_name' not in local_var_params or
                local_var_params['coll_name'] is None):
            raise ApiValueError("Missing the required parameter `coll_name` when calling `app_api_annotation_update`")  # noqa: E501
        # verify the required parameter 'symbol' is set
        if ('symbol' not in local_var_params or
                local_var_params['symbol'] is None):
            raise ApiValueError("Missing the required parameter `symbol` when calling `app_api_annotation_update`")  # noqa: E501
        # verify the required parameter 'annotation_update' is set
        if ('annotation_update' not in local_var_params or
                local_var_params['annotation_update'] is None):
            raise ApiValueError("Missing the required parameter `annotation_update` when calling `app_api_annotation_update`")  # noqa: E501

        if 'space_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['space_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `space_name` when calling `app_api_annotation_update`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'coll_name' in local_var_params and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]{4,59}$', local_var_params['coll_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `coll_name` when calling `app_api_annotation_update`, must conform to the pattern `/^[a-zA-Z][_a-zA-Z0-9]{4,59}$/`")  # noqa: E501
        if 'symbol' in local_var_params and not re.search(r'^[0-9a-zA-Z]{1,10}$', local_var_params['symbol']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `symbol` when calling `app_api_annotation_update`, must conform to the pattern `/^[0-9a-zA-Z]{1,10}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'space_name' in local_var_params:
            path_params['space_name'] = local_var_params['space_name']  # noqa: E501
        if 'coll_name' in local_var_params:
            path_params['coll_name'] = local_var_params['coll_name']  # noqa: E501
        if 'symbol' in local_var_params:
            path_params['symbol'] = local_var_params['symbol']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'annotation_update' in local_var_params:
            body_params = local_var_params['annotation_update']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'basic', 'jwt']  # noqa: E501

        return self.api_client.call_api(
            '/annotation/{space_name}/{coll_name}/{symbol}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
