# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['AuthorizerArgs', 'Authorizer']

@pulumi.input_type
class AuthorizerArgs:
    def __init__(__self__, *,
                 authorizer_function_arn: pulumi.Input[str],
                 authorizer_name: Optional[pulumi.Input[str]] = None,
                 enable_caching_for_http: Optional[pulumi.Input[bool]] = None,
                 signing_disabled: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input['AuthorizerStatus']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizerTagArgs']]]] = None,
                 token_key_name: Optional[pulumi.Input[str]] = None,
                 token_signing_public_keys: Optional[Any] = None):
        """
        The set of arguments for constructing a Authorizer resource.
        """
        pulumi.set(__self__, "authorizer_function_arn", authorizer_function_arn)
        if authorizer_name is not None:
            pulumi.set(__self__, "authorizer_name", authorizer_name)
        if enable_caching_for_http is not None:
            pulumi.set(__self__, "enable_caching_for_http", enable_caching_for_http)
        if signing_disabled is not None:
            pulumi.set(__self__, "signing_disabled", signing_disabled)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if token_key_name is not None:
            pulumi.set(__self__, "token_key_name", token_key_name)
        if token_signing_public_keys is not None:
            pulumi.set(__self__, "token_signing_public_keys", token_signing_public_keys)

    @property
    @pulumi.getter(name="authorizerFunctionArn")
    def authorizer_function_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "authorizer_function_arn")

    @authorizer_function_arn.setter
    def authorizer_function_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "authorizer_function_arn", value)

    @property
    @pulumi.getter(name="authorizerName")
    def authorizer_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "authorizer_name")

    @authorizer_name.setter
    def authorizer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorizer_name", value)

    @property
    @pulumi.getter(name="enableCachingForHttp")
    def enable_caching_for_http(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enable_caching_for_http")

    @enable_caching_for_http.setter
    def enable_caching_for_http(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_caching_for_http", value)

    @property
    @pulumi.getter(name="signingDisabled")
    def signing_disabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "signing_disabled")

    @signing_disabled.setter
    def signing_disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "signing_disabled", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['AuthorizerStatus']]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['AuthorizerStatus']]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizerTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizerTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tokenKeyName")
    def token_key_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "token_key_name")

    @token_key_name.setter
    def token_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_key_name", value)

    @property
    @pulumi.getter(name="tokenSigningPublicKeys")
    def token_signing_public_keys(self) -> Optional[Any]:
        return pulumi.get(self, "token_signing_public_keys")

    @token_signing_public_keys.setter
    def token_signing_public_keys(self, value: Optional[Any]):
        pulumi.set(self, "token_signing_public_keys", value)


class Authorizer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorizer_function_arn: Optional[pulumi.Input[str]] = None,
                 authorizer_name: Optional[pulumi.Input[str]] = None,
                 enable_caching_for_http: Optional[pulumi.Input[bool]] = None,
                 signing_disabled: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input['AuthorizerStatus']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AuthorizerTagArgs']]]]] = None,
                 token_key_name: Optional[pulumi.Input[str]] = None,
                 token_signing_public_keys: Optional[Any] = None,
                 __props__=None):
        """
        Creates an authorizer.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthorizerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an authorizer.

        :param str resource_name: The name of the resource.
        :param AuthorizerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthorizerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorizer_function_arn: Optional[pulumi.Input[str]] = None,
                 authorizer_name: Optional[pulumi.Input[str]] = None,
                 enable_caching_for_http: Optional[pulumi.Input[bool]] = None,
                 signing_disabled: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input['AuthorizerStatus']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AuthorizerTagArgs']]]]] = None,
                 token_key_name: Optional[pulumi.Input[str]] = None,
                 token_signing_public_keys: Optional[Any] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthorizerArgs.__new__(AuthorizerArgs)

            if authorizer_function_arn is None and not opts.urn:
                raise TypeError("Missing required property 'authorizer_function_arn'")
            __props__.__dict__["authorizer_function_arn"] = authorizer_function_arn
            __props__.__dict__["authorizer_name"] = authorizer_name
            __props__.__dict__["enable_caching_for_http"] = enable_caching_for_http
            __props__.__dict__["signing_disabled"] = signing_disabled
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["token_key_name"] = token_key_name
            __props__.__dict__["token_signing_public_keys"] = token_signing_public_keys
            __props__.__dict__["arn"] = None
        super(Authorizer, __self__).__init__(
            'aws-native:iot:Authorizer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Authorizer':
        """
        Get an existing Authorizer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AuthorizerArgs.__new__(AuthorizerArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["authorizer_function_arn"] = None
        __props__.__dict__["authorizer_name"] = None
        __props__.__dict__["enable_caching_for_http"] = None
        __props__.__dict__["signing_disabled"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["token_key_name"] = None
        __props__.__dict__["token_signing_public_keys"] = None
        return Authorizer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="authorizerFunctionArn")
    def authorizer_function_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "authorizer_function_arn")

    @property
    @pulumi.getter(name="authorizerName")
    def authorizer_name(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "authorizer_name")

    @property
    @pulumi.getter(name="enableCachingForHttp")
    def enable_caching_for_http(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "enable_caching_for_http")

    @property
    @pulumi.getter(name="signingDisabled")
    def signing_disabled(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "signing_disabled")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional['AuthorizerStatus']]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.AuthorizerTag']]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tokenKeyName")
    def token_key_name(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "token_key_name")

    @property
    @pulumi.getter(name="tokenSigningPublicKeys")
    def token_signing_public_keys(self) -> pulumi.Output[Optional[Any]]:
        return pulumi.get(self, "token_signing_public_keys")

