# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetGlobalReplicationGroupResult',
    'AwaitableGetGlobalReplicationGroupResult',
    'get_global_replication_group',
    'get_global_replication_group_output',
]

@pulumi.output_type
class GetGlobalReplicationGroupResult:
    def __init__(__self__, cache_parameter_group_name=None, global_replication_group_id=None, members=None, status=None):
        if cache_parameter_group_name and not isinstance(cache_parameter_group_name, str):
            raise TypeError("Expected argument 'cache_parameter_group_name' to be a str")
        pulumi.set(__self__, "cache_parameter_group_name", cache_parameter_group_name)
        if global_replication_group_id and not isinstance(global_replication_group_id, str):
            raise TypeError("Expected argument 'global_replication_group_id' to be a str")
        pulumi.set(__self__, "global_replication_group_id", global_replication_group_id)
        if members and not isinstance(members, list):
            raise TypeError("Expected argument 'members' to be a list")
        pulumi.set(__self__, "members", members)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="cacheParameterGroupName")
    def cache_parameter_group_name(self) -> Optional[str]:
        """
        Cache parameter group name to use for the new engine version. This parameter cannot be modified independently.
        """
        return pulumi.get(self, "cache_parameter_group_name")

    @property
    @pulumi.getter(name="globalReplicationGroupId")
    def global_replication_group_id(self) -> Optional[str]:
        """
        The name of the Global Datastore, it is generated by ElastiCache adding a prefix to GlobalReplicationGroupIdSuffix.
        """
        return pulumi.get(self, "global_replication_group_id")

    @property
    @pulumi.getter
    def members(self) -> Optional[Sequence['outputs.GlobalReplicationGroupMember']]:
        """
        The replication groups that comprise the Global Datastore.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the Global Datastore
        """
        return pulumi.get(self, "status")


class AwaitableGetGlobalReplicationGroupResult(GetGlobalReplicationGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGlobalReplicationGroupResult(
            cache_parameter_group_name=self.cache_parameter_group_name,
            global_replication_group_id=self.global_replication_group_id,
            members=self.members,
            status=self.status)


def get_global_replication_group(global_replication_group_id: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGlobalReplicationGroupResult:
    """
    The AWS::ElastiCache::GlobalReplicationGroup resource creates an Amazon ElastiCache Global Replication Group.


    :param str global_replication_group_id: The name of the Global Datastore, it is generated by ElastiCache adding a prefix to GlobalReplicationGroupIdSuffix.
    """
    __args__ = dict()
    __args__['globalReplicationGroupId'] = global_replication_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:elasticache:getGlobalReplicationGroup', __args__, opts=opts, typ=GetGlobalReplicationGroupResult).value

    return AwaitableGetGlobalReplicationGroupResult(
        cache_parameter_group_name=__ret__.cache_parameter_group_name,
        global_replication_group_id=__ret__.global_replication_group_id,
        members=__ret__.members,
        status=__ret__.status)


@_utilities.lift_output_func(get_global_replication_group)
def get_global_replication_group_output(global_replication_group_id: Optional[pulumi.Input[str]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGlobalReplicationGroupResult]:
    """
    The AWS::ElastiCache::GlobalReplicationGroup resource creates an Amazon ElastiCache Global Replication Group.


    :param str global_replication_group_id: The name of the Global Datastore, it is generated by ElastiCache adding a prefix to GlobalReplicationGroupIdSuffix.
    """
    ...
