# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'AssumeRole',
    'DefaultTags',
    'Endpoints',
    'IgnoreTags',
]

@pulumi.output_type
class AssumeRole(dict):
    """
    The configuration for a Provider to assume a role.
    """
    def __init__(__self__, *,
                 duration_seconds: Optional[int] = None,
                 external_id: Optional[str] = None,
                 policy: Optional[str] = None,
                 policy_arns: Optional[Sequence[str]] = None,
                 role_arn: Optional[str] = None,
                 session_name: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 transitive_tag_keys: Optional[Sequence[str]] = None):
        """
        The configuration for a Provider to assume a role.
        :param int duration_seconds: Number of seconds to restrict the assume role session duration.
        :param str external_id: External identifier to use when assuming the role.
        :param str policy: IAM Policy JSON describing further restricting permissions for the IAM Role being assumed.
        :param Sequence[str] policy_arns: Set of Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the role.
        :param str role_arn: Amazon Resource Name (ARN) of the IAM Role to assume.
        :param str session_name: Session name to use when assuming the role.
        :param Mapping[str, str] tags: Map of assume role session tags.
        :param Sequence[str] transitive_tag_keys: A list of keys for session tags that you want to set as transitive. If you set a tag key as transitive, the corresponding key and value passes to subsequent sessions in a role chain.
        """
        if duration_seconds is not None:
            pulumi.set(__self__, "duration_seconds", duration_seconds)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if policy_arns is not None:
            pulumi.set(__self__, "policy_arns", policy_arns)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if session_name is not None:
            pulumi.set(__self__, "session_name", session_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transitive_tag_keys is not None:
            pulumi.set(__self__, "transitive_tag_keys", transitive_tag_keys)

    @property
    @pulumi.getter(name="durationSeconds")
    def duration_seconds(self) -> Optional[int]:
        """
        Number of seconds to restrict the assume role session duration.
        """
        return pulumi.get(self, "duration_seconds")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[str]:
        """
        External identifier to use when assuming the role.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter
    def policy(self) -> Optional[str]:
        """
        IAM Policy JSON describing further restricting permissions for the IAM Role being assumed.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> Optional[Sequence[str]]:
        """
        Set of Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the role.
        """
        return pulumi.get(self, "policy_arns")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        Amazon Resource Name (ARN) of the IAM Role to assume.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="sessionName")
    def session_name(self) -> Optional[str]:
        """
        Session name to use when assuming the role.
        """
        return pulumi.get(self, "session_name")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Map of assume role session tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="transitiveTagKeys")
    def transitive_tag_keys(self) -> Optional[Sequence[str]]:
        """
        A list of keys for session tags that you want to set as transitive. If you set a tag key as transitive, the corresponding key and value passes to subsequent sessions in a role chain.
        """
        return pulumi.get(self, "transitive_tag_keys")


@pulumi.output_type
class DefaultTags(dict):
    """
    The configuration with resource tag settings to apply across all resources handled by this provider. This is designed to replace redundant per-resource `tags` configurations. Provider tags can be overridden with new values, but not excluded from specific resources. To override provider tag values, use the `tags` argument within a resource to configure new tag values for matching keys.
    """
    def __init__(__self__, *,
                 tags: Optional[Mapping[str, str]] = None):
        """
        The configuration with resource tag settings to apply across all resources handled by this provider. This is designed to replace redundant per-resource `tags` configurations. Provider tags can be overridden with new values, but not excluded from specific resources. To override provider tag values, use the `tags` argument within a resource to configure new tag values for matching keys.
        :param Mapping[str, str] tags: A group of tags to set across all resources.
        """
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        A group of tags to set across all resources.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class Endpoints(dict):
    """
    The configuration for for customizing service endpoints.
    """
    def __init__(__self__, *,
                 accessanalyzer: Optional[str] = None,
                 acm: Optional[str] = None,
                 acmpca: Optional[str] = None,
                 amplify: Optional[str] = None,
                 appconfig: Optional[str] = None,
                 applicationautoscaling: Optional[str] = None,
                 applicationinsights: Optional[str] = None,
                 appmesh: Optional[str] = None,
                 apprunner: Optional[str] = None,
                 appstream: Optional[str] = None,
                 appsync: Optional[str] = None,
                 athena: Optional[str] = None,
                 auditmanager: Optional[str] = None,
                 autoscaling: Optional[str] = None,
                 backup: Optional[str] = None,
                 batch: Optional[str] = None,
                 budgets: Optional[str] = None,
                 chime: Optional[str] = None,
                 cloud9: Optional[str] = None,
                 cloudformation: Optional[str] = None,
                 cloudfront: Optional[str] = None,
                 cloudhsm: Optional[str] = None,
                 cloudsearch: Optional[str] = None,
                 cloudtrail: Optional[str] = None,
                 cloudwatch: Optional[str] = None,
                 cloudwatchevents: Optional[str] = None,
                 cloudwatchlogs: Optional[str] = None,
                 codeartifact: Optional[str] = None,
                 codebuild: Optional[str] = None,
                 codecommit: Optional[str] = None,
                 codedeploy: Optional[str] = None,
                 codepipeline: Optional[str] = None,
                 codestarconnections: Optional[str] = None,
                 cognitoidentity: Optional[str] = None,
                 configservice: Optional[str] = None,
                 connect: Optional[str] = None,
                 cur: Optional[str] = None,
                 dataexchange: Optional[str] = None,
                 datapipeline: Optional[str] = None,
                 datasync: Optional[str] = None,
                 dax: Optional[str] = None,
                 detective: Optional[str] = None,
                 devicefarm: Optional[str] = None,
                 directconnect: Optional[str] = None,
                 dlm: Optional[str] = None,
                 dms: Optional[str] = None,
                 docdb: Optional[str] = None,
                 ds: Optional[str] = None,
                 dynamodb: Optional[str] = None,
                 ec2: Optional[str] = None,
                 ecr: Optional[str] = None,
                 ecrpublic: Optional[str] = None,
                 ecs: Optional[str] = None,
                 efs: Optional[str] = None,
                 eks: Optional[str] = None,
                 elasticache: Optional[str] = None,
                 elasticbeanstalk: Optional[str] = None,
                 elastictranscoder: Optional[str] = None,
                 elb: Optional[str] = None,
                 elbv2: Optional[str] = None,
                 emr: Optional[str] = None,
                 emrcontainers: Optional[str] = None,
                 es: Optional[str] = None,
                 firehose: Optional[str] = None,
                 fms: Optional[str] = None,
                 forecast: Optional[str] = None,
                 fsx: Optional[str] = None,
                 gamelift: Optional[str] = None,
                 glacier: Optional[str] = None,
                 globalaccelerator: Optional[str] = None,
                 glue: Optional[str] = None,
                 greengrass: Optional[str] = None,
                 guardduty: Optional[str] = None,
                 iam: Optional[str] = None,
                 identitystore: Optional[str] = None,
                 imagebuilder: Optional[str] = None,
                 inspector: Optional[str] = None,
                 iot: Optional[str] = None,
                 iotanalytics: Optional[str] = None,
                 iotevents: Optional[str] = None,
                 kafka: Optional[str] = None,
                 kinesis: Optional[str] = None,
                 kinesisanalytics: Optional[str] = None,
                 kinesisanalyticsv2: Optional[str] = None,
                 kinesisvideo: Optional[str] = None,
                 kms: Optional[str] = None,
                 lakeformation: Optional[str] = None,
                 lambda_: Optional[str] = None,
                 lexmodels: Optional[str] = None,
                 licensemanager: Optional[str] = None,
                 lightsail: Optional[str] = None,
                 location: Optional[str] = None,
                 macie: Optional[str] = None,
                 macie2: Optional[str] = None,
                 managedblockchain: Optional[str] = None,
                 marketplacecatalog: Optional[str] = None,
                 mediaconnect: Optional[str] = None,
                 mediaconvert: Optional[str] = None,
                 medialive: Optional[str] = None,
                 mediapackage: Optional[str] = None,
                 mediastore: Optional[str] = None,
                 mediastoredata: Optional[str] = None,
                 memorydb: Optional[str] = None,
                 mq: Optional[str] = None,
                 mwaa: Optional[str] = None,
                 neptune: Optional[str] = None,
                 networkfirewall: Optional[str] = None,
                 networkmanager: Optional[str] = None,
                 opsworks: Optional[str] = None,
                 organizations: Optional[str] = None,
                 outposts: Optional[str] = None,
                 personalize: Optional[str] = None,
                 pinpoint: Optional[str] = None,
                 pricing: Optional[str] = None,
                 qldb: Optional[str] = None,
                 quicksight: Optional[str] = None,
                 ram: Optional[str] = None,
                 rds: Optional[str] = None,
                 redshift: Optional[str] = None,
                 resourcegroups: Optional[str] = None,
                 resourcegroupstaggingapi: Optional[str] = None,
                 route53: Optional[str] = None,
                 route53domains: Optional[str] = None,
                 route53recoverycontrolconfig: Optional[str] = None,
                 route53recoveryreadiness: Optional[str] = None,
                 route53resolver: Optional[str] = None,
                 s3: Optional[str] = None,
                 s3control: Optional[str] = None,
                 s3outposts: Optional[str] = None,
                 sagemaker: Optional[str] = None,
                 schemas: Optional[str] = None,
                 sdb: Optional[str] = None,
                 secretsmanager: Optional[str] = None,
                 securityhub: Optional[str] = None,
                 serverlessrepo: Optional[str] = None,
                 servicecatalog: Optional[str] = None,
                 servicediscovery: Optional[str] = None,
                 servicequotas: Optional[str] = None,
                 ses: Optional[str] = None,
                 shield: Optional[str] = None,
                 signer: Optional[str] = None,
                 sns: Optional[str] = None,
                 sqs: Optional[str] = None,
                 ssm: Optional[str] = None,
                 ssoadmin: Optional[str] = None,
                 stepfunctions: Optional[str] = None,
                 storagegateway: Optional[str] = None,
                 sts: Optional[str] = None,
                 swf: Optional[str] = None,
                 synthetics: Optional[str] = None,
                 timestreamwrite: Optional[str] = None,
                 transfer: Optional[str] = None,
                 waf: Optional[str] = None,
                 wafregional: Optional[str] = None,
                 wafv2: Optional[str] = None,
                 worklink: Optional[str] = None,
                 workmail: Optional[str] = None,
                 workspaces: Optional[str] = None,
                 xray: Optional[str] = None):
        """
        The configuration for for customizing service endpoints.
        :param str accessanalyzer: Override the default endpoint for AWS Access Analyzer
        :param str acm: Override the default endpoint for AWS Certificate Manager
        :param str acmpca: Override the default endpoint for AWS Certificate Manager Private Certificate Authority
        :param str amplify: Override the default endpoint for AWS Amplify Console
        :param str appconfig: Override the default endpoint for AWS AppConfig
        :param str applicationautoscaling: Override the default endpoint for AWS Application Auto Scaling
        :param str applicationinsights: Override the default endpoint for AWS CloudWatch Application Insights
        :param str appmesh: Override the default endpoint for AWS App Mesh
        :param str apprunner: Override the default endpoint for AWS App Runner
        :param str appstream: Override the default endpoint for AWS AppStream 2.0
        :param str appsync: Override the default endpoint for AWS AppSync
        :param str athena: Override the default endpoint for AWS Athena
        :param str auditmanager: Override the default endpoint for AWS Audit Manager
        :param str autoscaling: Override the default endpoint for AWS Auto Scaling
        :param str backup: Override the default endpoint for AWS Backup
        :param str batch: Override the default endpoint for AWS Batch
        :param str budgets: Override the default endpoint for AWS Budgets
        :param str chime: Override the default endpoint for Amazon Chime
        :param str cloud9: Override the default endpoint for AWS Cloud9
        :param str cloudformation: Override the default endpoint for AWS CloudFormation
        :param str cloudfront: Override the default endpoint for AWS CloudFront
        :param str cloudhsm: Override the default endpoint for AWS CloudHSM
        :param str cloudsearch: Override the default endpoint for AWS CloudSearch
        :param str cloudtrail: Override the default endpoint for AWS CloudTrail
        :param str cloudwatch: Override the default endpoint for AWS CloudWatch
        :param str cloudwatchevents: Override the default endpoint for AWS CloudWatch Events
        :param str cloudwatchlogs: Override the default endpoint for AWS CloudWatch Logs
        :param str codeartifact: Override the default endpoint for AWS CodeArtifact
        :param str codebuild: Override the default endpoint for AWS CodeBuild
        :param str codecommit: Override the default endpoint for AWS CodeCommit
        :param str codedeploy: Override the default endpoint for AWS CodeDeploy
        :param str codepipeline: Override the default endpoint for AWS CodePipeline
        :param str codestarconnections: Override the default endpoint for AWS CodeStart Connections
        :param str cognitoidentity: Override the default endpoint for Amazon Cognito
        :param str configservice: Override the default endpoint for AWS Config
        :param str connect: Override the default endpoint for Amazon Connect
        :param str cur: Override the default endpoint for AWS Cost and Usage Reports
        :param str dataexchange: Override the default endpoint for AWS Data Exchange
        :param str datapipeline: Override the default endpoint for AWS Data Pipeline
        :param str datasync: Override the default endpoint for AWS DataSync
        :param str dax: Override the default endpoint for AWS DynamoDB Accelerator
        :param str detective: Override the default endpoint for AWS Detective
        :param str devicefarm: Override the default endpoint for AWS Device Farm
        :param str directconnect: Override the default endpoint for AWS Direct Connect
        :param str dlm: Override the default endpoint for AWS Data Lifecycle Manager
        :param str dms: Override the default endpoint for AWS Database Migration Service
        :param str docdb: Override the default endpoint for AWS DocumentDB
        :param str ds: Override the default endpoint for AWS Directory Service
        :param str dynamodb: Override the default endpoint for AWS DynamoDB
        :param str ec2: Override the default endpoint for AWS Elastic Compute Cloud (EC2)
        :param str ecr: Override the default endpoint for AWS Elastic Container Registry (ECR)
        :param str ecrpublic: Override the default endpoint for AWS Elastic Container Registry (ECR) Public
        :param str ecs: Override the default endpoint for AWS Elastic Container Service (ECS)
        :param str efs: Override the default endpoint for AWS Elastic File System (EFS)
        :param str eks: Override the default endpoint for AWS Elastic Kubernetes Service (EKS)
        :param str elasticache: Override the default endpoint for AWS ElastiCache
        :param str elasticbeanstalk: Override the default endpoint for AWS Elastic Beanstalk
        :param str elastictranscoder: Override the default endpoint for AWS Elastic Transcoder
        :param str elb: Override the default endpoint for AWS Elastic Load Balancing
        :param str elbv2: Override the default endpoint for AWS Elastic Load Balancing V2
        :param str emr: Override the default endpoint for AWS EMR
        :param str emrcontainers: Override the default endpoint for AWS EMR on EKS
        :param str es: Override the default endpoint for AWS OpenSearch Service (formerly Elasticsearch)
        :param str firehose: Override the default endpoint for AWS Kinesis Data Firehose
        :param str fms: Override the default endpoint for AWS Firewall Manager
        :param str forecast: Override the default endpoint for Amazon Forecast
        :param str fsx: Override the default endpoint for AWS FSx
        :param str gamelift: Override the default endpoint for AWS GameLift
        :param str glacier: Override the default endpoint for Amazon S3 Glacier
        :param str globalaccelerator: Override the default endpoint for AWS Global Accelerator
        :param str glue: Override the default endpoint for AWS Glue
        :param str greengrass: Override the default endpoint for AWS IoT Greengrass
        :param str guardduty: Override the default endpoint for AWS GuardDuty
        :param str iam: Override the default endpoint for AWS Identity and Access Management
        :param str identitystore: Override the default endpoint for AWS Single Sign-On (SSO) Identity Store
        :param str imagebuilder: Override the default endpoint for AWS Image Builder
        :param str inspector: Override the default endpoint for Amazon Inspector
        :param str iot: Override the default endpoint for AWS IoT
        :param str iotanalytics: Override the default endpoint for AWS IoT Analytics
        :param str iotevents: Override the default endpoint for AWS IoT Events
        :param str kafka: Override the default endpoint for Amazon Managed Streaming for Apache Kafka (MSK)
        :param str kinesis: Override the default endpoint for Amazon Kinesis
        :param str kinesisanalytics: Override the default endpoint for Amazon Kinesis Data Analytics
        :param str kinesisanalyticsv2: Override the default endpoint for Amazon Kinesis Data Analytics V2
        :param str kinesisvideo: Override the default endpoint for Amazon Kinesis Video Streams
        :param str kms: Override the default endpoint for AWS Key Management Service
        :param str lakeformation: Override the default endpoint for AWS Lake Formation
        :param str lambda_: Override the default endpoint for AWS Lambda
        :param str lexmodels: Override the default endpoint for Amazon Lex
        :param str licensemanager: Override the default endpoint for AWS License Manager
        :param str lightsail: Override the default endpoint for Amazon Lightsail
        :param str location: Override the default endpoint for Amazon Location
        :param str macie: Override the default endpoint for Amazon Macie
        :param str macie2: Override the default endpoint for Amazon Macie V2
        :param str managedblockchain: Override the default endpoint for Amazon Managed Blockchain
        :param str marketplacecatalog: Override the default endpoint for AWS Marketplace Catalog
        :param str mediaconnect: Override the default endpoint for AWS MediaConnect
        :param str mediaconvert: Override the default endpoint for AWS MediaConvert
        :param str medialive: Override the default endpoint for AWS MediaLive
        :param str mediapackage: Override the default endpoint for AWS MediaPackage
        :param str mediastore: Override the default endpoint for AWS Elemental MediaStore container
        :param str mediastoredata: Override the default endpoint for AWS Elemental MediaStore asset
        :param str memorydb: Override the default endpoint for AWS MemoryDB for Redis
        :param str mq: Override the default endpoint for Amazon MQ
        :param str mwaa: Override the default endpoint for Amazon Managed Workflows for Apache Airflow
        :param str neptune: Override the default endpoint for Amazon Neptune
        :param str networkfirewall: Override the default endpoint for AWS Network Firewall
        :param str networkmanager: Override the default endpoint for AWS Network Manager
        :param str opsworks: Override the default endpoint for AWS OpsWorks
        :param str organizations: Override the default endpoint for AWS Organizations
        :param str outposts: Override the default endpoint for AWS Outposts
        :param str personalize: Override the default endpoint for Amazon Personalize
        :param str pinpoint: Override the default endpoint for Amazon Pinpoint
        :param str pricing: Override the default endpoint for Amazon Web Services Price List Service
        :param str qldb: Override the default endpoint for Amazon QLDB
        :param str quicksight: Override the default endpoint for Amazon QuickSight
        :param str ram: Override the default endpoint for AWS Resource Access Manager
        :param str rds: Override the default endpoint for Amazon Relational Database Service
        :param str redshift: Override the default endpoint for Amazon Redshift
        :param str resourcegroups: Override the default endpoint for AWS Resource Groups
        :param str resourcegroupstaggingapi: Override the default endpoint for AWS Resource Groups Tagging API
        :param str route53: Override the default endpoint for Amazon Route 53
        :param str route53domains: Override the default endpoint for Amazon Route 53 Domains
        :param str route53recoverycontrolconfig: Override the default endpoint for Amazon Route 53 Recovery Control
        :param str route53recoveryreadiness: Override the default endpoint for Amazon Route 53 Recovery Readiness
        :param str route53resolver: Override the default endpoint for Amazon Route 53 Resolver
        :param str s3: Override the default endpoint for Amazon Simple Storage Service (S3)
        :param str s3control: Override the default endpoint for Amazon Simple Storage Service (S3) Control
        :param str s3outposts: Override the default endpoint for Amazon S3 on Outposts
        :param str sagemaker: Override the default endpoint for AWS SageMaker
        :param str schemas: Override the default endpoint for Amazon EventBridge Schema Registry
        :param str sdb: Override the default endpoint for Amazon SimpleDB
        :param str secretsmanager: Override the default endpoint for AWS Secrets Manager
        :param str securityhub: Override the default endpoint for AWS Security Hub
        :param str serverlessrepo: Override the default endpoint for AWS Serverless Application Repository
        :param str servicecatalog: Override the default endpoint for AWS Service Catalog
        :param str servicediscovery: Override the default endpoint for AWS Cloud Map
        :param str servicequotas: Override the default endpoint for AWS Service Quotas
        :param str ses: Override the default endpoint for Amazon Simple Email Service (SES)
        :param str shield: Override the default endpoint for AWS Shield Advanced API
        :param str signer: Override the default endpoint for AWS Signer
        :param str sns: Override the default endpoint for Amazon Simple Notification Service (SNS)
        :param str sqs: Override the default endpoint for Amazon Simple Queue Service (SQS)
        :param str ssm: Override the default endpoint for AWS Systems Manager
        :param str ssoadmin: Override the default endpoint for AWS Single Sign On (SSO)
        :param str stepfunctions: Override the default endpoint for AWS Step Functions
        :param str storagegateway: Override the default endpoint for AWS Storage Gateway
        :param str sts: Override the default endpoint for AWS Security Token Service (STS)
        :param str swf: Override the default endpoint for Amazon Simple Workflow Service (SWF)
        :param str synthetics: Override the default endpoint for Amazon CloudWatch Synthetics
        :param str timestreamwrite: Override the default endpoint for Amazon Timestream
        :param str transfer: Override the default endpoint for AWS Transfer Family
        :param str waf: Override the default endpoint for AWS WAF Classic
        :param str wafregional: Override the default endpoint for AWS WAF Regional Classic
        :param str wafv2: Override the default endpoint for AWS WAF V2
        :param str worklink: Override the default endpoint for Amazon WorkLink
        :param str workmail: Override the default endpoint for Amazon WorkMail
        :param str workspaces: Override the default endpoint for Amazon WorkSpaces
        :param str xray: Override the default endpoint for AWS X-Ray
        """
        if accessanalyzer is not None:
            pulumi.set(__self__, "accessanalyzer", accessanalyzer)
        if acm is not None:
            pulumi.set(__self__, "acm", acm)
        if acmpca is not None:
            pulumi.set(__self__, "acmpca", acmpca)
        if amplify is not None:
            pulumi.set(__self__, "amplify", amplify)
        if appconfig is not None:
            pulumi.set(__self__, "appconfig", appconfig)
        if applicationautoscaling is not None:
            pulumi.set(__self__, "applicationautoscaling", applicationautoscaling)
        if applicationinsights is not None:
            pulumi.set(__self__, "applicationinsights", applicationinsights)
        if appmesh is not None:
            pulumi.set(__self__, "appmesh", appmesh)
        if apprunner is not None:
            pulumi.set(__self__, "apprunner", apprunner)
        if appstream is not None:
            pulumi.set(__self__, "appstream", appstream)
        if appsync is not None:
            pulumi.set(__self__, "appsync", appsync)
        if athena is not None:
            pulumi.set(__self__, "athena", athena)
        if auditmanager is not None:
            pulumi.set(__self__, "auditmanager", auditmanager)
        if autoscaling is not None:
            pulumi.set(__self__, "autoscaling", autoscaling)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if batch is not None:
            pulumi.set(__self__, "batch", batch)
        if budgets is not None:
            pulumi.set(__self__, "budgets", budgets)
        if chime is not None:
            pulumi.set(__self__, "chime", chime)
        if cloud9 is not None:
            pulumi.set(__self__, "cloud9", cloud9)
        if cloudformation is not None:
            pulumi.set(__self__, "cloudformation", cloudformation)
        if cloudfront is not None:
            pulumi.set(__self__, "cloudfront", cloudfront)
        if cloudhsm is not None:
            pulumi.set(__self__, "cloudhsm", cloudhsm)
        if cloudsearch is not None:
            pulumi.set(__self__, "cloudsearch", cloudsearch)
        if cloudtrail is not None:
            pulumi.set(__self__, "cloudtrail", cloudtrail)
        if cloudwatch is not None:
            pulumi.set(__self__, "cloudwatch", cloudwatch)
        if cloudwatchevents is not None:
            pulumi.set(__self__, "cloudwatchevents", cloudwatchevents)
        if cloudwatchlogs is not None:
            pulumi.set(__self__, "cloudwatchlogs", cloudwatchlogs)
        if codeartifact is not None:
            pulumi.set(__self__, "codeartifact", codeartifact)
        if codebuild is not None:
            pulumi.set(__self__, "codebuild", codebuild)
        if codecommit is not None:
            pulumi.set(__self__, "codecommit", codecommit)
        if codedeploy is not None:
            pulumi.set(__self__, "codedeploy", codedeploy)
        if codepipeline is not None:
            pulumi.set(__self__, "codepipeline", codepipeline)
        if codestarconnections is not None:
            pulumi.set(__self__, "codestarconnections", codestarconnections)
        if cognitoidentity is not None:
            pulumi.set(__self__, "cognitoidentity", cognitoidentity)
        if configservice is not None:
            pulumi.set(__self__, "configservice", configservice)
        if connect is not None:
            pulumi.set(__self__, "connect", connect)
        if cur is not None:
            pulumi.set(__self__, "cur", cur)
        if dataexchange is not None:
            pulumi.set(__self__, "dataexchange", dataexchange)
        if datapipeline is not None:
            pulumi.set(__self__, "datapipeline", datapipeline)
        if datasync is not None:
            pulumi.set(__self__, "datasync", datasync)
        if dax is not None:
            pulumi.set(__self__, "dax", dax)
        if detective is not None:
            pulumi.set(__self__, "detective", detective)
        if devicefarm is not None:
            pulumi.set(__self__, "devicefarm", devicefarm)
        if directconnect is not None:
            pulumi.set(__self__, "directconnect", directconnect)
        if dlm is not None:
            pulumi.set(__self__, "dlm", dlm)
        if dms is not None:
            pulumi.set(__self__, "dms", dms)
        if docdb is not None:
            pulumi.set(__self__, "docdb", docdb)
        if ds is not None:
            pulumi.set(__self__, "ds", ds)
        if dynamodb is not None:
            pulumi.set(__self__, "dynamodb", dynamodb)
        if ec2 is not None:
            pulumi.set(__self__, "ec2", ec2)
        if ecr is not None:
            pulumi.set(__self__, "ecr", ecr)
        if ecrpublic is not None:
            pulumi.set(__self__, "ecrpublic", ecrpublic)
        if ecs is not None:
            pulumi.set(__self__, "ecs", ecs)
        if efs is not None:
            pulumi.set(__self__, "efs", efs)
        if eks is not None:
            pulumi.set(__self__, "eks", eks)
        if elasticache is not None:
            pulumi.set(__self__, "elasticache", elasticache)
        if elasticbeanstalk is not None:
            pulumi.set(__self__, "elasticbeanstalk", elasticbeanstalk)
        if elastictranscoder is not None:
            pulumi.set(__self__, "elastictranscoder", elastictranscoder)
        if elb is not None:
            pulumi.set(__self__, "elb", elb)
        if elbv2 is not None:
            pulumi.set(__self__, "elbv2", elbv2)
        if emr is not None:
            pulumi.set(__self__, "emr", emr)
        if emrcontainers is not None:
            pulumi.set(__self__, "emrcontainers", emrcontainers)
        if es is not None:
            pulumi.set(__self__, "es", es)
        if firehose is not None:
            pulumi.set(__self__, "firehose", firehose)
        if fms is not None:
            pulumi.set(__self__, "fms", fms)
        if forecast is not None:
            pulumi.set(__self__, "forecast", forecast)
        if fsx is not None:
            pulumi.set(__self__, "fsx", fsx)
        if gamelift is not None:
            pulumi.set(__self__, "gamelift", gamelift)
        if glacier is not None:
            pulumi.set(__self__, "glacier", glacier)
        if globalaccelerator is not None:
            pulumi.set(__self__, "globalaccelerator", globalaccelerator)
        if glue is not None:
            pulumi.set(__self__, "glue", glue)
        if greengrass is not None:
            pulumi.set(__self__, "greengrass", greengrass)
        if guardduty is not None:
            pulumi.set(__self__, "guardduty", guardduty)
        if iam is not None:
            pulumi.set(__self__, "iam", iam)
        if identitystore is not None:
            pulumi.set(__self__, "identitystore", identitystore)
        if imagebuilder is not None:
            pulumi.set(__self__, "imagebuilder", imagebuilder)
        if inspector is not None:
            pulumi.set(__self__, "inspector", inspector)
        if iot is not None:
            pulumi.set(__self__, "iot", iot)
        if iotanalytics is not None:
            pulumi.set(__self__, "iotanalytics", iotanalytics)
        if iotevents is not None:
            pulumi.set(__self__, "iotevents", iotevents)
        if kafka is not None:
            pulumi.set(__self__, "kafka", kafka)
        if kinesis is not None:
            pulumi.set(__self__, "kinesis", kinesis)
        if kinesisanalytics is not None:
            pulumi.set(__self__, "kinesisanalytics", kinesisanalytics)
        if kinesisanalyticsv2 is not None:
            pulumi.set(__self__, "kinesisanalyticsv2", kinesisanalyticsv2)
        if kinesisvideo is not None:
            pulumi.set(__self__, "kinesisvideo", kinesisvideo)
        if kms is not None:
            pulumi.set(__self__, "kms", kms)
        if lakeformation is not None:
            pulumi.set(__self__, "lakeformation", lakeformation)
        if lambda_ is not None:
            pulumi.set(__self__, "lambda_", lambda_)
        if lexmodels is not None:
            pulumi.set(__self__, "lexmodels", lexmodels)
        if licensemanager is not None:
            pulumi.set(__self__, "licensemanager", licensemanager)
        if lightsail is not None:
            pulumi.set(__self__, "lightsail", lightsail)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if macie is not None:
            pulumi.set(__self__, "macie", macie)
        if macie2 is not None:
            pulumi.set(__self__, "macie2", macie2)
        if managedblockchain is not None:
            pulumi.set(__self__, "managedblockchain", managedblockchain)
        if marketplacecatalog is not None:
            pulumi.set(__self__, "marketplacecatalog", marketplacecatalog)
        if mediaconnect is not None:
            pulumi.set(__self__, "mediaconnect", mediaconnect)
        if mediaconvert is not None:
            pulumi.set(__self__, "mediaconvert", mediaconvert)
        if medialive is not None:
            pulumi.set(__self__, "medialive", medialive)
        if mediapackage is not None:
            pulumi.set(__self__, "mediapackage", mediapackage)
        if mediastore is not None:
            pulumi.set(__self__, "mediastore", mediastore)
        if mediastoredata is not None:
            pulumi.set(__self__, "mediastoredata", mediastoredata)
        if memorydb is not None:
            pulumi.set(__self__, "memorydb", memorydb)
        if mq is not None:
            pulumi.set(__self__, "mq", mq)
        if mwaa is not None:
            pulumi.set(__self__, "mwaa", mwaa)
        if neptune is not None:
            pulumi.set(__self__, "neptune", neptune)
        if networkfirewall is not None:
            pulumi.set(__self__, "networkfirewall", networkfirewall)
        if networkmanager is not None:
            pulumi.set(__self__, "networkmanager", networkmanager)
        if opsworks is not None:
            pulumi.set(__self__, "opsworks", opsworks)
        if organizations is not None:
            pulumi.set(__self__, "organizations", organizations)
        if outposts is not None:
            pulumi.set(__self__, "outposts", outposts)
        if personalize is not None:
            pulumi.set(__self__, "personalize", personalize)
        if pinpoint is not None:
            pulumi.set(__self__, "pinpoint", pinpoint)
        if pricing is not None:
            pulumi.set(__self__, "pricing", pricing)
        if qldb is not None:
            pulumi.set(__self__, "qldb", qldb)
        if quicksight is not None:
            pulumi.set(__self__, "quicksight", quicksight)
        if ram is not None:
            pulumi.set(__self__, "ram", ram)
        if rds is not None:
            pulumi.set(__self__, "rds", rds)
        if redshift is not None:
            pulumi.set(__self__, "redshift", redshift)
        if resourcegroups is not None:
            pulumi.set(__self__, "resourcegroups", resourcegroups)
        if resourcegroupstaggingapi is not None:
            pulumi.set(__self__, "resourcegroupstaggingapi", resourcegroupstaggingapi)
        if route53 is not None:
            pulumi.set(__self__, "route53", route53)
        if route53domains is not None:
            pulumi.set(__self__, "route53domains", route53domains)
        if route53recoverycontrolconfig is not None:
            pulumi.set(__self__, "route53recoverycontrolconfig", route53recoverycontrolconfig)
        if route53recoveryreadiness is not None:
            pulumi.set(__self__, "route53recoveryreadiness", route53recoveryreadiness)
        if route53resolver is not None:
            pulumi.set(__self__, "route53resolver", route53resolver)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)
        if s3control is not None:
            pulumi.set(__self__, "s3control", s3control)
        if s3outposts is not None:
            pulumi.set(__self__, "s3outposts", s3outposts)
        if sagemaker is not None:
            pulumi.set(__self__, "sagemaker", sagemaker)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if sdb is not None:
            pulumi.set(__self__, "sdb", sdb)
        if secretsmanager is not None:
            pulumi.set(__self__, "secretsmanager", secretsmanager)
        if securityhub is not None:
            pulumi.set(__self__, "securityhub", securityhub)
        if serverlessrepo is not None:
            pulumi.set(__self__, "serverlessrepo", serverlessrepo)
        if servicecatalog is not None:
            pulumi.set(__self__, "servicecatalog", servicecatalog)
        if servicediscovery is not None:
            pulumi.set(__self__, "servicediscovery", servicediscovery)
        if servicequotas is not None:
            pulumi.set(__self__, "servicequotas", servicequotas)
        if ses is not None:
            pulumi.set(__self__, "ses", ses)
        if shield is not None:
            pulumi.set(__self__, "shield", shield)
        if signer is not None:
            pulumi.set(__self__, "signer", signer)
        if sns is not None:
            pulumi.set(__self__, "sns", sns)
        if sqs is not None:
            pulumi.set(__self__, "sqs", sqs)
        if ssm is not None:
            pulumi.set(__self__, "ssm", ssm)
        if ssoadmin is not None:
            pulumi.set(__self__, "ssoadmin", ssoadmin)
        if stepfunctions is not None:
            pulumi.set(__self__, "stepfunctions", stepfunctions)
        if storagegateway is not None:
            pulumi.set(__self__, "storagegateway", storagegateway)
        if sts is not None:
            pulumi.set(__self__, "sts", sts)
        if swf is not None:
            pulumi.set(__self__, "swf", swf)
        if synthetics is not None:
            pulumi.set(__self__, "synthetics", synthetics)
        if timestreamwrite is not None:
            pulumi.set(__self__, "timestreamwrite", timestreamwrite)
        if transfer is not None:
            pulumi.set(__self__, "transfer", transfer)
        if waf is not None:
            pulumi.set(__self__, "waf", waf)
        if wafregional is not None:
            pulumi.set(__self__, "wafregional", wafregional)
        if wafv2 is not None:
            pulumi.set(__self__, "wafv2", wafv2)
        if worklink is not None:
            pulumi.set(__self__, "worklink", worklink)
        if workmail is not None:
            pulumi.set(__self__, "workmail", workmail)
        if workspaces is not None:
            pulumi.set(__self__, "workspaces", workspaces)
        if xray is not None:
            pulumi.set(__self__, "xray", xray)

    @property
    @pulumi.getter
    def accessanalyzer(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Access Analyzer
        """
        return pulumi.get(self, "accessanalyzer")

    @property
    @pulumi.getter
    def acm(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Certificate Manager
        """
        return pulumi.get(self, "acm")

    @property
    @pulumi.getter
    def acmpca(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Certificate Manager Private Certificate Authority
        """
        return pulumi.get(self, "acmpca")

    @property
    @pulumi.getter
    def amplify(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Amplify Console
        """
        return pulumi.get(self, "amplify")

    @property
    @pulumi.getter
    def appconfig(self) -> Optional[str]:
        """
        Override the default endpoint for AWS AppConfig
        """
        return pulumi.get(self, "appconfig")

    @property
    @pulumi.getter
    def applicationautoscaling(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Application Auto Scaling
        """
        return pulumi.get(self, "applicationautoscaling")

    @property
    @pulumi.getter
    def applicationinsights(self) -> Optional[str]:
        """
        Override the default endpoint for AWS CloudWatch Application Insights
        """
        return pulumi.get(self, "applicationinsights")

    @property
    @pulumi.getter
    def appmesh(self) -> Optional[str]:
        """
        Override the default endpoint for AWS App Mesh
        """
        return pulumi.get(self, "appmesh")

    @property
    @pulumi.getter
    def apprunner(self) -> Optional[str]:
        """
        Override the default endpoint for AWS App Runner
        """
        return pulumi.get(self, "apprunner")

    @property
    @pulumi.getter
    def appstream(self) -> Optional[str]:
        """
        Override the default endpoint for AWS AppStream 2.0
        """
        return pulumi.get(self, "appstream")

    @property
    @pulumi.getter
    def appsync(self) -> Optional[str]:
        """
        Override the default endpoint for AWS AppSync
        """
        return pulumi.get(self, "appsync")

    @property
    @pulumi.getter
    def athena(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Athena
        """
        return pulumi.get(self, "athena")

    @property
    @pulumi.getter
    def auditmanager(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Audit Manager
        """
        return pulumi.get(self, "auditmanager")

    @property
    @pulumi.getter
    def autoscaling(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Auto Scaling
        """
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter
    def backup(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Backup
        """
        return pulumi.get(self, "backup")

    @property
    @pulumi.getter
    def batch(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Batch
        """
        return pulumi.get(self, "batch")

    @property
    @pulumi.getter
    def budgets(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Budgets
        """
        return pulumi.get(self, "budgets")

    @property
    @pulumi.getter
    def chime(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Chime
        """
        return pulumi.get(self, "chime")

    @property
    @pulumi.getter
    def cloud9(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Cloud9
        """
        return pulumi.get(self, "cloud9")

    @property
    @pulumi.getter
    def cloudformation(self) -> Optional[str]:
        """
        Override the default endpoint for AWS CloudFormation
        """
        return pulumi.get(self, "cloudformation")

    @property
    @pulumi.getter
    def cloudfront(self) -> Optional[str]:
        """
        Override the default endpoint for AWS CloudFront
        """
        return pulumi.get(self, "cloudfront")

    @property
    @pulumi.getter
    def cloudhsm(self) -> Optional[str]:
        """
        Override the default endpoint for AWS CloudHSM
        """
        return pulumi.get(self, "cloudhsm")

    @property
    @pulumi.getter
    def cloudsearch(self) -> Optional[str]:
        """
        Override the default endpoint for AWS CloudSearch
        """
        return pulumi.get(self, "cloudsearch")

    @property
    @pulumi.getter
    def cloudtrail(self) -> Optional[str]:
        """
        Override the default endpoint for AWS CloudTrail
        """
        return pulumi.get(self, "cloudtrail")

    @property
    @pulumi.getter
    def cloudwatch(self) -> Optional[str]:
        """
        Override the default endpoint for AWS CloudWatch
        """
        return pulumi.get(self, "cloudwatch")

    @property
    @pulumi.getter
    def cloudwatchevents(self) -> Optional[str]:
        """
        Override the default endpoint for AWS CloudWatch Events
        """
        return pulumi.get(self, "cloudwatchevents")

    @property
    @pulumi.getter
    def cloudwatchlogs(self) -> Optional[str]:
        """
        Override the default endpoint for AWS CloudWatch Logs
        """
        return pulumi.get(self, "cloudwatchlogs")

    @property
    @pulumi.getter
    def codeartifact(self) -> Optional[str]:
        """
        Override the default endpoint for AWS CodeArtifact
        """
        return pulumi.get(self, "codeartifact")

    @property
    @pulumi.getter
    def codebuild(self) -> Optional[str]:
        """
        Override the default endpoint for AWS CodeBuild
        """
        return pulumi.get(self, "codebuild")

    @property
    @pulumi.getter
    def codecommit(self) -> Optional[str]:
        """
        Override the default endpoint for AWS CodeCommit
        """
        return pulumi.get(self, "codecommit")

    @property
    @pulumi.getter
    def codedeploy(self) -> Optional[str]:
        """
        Override the default endpoint for AWS CodeDeploy
        """
        return pulumi.get(self, "codedeploy")

    @property
    @pulumi.getter
    def codepipeline(self) -> Optional[str]:
        """
        Override the default endpoint for AWS CodePipeline
        """
        return pulumi.get(self, "codepipeline")

    @property
    @pulumi.getter
    def codestarconnections(self) -> Optional[str]:
        """
        Override the default endpoint for AWS CodeStart Connections
        """
        return pulumi.get(self, "codestarconnections")

    @property
    @pulumi.getter
    def cognitoidentity(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Cognito
        """
        return pulumi.get(self, "cognitoidentity")

    @property
    @pulumi.getter
    def configservice(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Config
        """
        return pulumi.get(self, "configservice")

    @property
    @pulumi.getter
    def connect(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Connect
        """
        return pulumi.get(self, "connect")

    @property
    @pulumi.getter
    def cur(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Cost and Usage Reports
        """
        return pulumi.get(self, "cur")

    @property
    @pulumi.getter
    def dataexchange(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Data Exchange
        """
        return pulumi.get(self, "dataexchange")

    @property
    @pulumi.getter
    def datapipeline(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Data Pipeline
        """
        return pulumi.get(self, "datapipeline")

    @property
    @pulumi.getter
    def datasync(self) -> Optional[str]:
        """
        Override the default endpoint for AWS DataSync
        """
        return pulumi.get(self, "datasync")

    @property
    @pulumi.getter
    def dax(self) -> Optional[str]:
        """
        Override the default endpoint for AWS DynamoDB Accelerator
        """
        return pulumi.get(self, "dax")

    @property
    @pulumi.getter
    def detective(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Detective
        """
        return pulumi.get(self, "detective")

    @property
    @pulumi.getter
    def devicefarm(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Device Farm
        """
        return pulumi.get(self, "devicefarm")

    @property
    @pulumi.getter
    def directconnect(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Direct Connect
        """
        return pulumi.get(self, "directconnect")

    @property
    @pulumi.getter
    def dlm(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Data Lifecycle Manager
        """
        return pulumi.get(self, "dlm")

    @property
    @pulumi.getter
    def dms(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Database Migration Service
        """
        return pulumi.get(self, "dms")

    @property
    @pulumi.getter
    def docdb(self) -> Optional[str]:
        """
        Override the default endpoint for AWS DocumentDB
        """
        return pulumi.get(self, "docdb")

    @property
    @pulumi.getter
    def ds(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Directory Service
        """
        return pulumi.get(self, "ds")

    @property
    @pulumi.getter
    def dynamodb(self) -> Optional[str]:
        """
        Override the default endpoint for AWS DynamoDB
        """
        return pulumi.get(self, "dynamodb")

    @property
    @pulumi.getter
    def ec2(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Elastic Compute Cloud (EC2)
        """
        return pulumi.get(self, "ec2")

    @property
    @pulumi.getter
    def ecr(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Elastic Container Registry (ECR)
        """
        return pulumi.get(self, "ecr")

    @property
    @pulumi.getter
    def ecrpublic(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Elastic Container Registry (ECR) Public
        """
        return pulumi.get(self, "ecrpublic")

    @property
    @pulumi.getter
    def ecs(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Elastic Container Service (ECS)
        """
        return pulumi.get(self, "ecs")

    @property
    @pulumi.getter
    def efs(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Elastic File System (EFS)
        """
        return pulumi.get(self, "efs")

    @property
    @pulumi.getter
    def eks(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Elastic Kubernetes Service (EKS)
        """
        return pulumi.get(self, "eks")

    @property
    @pulumi.getter
    def elasticache(self) -> Optional[str]:
        """
        Override the default endpoint for AWS ElastiCache
        """
        return pulumi.get(self, "elasticache")

    @property
    @pulumi.getter
    def elasticbeanstalk(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Elastic Beanstalk
        """
        return pulumi.get(self, "elasticbeanstalk")

    @property
    @pulumi.getter
    def elastictranscoder(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Elastic Transcoder
        """
        return pulumi.get(self, "elastictranscoder")

    @property
    @pulumi.getter
    def elb(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Elastic Load Balancing
        """
        return pulumi.get(self, "elb")

    @property
    @pulumi.getter
    def elbv2(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Elastic Load Balancing V2
        """
        return pulumi.get(self, "elbv2")

    @property
    @pulumi.getter
    def emr(self) -> Optional[str]:
        """
        Override the default endpoint for AWS EMR
        """
        return pulumi.get(self, "emr")

    @property
    @pulumi.getter
    def emrcontainers(self) -> Optional[str]:
        """
        Override the default endpoint for AWS EMR on EKS
        """
        return pulumi.get(self, "emrcontainers")

    @property
    @pulumi.getter
    def es(self) -> Optional[str]:
        """
        Override the default endpoint for AWS OpenSearch Service (formerly Elasticsearch)
        """
        return pulumi.get(self, "es")

    @property
    @pulumi.getter
    def firehose(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Kinesis Data Firehose
        """
        return pulumi.get(self, "firehose")

    @property
    @pulumi.getter
    def fms(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Firewall Manager
        """
        return pulumi.get(self, "fms")

    @property
    @pulumi.getter
    def forecast(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Forecast
        """
        return pulumi.get(self, "forecast")

    @property
    @pulumi.getter
    def fsx(self) -> Optional[str]:
        """
        Override the default endpoint for AWS FSx
        """
        return pulumi.get(self, "fsx")

    @property
    @pulumi.getter
    def gamelift(self) -> Optional[str]:
        """
        Override the default endpoint for AWS GameLift
        """
        return pulumi.get(self, "gamelift")

    @property
    @pulumi.getter
    def glacier(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon S3 Glacier
        """
        return pulumi.get(self, "glacier")

    @property
    @pulumi.getter
    def globalaccelerator(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Global Accelerator
        """
        return pulumi.get(self, "globalaccelerator")

    @property
    @pulumi.getter
    def glue(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Glue
        """
        return pulumi.get(self, "glue")

    @property
    @pulumi.getter
    def greengrass(self) -> Optional[str]:
        """
        Override the default endpoint for AWS IoT Greengrass
        """
        return pulumi.get(self, "greengrass")

    @property
    @pulumi.getter
    def guardduty(self) -> Optional[str]:
        """
        Override the default endpoint for AWS GuardDuty
        """
        return pulumi.get(self, "guardduty")

    @property
    @pulumi.getter
    def iam(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Identity and Access Management
        """
        return pulumi.get(self, "iam")

    @property
    @pulumi.getter
    def identitystore(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Single Sign-On (SSO) Identity Store
        """
        return pulumi.get(self, "identitystore")

    @property
    @pulumi.getter
    def imagebuilder(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Image Builder
        """
        return pulumi.get(self, "imagebuilder")

    @property
    @pulumi.getter
    def inspector(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Inspector
        """
        return pulumi.get(self, "inspector")

    @property
    @pulumi.getter
    def iot(self) -> Optional[str]:
        """
        Override the default endpoint for AWS IoT
        """
        return pulumi.get(self, "iot")

    @property
    @pulumi.getter
    def iotanalytics(self) -> Optional[str]:
        """
        Override the default endpoint for AWS IoT Analytics
        """
        return pulumi.get(self, "iotanalytics")

    @property
    @pulumi.getter
    def iotevents(self) -> Optional[str]:
        """
        Override the default endpoint for AWS IoT Events
        """
        return pulumi.get(self, "iotevents")

    @property
    @pulumi.getter
    def kafka(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Managed Streaming for Apache Kafka (MSK)
        """
        return pulumi.get(self, "kafka")

    @property
    @pulumi.getter
    def kinesis(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Kinesis
        """
        return pulumi.get(self, "kinesis")

    @property
    @pulumi.getter
    def kinesisanalytics(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Kinesis Data Analytics
        """
        return pulumi.get(self, "kinesisanalytics")

    @property
    @pulumi.getter
    def kinesisanalyticsv2(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Kinesis Data Analytics V2
        """
        return pulumi.get(self, "kinesisanalyticsv2")

    @property
    @pulumi.getter
    def kinesisvideo(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Kinesis Video Streams
        """
        return pulumi.get(self, "kinesisvideo")

    @property
    @pulumi.getter
    def kms(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Key Management Service
        """
        return pulumi.get(self, "kms")

    @property
    @pulumi.getter
    def lakeformation(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Lake Formation
        """
        return pulumi.get(self, "lakeformation")

    @property
    @pulumi.getter(name="lambda")
    def lambda_(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Lambda
        """
        return pulumi.get(self, "lambda_")

    @property
    @pulumi.getter
    def lexmodels(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Lex
        """
        return pulumi.get(self, "lexmodels")

    @property
    @pulumi.getter
    def licensemanager(self) -> Optional[str]:
        """
        Override the default endpoint for AWS License Manager
        """
        return pulumi.get(self, "licensemanager")

    @property
    @pulumi.getter
    def lightsail(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Lightsail
        """
        return pulumi.get(self, "lightsail")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def macie(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Macie
        """
        return pulumi.get(self, "macie")

    @property
    @pulumi.getter
    def macie2(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Macie V2
        """
        return pulumi.get(self, "macie2")

    @property
    @pulumi.getter
    def managedblockchain(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Managed Blockchain
        """
        return pulumi.get(self, "managedblockchain")

    @property
    @pulumi.getter
    def marketplacecatalog(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Marketplace Catalog
        """
        return pulumi.get(self, "marketplacecatalog")

    @property
    @pulumi.getter
    def mediaconnect(self) -> Optional[str]:
        """
        Override the default endpoint for AWS MediaConnect
        """
        return pulumi.get(self, "mediaconnect")

    @property
    @pulumi.getter
    def mediaconvert(self) -> Optional[str]:
        """
        Override the default endpoint for AWS MediaConvert
        """
        return pulumi.get(self, "mediaconvert")

    @property
    @pulumi.getter
    def medialive(self) -> Optional[str]:
        """
        Override the default endpoint for AWS MediaLive
        """
        return pulumi.get(self, "medialive")

    @property
    @pulumi.getter
    def mediapackage(self) -> Optional[str]:
        """
        Override the default endpoint for AWS MediaPackage
        """
        return pulumi.get(self, "mediapackage")

    @property
    @pulumi.getter
    def mediastore(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Elemental MediaStore container
        """
        return pulumi.get(self, "mediastore")

    @property
    @pulumi.getter
    def mediastoredata(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Elemental MediaStore asset
        """
        return pulumi.get(self, "mediastoredata")

    @property
    @pulumi.getter
    def memorydb(self) -> Optional[str]:
        """
        Override the default endpoint for AWS MemoryDB for Redis
        """
        return pulumi.get(self, "memorydb")

    @property
    @pulumi.getter
    def mq(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon MQ
        """
        return pulumi.get(self, "mq")

    @property
    @pulumi.getter
    def mwaa(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Managed Workflows for Apache Airflow
        """
        return pulumi.get(self, "mwaa")

    @property
    @pulumi.getter
    def neptune(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Neptune
        """
        return pulumi.get(self, "neptune")

    @property
    @pulumi.getter
    def networkfirewall(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Network Firewall
        """
        return pulumi.get(self, "networkfirewall")

    @property
    @pulumi.getter
    def networkmanager(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Network Manager
        """
        return pulumi.get(self, "networkmanager")

    @property
    @pulumi.getter
    def opsworks(self) -> Optional[str]:
        """
        Override the default endpoint for AWS OpsWorks
        """
        return pulumi.get(self, "opsworks")

    @property
    @pulumi.getter
    def organizations(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Organizations
        """
        return pulumi.get(self, "organizations")

    @property
    @pulumi.getter
    def outposts(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Outposts
        """
        return pulumi.get(self, "outposts")

    @property
    @pulumi.getter
    def personalize(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Personalize
        """
        return pulumi.get(self, "personalize")

    @property
    @pulumi.getter
    def pinpoint(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Pinpoint
        """
        return pulumi.get(self, "pinpoint")

    @property
    @pulumi.getter
    def pricing(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Web Services Price List Service
        """
        return pulumi.get(self, "pricing")

    @property
    @pulumi.getter
    def qldb(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon QLDB
        """
        return pulumi.get(self, "qldb")

    @property
    @pulumi.getter
    def quicksight(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon QuickSight
        """
        return pulumi.get(self, "quicksight")

    @property
    @pulumi.getter
    def ram(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Resource Access Manager
        """
        return pulumi.get(self, "ram")

    @property
    @pulumi.getter
    def rds(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Relational Database Service
        """
        return pulumi.get(self, "rds")

    @property
    @pulumi.getter
    def redshift(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Redshift
        """
        return pulumi.get(self, "redshift")

    @property
    @pulumi.getter
    def resourcegroups(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Resource Groups
        """
        return pulumi.get(self, "resourcegroups")

    @property
    @pulumi.getter
    def resourcegroupstaggingapi(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Resource Groups Tagging API
        """
        return pulumi.get(self, "resourcegroupstaggingapi")

    @property
    @pulumi.getter
    def route53(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Route 53
        """
        return pulumi.get(self, "route53")

    @property
    @pulumi.getter
    def route53domains(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Route 53 Domains
        """
        return pulumi.get(self, "route53domains")

    @property
    @pulumi.getter
    def route53recoverycontrolconfig(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Route 53 Recovery Control
        """
        return pulumi.get(self, "route53recoverycontrolconfig")

    @property
    @pulumi.getter
    def route53recoveryreadiness(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Route 53 Recovery Readiness
        """
        return pulumi.get(self, "route53recoveryreadiness")

    @property
    @pulumi.getter
    def route53resolver(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Route 53 Resolver
        """
        return pulumi.get(self, "route53resolver")

    @property
    @pulumi.getter
    def s3(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Simple Storage Service (S3)
        """
        return pulumi.get(self, "s3")

    @property
    @pulumi.getter
    def s3control(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Simple Storage Service (S3) Control
        """
        return pulumi.get(self, "s3control")

    @property
    @pulumi.getter
    def s3outposts(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon S3 on Outposts
        """
        return pulumi.get(self, "s3outposts")

    @property
    @pulumi.getter
    def sagemaker(self) -> Optional[str]:
        """
        Override the default endpoint for AWS SageMaker
        """
        return pulumi.get(self, "sagemaker")

    @property
    @pulumi.getter
    def schemas(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon EventBridge Schema Registry
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter
    def sdb(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon SimpleDB
        """
        return pulumi.get(self, "sdb")

    @property
    @pulumi.getter
    def secretsmanager(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Secrets Manager
        """
        return pulumi.get(self, "secretsmanager")

    @property
    @pulumi.getter
    def securityhub(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Security Hub
        """
        return pulumi.get(self, "securityhub")

    @property
    @pulumi.getter
    def serverlessrepo(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Serverless Application Repository
        """
        return pulumi.get(self, "serverlessrepo")

    @property
    @pulumi.getter
    def servicecatalog(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Service Catalog
        """
        return pulumi.get(self, "servicecatalog")

    @property
    @pulumi.getter
    def servicediscovery(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Cloud Map
        """
        return pulumi.get(self, "servicediscovery")

    @property
    @pulumi.getter
    def servicequotas(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Service Quotas
        """
        return pulumi.get(self, "servicequotas")

    @property
    @pulumi.getter
    def ses(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Simple Email Service (SES)
        """
        return pulumi.get(self, "ses")

    @property
    @pulumi.getter
    def shield(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Shield Advanced API
        """
        return pulumi.get(self, "shield")

    @property
    @pulumi.getter
    def signer(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Signer
        """
        return pulumi.get(self, "signer")

    @property
    @pulumi.getter
    def sns(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Simple Notification Service (SNS)
        """
        return pulumi.get(self, "sns")

    @property
    @pulumi.getter
    def sqs(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Simple Queue Service (SQS)
        """
        return pulumi.get(self, "sqs")

    @property
    @pulumi.getter
    def ssm(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Systems Manager
        """
        return pulumi.get(self, "ssm")

    @property
    @pulumi.getter
    def ssoadmin(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Single Sign On (SSO)
        """
        return pulumi.get(self, "ssoadmin")

    @property
    @pulumi.getter
    def stepfunctions(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Step Functions
        """
        return pulumi.get(self, "stepfunctions")

    @property
    @pulumi.getter
    def storagegateway(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Storage Gateway
        """
        return pulumi.get(self, "storagegateway")

    @property
    @pulumi.getter
    def sts(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Security Token Service (STS)
        """
        return pulumi.get(self, "sts")

    @property
    @pulumi.getter
    def swf(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Simple Workflow Service (SWF)
        """
        return pulumi.get(self, "swf")

    @property
    @pulumi.getter
    def synthetics(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon CloudWatch Synthetics
        """
        return pulumi.get(self, "synthetics")

    @property
    @pulumi.getter
    def timestreamwrite(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon Timestream
        """
        return pulumi.get(self, "timestreamwrite")

    @property
    @pulumi.getter
    def transfer(self) -> Optional[str]:
        """
        Override the default endpoint for AWS Transfer Family
        """
        return pulumi.get(self, "transfer")

    @property
    @pulumi.getter
    def waf(self) -> Optional[str]:
        """
        Override the default endpoint for AWS WAF Classic
        """
        return pulumi.get(self, "waf")

    @property
    @pulumi.getter
    def wafregional(self) -> Optional[str]:
        """
        Override the default endpoint for AWS WAF Regional Classic
        """
        return pulumi.get(self, "wafregional")

    @property
    @pulumi.getter
    def wafv2(self) -> Optional[str]:
        """
        Override the default endpoint for AWS WAF V2
        """
        return pulumi.get(self, "wafv2")

    @property
    @pulumi.getter
    def worklink(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon WorkLink
        """
        return pulumi.get(self, "worklink")

    @property
    @pulumi.getter
    def workmail(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon WorkMail
        """
        return pulumi.get(self, "workmail")

    @property
    @pulumi.getter
    def workspaces(self) -> Optional[str]:
        """
        Override the default endpoint for Amazon WorkSpaces
        """
        return pulumi.get(self, "workspaces")

    @property
    @pulumi.getter
    def xray(self) -> Optional[str]:
        """
        Override the default endpoint for AWS X-Ray
        """
        return pulumi.get(self, "xray")


@pulumi.output_type
class IgnoreTags(dict):
    """
    The configuration with resource tag settings to ignore across all resources handled by this provider (except any individual service tag resources such as `ec2.Tag`) for situations where external systems are managing certain resource tags.
    """
    def __init__(__self__, *,
                 key_prefixes: Optional[Sequence[str]] = None,
                 keys: Optional[Sequence[str]] = None):
        """
        The configuration with resource tag settings to ignore across all resources handled by this provider (except any individual service tag resources such as `ec2.Tag`) for situations where external systems are managing certain resource tags.
        :param Sequence[str] key_prefixes: List of exact resource tag keys to ignore across all resources handled by this provider. This configuration prevents Pulumi from returning the tag in any `tags` attributes and displaying any configuration difference for the tag value. If any resource configuration still has this tag key configured in the `tags` argument, it will display a perpetual difference until the tag is removed from the argument or `ignoreChanges` is also used.
        :param Sequence[str] keys: List of resource tag key prefixes to ignore across all resources handled by this provider. This configuration prevents Pulumi from returning any tag key matching the prefixes in any `tags` attributes and displaying any configuration difference for those tag values. If any resource configuration still has a tag matching one of the prefixes configured in the `tags` argument, it will display a perpetual difference until the tag is removed from the argument or `ignoreChanges` is also used.
        """
        if key_prefixes is not None:
            pulumi.set(__self__, "key_prefixes", key_prefixes)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)

    @property
    @pulumi.getter(name="keyPrefixes")
    def key_prefixes(self) -> Optional[Sequence[str]]:
        """
        List of exact resource tag keys to ignore across all resources handled by this provider. This configuration prevents Pulumi from returning the tag in any `tags` attributes and displaying any configuration difference for the tag value. If any resource configuration still has this tag key configured in the `tags` argument, it will display a perpetual difference until the tag is removed from the argument or `ignoreChanges` is also used.
        """
        return pulumi.get(self, "key_prefixes")

    @property
    @pulumi.getter
    def keys(self) -> Optional[Sequence[str]]:
        """
        List of resource tag key prefixes to ignore across all resources handled by this provider. This configuration prevents Pulumi from returning any tag key matching the prefixes in any `tags` attributes and displaying any configuration difference for those tag values. If any resource configuration still has a tag matching one of the prefixes configured in the `tags` argument, it will display a perpetual difference until the tag is removed from the argument or `ignoreChanges` is also used.
        """
        return pulumi.get(self, "keys")


