# Generated by Django 3.2.9 on 2022-01-02 20:11

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("memberaudit", "0006_add_current_ship"),
    ]

    operations = [
        migrations.CreateModel(
            name="DiscordCategory",
            fields=[
                ("id", models.BigIntegerField(primary_key=True, serialize=False)),
                ("name", models.CharField(db_index=True, max_length=100)),
                ("last_update_at", models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name="DiscordChannel",
            fields=[
                ("id", models.BigIntegerField(primary_key=True, serialize=False)),
                ("name", models.CharField(db_index=True, max_length=100)),
                ("last_update_at", models.DateTimeField(auto_now=True)),
                (
                    "category",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="channels",
                        to="mailrelay.discordcategory",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="RelayConfig",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "is_enabled",
                    models.BooleanField(
                        default=True,
                        help_text="Toogle for activating or deactivating relaying mails.",
                    ),
                ),
                (
                    "last_service_run_at",
                    models.DateTimeField(
                        default=None,
                        editable=False,
                        help_text="Time of last successful service run.",
                        null=True,
                    ),
                ),
                (
                    "mail_category",
                    models.CharField(
                        choices=[
                            ("AL", "All mails"),
                            ("AM", "Alliance mails"),
                            ("CM", "Corporation mails"),
                        ],
                        help_text="Category of mails that you want to relay to Discord.",
                        max_length=2,
                    ),
                ),
                (
                    "ping_type",
                    models.CharField(
                        choices=[
                            ("PN", "(none)"),
                            ("PH", "@here"),
                            ("PE", "@everybody"),
                        ],
                        default="PN",
                        help_text="Option to ping every member of the channel.",
                        max_length=2,
                        verbose_name="channel pings",
                    ),
                ),
                (
                    "character",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="memberaudit.character",
                    ),
                ),
                (
                    "discord_channel",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="mailrelay.discordchannel",
                    ),
                ),
                (
                    "mails_sent",
                    models.ManyToManyField(
                        editable=False,
                        help_text="Latest mails that have already been sent.",
                        related_name="_mailrelay_relayconfig_mails_sent_+",
                        to="memberaudit.CharacterMail",
                    ),
                ),
            ],
        ),
    ]
