# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.drawing.framework
# Libre Office Version: 7.3
from typing_extensions import Literal
import typing
from .x_resource_id import XResourceId as XResourceId_5be3103d


class TabBarButton(object):
    """
    Struct Class

    Descriptor of a tab bar button.
    
    Tab bar buttons are typically used to offer the user the choice between different views to be displayed in one pane.
    
    For identification only the ResourceId is used, so for some methods of the XTabBar interface only the ResourceId member is evaluated.

    See Also:
        `API TabBarButton <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1drawing_1_1framework_1_1TabBarButton.html>`_
    """
    typeName: Literal['com.sun.star.drawing.framework.TabBarButton']

    def __init__(self, ButtonLabel: typing.Optional[str] = ..., HelpText: typing.Optional[str] = ..., ResourceId: typing.Optional[XResourceId_5be3103d] = ...) -> None:
        """
        Constructor

        Arguments:
            ButtonLabel (str, optional): ButtonLabel value.
            HelpText (str, optional): HelpText value.
            ResourceId (XResourceId, optional): ResourceId value.
        """


    @property
    def ButtonLabel(self) -> str:
        """
        This label is displayed on the UI as button text.
        
        The label is expected to be localized.
        """


    @property
    def HelpText(self) -> str:
        """
        The localized help text that may be displayed in a tool tip.
        """


    @property
    def ResourceId(self) -> XResourceId_5be3103d:
        """
        XResourceId object of the resource that is requested to be displayed when the tab bar button is activated.
        
        For some methods of the XTabBar interface only this member is evaluated. That is because only this member is used to identify a tab bar button.
        """


