# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-03-03T13:21:38+00:00

from __future__ import annotations

from datetime import datetime, timedelta
from enum import Enum
from typing import List, Literal, Optional, Union

from pydantic import AnyUrl, BaseModel, Field, SecretStr, confloat, conint


class ActivityUpdate(BaseModel):
    tags: Optional[List[str]] = Field(None, title='Tags')


class BodyAddEmailToWhitelistAdminEmailWhitelistPost(BaseModel):
    email: str = Field(..., title='Email')


class BodyCreateApplicationApplicationsPost(BaseModel):
    name: str = Field(..., title='Name')
    description: str = Field(..., title='Description')
    url: AnyUrl = Field(..., title='Url')
    image: AnyUrl = Field(..., title='Image')
    redirect_uris: List[AnyUrl] = Field(..., title='Redirect Uris')
    privacy_statement: AnyUrl = Field(..., title='Privacy Statement')


class BodyCreateApplicationSecretApplicationsApplicationIdSecretsPost(BaseModel):
    label: str = Field(..., title='Label')


class BodyCreateTagTagsPost(BaseModel):
    tag: str = Field(..., title='Tag')


class BodyDeleteEmailFromWhitelistAdminEmailWhitelistDelete(BaseModel):
    email: str = Field(..., title='Email')


class BodyLoginPostLoginPost(BaseModel):
    email: str = Field(..., title='Email')
    password: SecretStr = Field(..., title='Password')
    tz_offset: int = Field(..., title='Tz Offset')


class BodyRegisterPostRegisterPost(BaseModel):
    email: str = Field(..., title='Email')
    password: SecretStr = Field(..., title='Password')


class BodySaveOrUpdateIntegrationProviderTenantsTenantIdIntegrationProvidersIntegrationNamePost(
    BaseModel
):
    client_id: str = Field(..., title='Client Id')
    client_secret: SecretStr = Field(..., title='Client Secret')
    redirect_url: str = Field(..., title='Redirect Url')


class BodyUpdateApplicationApplicationsApplicationIdPut(BaseModel):
    name: str = Field(..., title='Name')
    description: str = Field(..., title='Description')
    url: AnyUrl = Field(..., title='Url')
    image: AnyUrl = Field(..., title='Image')
    redirect_uris: List[AnyUrl] = Field(..., title='Redirect Uris')
    privacy_statement: AnyUrl = Field(..., title='Privacy Statement')


class BodyUpdateUserUsersUserIdPut(BaseModel):
    first_name: str = Field(..., title='First Name')
    last_name: str = Field(..., title='Last Name')


class BodyUploadActivityFileDataUploadPost(BaseModel):
    files: List[bytes] = Field(..., title='Files')


class CoreTemperatureSummary(BaseModel):
    mean: Optional[float] = Field(None, title='Mean')
    min: Optional[float] = Field(None, title='Min')
    max: Optional[float] = Field(None, title='Max')
    start: Optional[float] = Field(None, title='Start')
    end: Optional[float] = Field(None, title='End')


class DistanceSummary(BaseModel):
    sum: Optional[int] = Field(None, title='Sum')


class ElevationSummary(BaseModel):
    min: Optional[int] = Field(None, title='Min')
    max: Optional[int] = Field(None, title='Max')


class GarminDeregistration(BaseModel):
    userId: str = Field(..., title='Userid')
    userAccessToken: str = Field(..., title='Useraccesstoken')


class GarminDeregistrationBody(BaseModel):
    deregistrations: List[GarminDeregistration] = Field(..., title='Deregistrations')


class GarminFileTypes(Enum):
    FIT = 'FIT'
    GPX = 'GPX'
    TCX = 'TCX'


class GrantType(Enum):
    authorization_code = 'authorization_code'
    refresh_token = 'refresh_token'


class HeartRateSummary(BaseModel):
    mean: Optional[float] = Field(None, title='Mean')
    min: Optional[float] = Field(None, title='Min')
    max: Optional[float] = Field(None, title='Max')
    start: Optional[float] = Field(None, title='Start')
    end: Optional[float] = Field(None, title='End')


class IntegrationName(Enum):
    garmin_connect = 'garmin_connect'


class Metric(Enum):
    duration = 'duration'
    lap = 'lap'
    power = 'power'
    speed = 'speed'
    heart_rate = 'heart_rate'
    smo2 = 'smo2'
    core_temperature = 'core_temperature'
    elevation = 'elevation'
    cadence = 'cadence'
    temperature = 'temperature'
    distance = 'distance'
    longitude = 'longitude'
    latitude = 'latitude'
    lactate = 'lactate'
    rpe = 'rpe'
    notes = 'notes'


class PowerSummary(BaseModel):
    mean: Optional[float] = Field(None, title='Mean')
    min: Optional[float] = Field(None, title='Min')
    max: Optional[float] = Field(None, title='Max')


class Scope(Enum):
    data_read = 'data:read'
    data_write = 'data:write'
    admin = 'admin'
    openid = 'openid'
    profile = 'profile'


class Smo2Summary(BaseModel):
    mean: Optional[float] = Field(None, title='Mean')
    min: Optional[float] = Field(None, title='Min')
    max: Optional[float] = Field(None, title='Max')
    start: Optional[float] = Field(None, title='Start')
    end: Optional[float] = Field(None, title='End')


class SpeedSummary(BaseModel):
    mean: Optional[float] = Field(None, title='Mean')
    min: Optional[float] = Field(None, title='Min')
    max: Optional[float] = Field(None, title='Max')


class Sport(Enum):
    cycling = 'cycling'
    cycling_road = 'cycling.road'
    cycling_tt = 'cycling.tt'
    cycling_cyclocross = 'cycling.cyclocross'
    cycling_gravel = 'cycling.gravel'
    cycling_mountainbike = 'cycling.mountainbike'
    cycling_track = 'cycling.track'
    cycling_track_250m = 'cycling.track.250m'
    cycling_track_333m = 'cycling.track.333m'
    cycling_trainer = 'cycling.trainer'
    running = 'running'
    running_road = 'running.road'
    running_track = 'running.track'
    running_track_200m = 'running.track.200m'
    running_track_400m = 'running.track.400m'
    running_trail = 'running.trail'
    running_treadmill = 'running.treadmill'
    walking = 'walking'
    walking_hiking = 'walking.hiking'
    cross_country_skiing = 'cross_country_skiing'
    cross_country_skiing_classic = 'cross_country_skiing.classic'
    cross_country_skiing_skate = 'cross_country_skiing.skate'
    cross_country_skiing_backcountry = 'cross_country_skiing.backcountry'
    cross_country_skiing_ergometer = 'cross_country_skiing.ergometer'
    rowing = 'rowing'
    rowing_ergometer = 'rowing.ergometer'
    rowing_indoor = 'rowing.indoor'
    rowing_regatta = 'rowing.regatta'
    rowing_fixed_seat = 'rowing.fixed-seat'
    rowing_coastal = 'rowing.coastal'
    swimming = 'swimming'
    swimming_pool = 'swimming.pool'
    swimming_pool_50m = 'swimming.pool.50m'
    swimming_pool_25m = 'swimming.pool.25m'
    swimming_pool_25y = 'swimming.pool.25y'
    swimming_pool_33m = 'swimming.pool.33m'
    swimming_open_water = 'swimming.open_water'
    swimming_flume = 'swimming.flume'
    generic = 'generic'
    unknown = 'unknown'


class TemperatureSummary(BaseModel):
    mean: Optional[float] = Field(None, title='Mean')
    min: Optional[float] = Field(None, title='Min')
    max: Optional[float] = Field(None, title='Max')


class TokenRequest(BaseModel):
    grant_type: GrantType
    client_id: Optional[str] = Field(None, title='Client Id')
    code: Optional[str] = Field(None, title='Code')
    client_secret: Optional[str] = Field(None, title='Client Secret')
    code_verifier: Optional[str] = Field(None, title='Code Verifier')
    refresh_token: Optional[str] = Field(None, title='Refresh Token')
    tz_offset: Optional[int] = Field(0, title='Tz Offset')


class TokenResponse(BaseModel):
    access_token: str = Field(..., title='Access Token')
    token_type: Literal['Bearer'] = Field('Bearer', title='Token Type')
    expires_in: int = Field(..., title='Expires In')
    refresh_token: str = Field(..., title='Refresh Token')
    scope: Optional[str] = Field(None, title='Scope')
    id_token: Optional[str] = Field(None, title='Id Token')


class TraceCreateOrUpdate(BaseModel):
    timestamp: datetime = Field(..., title='Timestamp')
    lactate: Optional[float] = Field(None, title='Lactate')
    rpe: Optional[int] = Field(None, title='Rpe')
    notes: Optional[str] = Field(None, title='Notes')
    power: Optional[conint(ge=0)] = Field(None, title='Power')
    speed: Optional[confloat(ge=0.0)] = Field(None, title='Speed')
    heart_rate: Optional[conint(ge=0)] = Field(None, title='Heart Rate')
    tags: Optional[List[str]] = Field(None, title='Tags')
    sport: Optional[Sport] = None


class UserInfoResponse(BaseModel):
    sub: str = Field(..., title='Sub')
    given_name: Optional[str] = Field(None, title='Given Name')
    family_name: Optional[str] = Field(None, title='Family Name')
    name: str = Field(..., title='Name')


class UserSummary(BaseModel):
    id: str = Field(..., title='Id')
    first_name: Optional[str] = Field(..., title='First Name')
    last_name: Optional[str] = Field(..., title='Last Name')
    scopes: List[Scope] = Field(..., title='Scopes')
    display_name: str = Field(..., title='Display Name')


class ValidationError(BaseModel):
    loc: List[Union[str, int]] = Field(..., title='Location')
    msg: str = Field(..., title='Message')
    type: str = Field(..., title='Error Type')


class ActivitySummarySummary(BaseModel):
    power: Optional[PowerSummary] = None
    speed: Optional[SpeedSummary] = None
    distance: Optional[DistanceSummary] = None
    elevation: Optional[ElevationSummary] = None
    heart_rate: Optional[HeartRateSummary] = None
    temperature: Optional[TemperatureSummary] = None
    core_temperature: Optional[CoreTemperatureSummary] = None
    smo2: Optional[Smo2Summary] = None


class BodyAuthorizeOauthAuthorizePost(BaseModel):
    client_id: str = Field(..., title='Client Id')
    redirect_uri: Optional[str] = Field(None, title='Redirect Uri')
    scopes: List[Scope] = Field(..., min_length=1, title='Scopes')
    state: Optional[str] = Field(None, title='State')
    nonce: Optional[str] = Field(None, title='Nonce')
    code_challenge: Optional[str] = Field(None, title='Code Challenge')
    code_challenge_method: Optional[str] = Field(None, title='Code Challenge Method')


class DelegatedTokenRequest(BaseModel):
    sub: str = Field(..., title='Sub')
    scopes: List[Scope] = Field(..., title='Scopes')


class GarminActivityFileData(BaseModel):
    userId: str = Field(..., title='Userid')
    userAccessToken: str = Field(..., title='Useraccesstoken')
    summaryId: str = Field(..., title='Summaryid')
    fileType: GarminFileTypes
    callbackURL: str = Field(..., title='Callbackurl')
    startTimeInSeconds: datetime = Field(..., title='Starttimeinseconds')
    activityId: str = Field(..., title='Activityid')
    activityName: str = Field(..., title='Activityname')
    manual: Optional[bool] = Field(False, title='Manual')


class GarminPingBody(BaseModel):
    activityFiles: List[GarminActivityFileData] = Field(..., title='Activityfiles')


class HTTPValidationError(BaseModel):
    detail: Optional[List[ValidationError]] = Field(None, title='Detail')


class Lap(BaseModel):
    power: Optional[PowerSummary] = None
    speed: Optional[SpeedSummary] = None
    distance: Optional[DistanceSummary] = None
    elevation: Optional[ElevationSummary] = None
    heart_rate: Optional[HeartRateSummary] = None
    temperature: Optional[TemperatureSummary] = None
    core_temperature: Optional[CoreTemperatureSummary] = None
    smo2: Optional[Smo2Summary] = None
    start: datetime = Field(..., title='Start')
    end: datetime = Field(..., title='End')
    duration: timedelta = Field(..., title='Duration')


class ActivityDetails(BaseModel):
    tags: Optional[List[str]] = Field(None, title='Tags')
    id: str = Field(..., title='Id')
    sport: Sport
    start: datetime = Field(..., title='Start')
    end: datetime = Field(..., title='End')
    metrics: List[Metric] = Field(..., title='Metrics')
    source_id: str = Field(..., title='Source Id')
    summary: Optional[ActivitySummarySummary] = None
    laps: Optional[List[Lap]] = Field(None, title='Laps')
    traces: Optional[List[TraceDetails]] = Field(None, title='Traces')
    distance: Optional[float] = Field(None, title='Distance')
    duration: timedelta = Field(..., title='Duration')


class ActivitySummary(BaseModel):
    tags: Optional[List[str]] = Field(None, title='Tags')
    id: str = Field(..., title='Id')
    sport: Sport
    start: datetime = Field(..., title='Start')
    end: datetime = Field(..., title='End')
    metrics: List[Metric] = Field(..., title='Metrics')
    source_id: str = Field(..., title='Source Id')
    summary: Optional[ActivitySummarySummary] = None
    laps: Optional[List[Lap]] = Field(None, title='Laps')
    traces: Optional[List[TraceDetails]] = Field(None, title='Traces')
    duration: timedelta = Field(..., title='Duration')


class TraceDetails(BaseModel):
    tags: Optional[List[str]] = Field(None, title='Tags')
    id: str = Field(..., title='Id')
    timestamp: datetime = Field(..., title='Timestamp')
    lactate: Optional[float] = Field(None, title='Lactate')
    rpe: Optional[int] = Field(None, title='Rpe')
    notes: Optional[str] = Field(None, title='Notes')
    power: Optional[conint(ge=0)] = Field(None, title='Power')
    speed: Optional[confloat(ge=0.0)] = Field(None, title='Speed')
    heart_rate: Optional[conint(ge=0)] = Field(None, title='Heart Rate')
    lap: Optional[Lap] = None
    activity: Optional[ActivitySummary] = None
    sport: Optional[Sport] = None


ActivityDetails.model_rebuild()
ActivitySummary.model_rebuild()
