"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManagedKubernetesCluster = exports.ManagedKubernetesClusterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cs_generated_1 = require("./cs.generated");
Object.defineProperty(exports, "ManagedKubernetesClusterProperty", { enumerable: true, get: function () { return cs_generated_1.RosManagedKubernetesCluster; } });
/**
 * A ROS resource type:  `ALIYUN::CS::ManagedKubernetesCluster`
 */
class ManagedKubernetesCluster extends ros.Resource {
    /**
     * Create a new `ALIYUN::CS::ManagedKubernetesCluster`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosManagedKubernetesCluster = new cs_generated_1.RosManagedKubernetesCluster(this, id, {
            endpointPublicAccess: props.endpointPublicAccess === undefined || props.endpointPublicAccess === null ? false : props.endpointPublicAccess,
            socEnabled: props.socEnabled,
            formatDisk: props.formatDisk,
            platform: props.platform,
            resourceGroupId: props.resourceGroupId,
            userData: props.userData,
            autoRenew: props.autoRenew,
            addons: props.addons,
            workerSystemDiskCategory: props.workerSystemDiskCategory === undefined || props.workerSystemDiskCategory === null ? 'cloud_efficiency' : props.workerSystemDiskCategory,
            workerSystemDiskSize: props.workerSystemDiskSize === undefined || props.workerSystemDiskSize === null ? 120 : props.workerSystemDiskSize,
            loadBalancerSpec: props.loadBalancerSpec,
            name: props.name,
            taint: props.taint,
            isEnterpriseSecurityGroup: props.isEnterpriseSecurityGroup,
            runtime: props.runtime,
            cloudMonitorFlags: props.cloudMonitorFlags === undefined || props.cloudMonitorFlags === null ? false : props.cloudMonitorFlags,
            osType: props.osType,
            nodeNameMode: props.nodeNameMode,
            serviceCidr: props.serviceCidr === undefined || props.serviceCidr === null ? '172.19.0.0/20' : props.serviceCidr,
            podVswitchIds: props.podVswitchIds,
            zoneIds: props.zoneIds,
            proxyMode: props.proxyMode === undefined || props.proxyMode === null ? 'iptables' : props.proxyMode,
            disableRollback: props.disableRollback === undefined || props.disableRollback === null ? true : props.disableRollback,
            tags: props.tags,
            workerInstanceTypes: props.workerInstanceTypes,
            loginPassword: props.loginPassword,
            autoRenewPeriod: props.autoRenewPeriod,
            kubernetesVersion: props.kubernetesVersion,
            containerCidr: props.containerCidr === undefined || props.containerCidr === null ? '172.16.0.0/16' : props.containerCidr,
            keyPair: props.keyPair,
            nodeCidrMask: props.nodeCidrMask,
            vSwitchIds: props.vSwitchIds,
            workerDataDisks: props.workerDataDisks,
            timeoutMins: props.timeoutMins === undefined || props.timeoutMins === null ? 60 : props.timeoutMins,
            securityGroupId: props.securityGroupId,
            period: props.period,
            clusterSpec: props.clusterSpec,
            deletionProtection: props.deletionProtection,
            cisEnabled: props.cisEnabled,
            workerDataDisk: props.workerDataDisk === undefined || props.workerDataDisk === null ? false : props.workerDataDisk,
            vpcId: props.vpcId,
            numOfNodes: props.numOfNodes === undefined || props.numOfNodes === null ? 3 : props.numOfNodes,
            keepInstanceName: props.keepInstanceName,
            nodePools: props.nodePools,
            chargeType: props.chargeType,
            encryptionProviderKey: props.encryptionProviderKey,
            snatEntry: props.snatEntry === undefined || props.snatEntry === null ? true : props.snatEntry,
            periodUnit: props.periodUnit,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosManagedKubernetesCluster;
        this.attrApiServerSlbId = rosManagedKubernetesCluster.attrApiServerSlbId;
        this.attrClusterId = rosManagedKubernetesCluster.attrClusterId;
        this.attrDefaultUserKubeConfig = rosManagedKubernetesCluster.attrDefaultUserKubeConfig;
        this.attrNodes = rosManagedKubernetesCluster.attrNodes;
        this.attrPrivateUserKubConfig = rosManagedKubernetesCluster.attrPrivateUserKubConfig;
        this.attrScalingConfigurationId = rosManagedKubernetesCluster.attrScalingConfigurationId;
        this.attrScalingGroupId = rosManagedKubernetesCluster.attrScalingGroupId;
        this.attrScalingRuleId = rosManagedKubernetesCluster.attrScalingRuleId;
        this.attrTaskId = rosManagedKubernetesCluster.attrTaskId;
        this.attrWorkerRamRoleName = rosManagedKubernetesCluster.attrWorkerRamRoleName;
    }
}
exports.ManagedKubernetesCluster = ManagedKubernetesCluster;
//# sourceMappingURL=data:application/json;base64,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