"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesCluster = exports.KubernetesClusterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cs_generated_1 = require("./cs.generated");
Object.defineProperty(exports, "KubernetesClusterProperty", { enumerable: true, get: function () { return cs_generated_1.RosKubernetesCluster; } });
/**
 * A ROS resource type:  `ALIYUN::CS::KubernetesCluster`
 */
class KubernetesCluster extends ros.Resource {
    /**
     * Create a new `ALIYUN::CS::KubernetesCluster`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosKubernetesCluster = new cs_generated_1.RosKubernetesCluster(this, id, {
            endpointPublicAccess: props.endpointPublicAccess === undefined || props.endpointPublicAccess === null ? false : props.endpointPublicAccess,
            socEnabled: props.socEnabled,
            platform: props.platform,
            resourceGroupId: props.resourceGroupId,
            masterSystemDiskCategory: props.masterSystemDiskCategory === undefined || props.masterSystemDiskCategory === null ? 'cloud_ssd' : props.masterSystemDiskCategory,
            masterCount: props.masterCount === undefined || props.masterCount === null ? 3 : props.masterCount,
            sshFlags: props.sshFlags,
            loadBalancerSpec: props.loadBalancerSpec,
            name: props.name,
            taint: props.taint,
            masterDataDisks: props.masterDataDisks,
            isEnterpriseSecurityGroup: props.isEnterpriseSecurityGroup,
            runtime: props.runtime,
            masterZoneIds: props.masterZoneIds,
            osType: props.osType,
            nodeNameMode: props.nodeNameMode,
            workerZoneIds: props.workerZoneIds,
            proxyMode: props.proxyMode === undefined || props.proxyMode === null ? 'iptables' : props.proxyMode,
            disableRollback: props.disableRollback === undefined || props.disableRollback === null ? true : props.disableRollback,
            tags: props.tags,
            containerCidr: props.containerCidr === undefined || props.containerCidr === null ? '172.16.0.0/16' : props.containerCidr,
            cpuPolicy: props.cpuPolicy,
            keyPair: props.keyPair,
            nodeCidrMask: props.nodeCidrMask,
            period: props.period,
            deletionProtection: props.deletionProtection,
            timeZone: props.timeZone,
            vpcId: props.vpcId,
            nodePools: props.nodePools,
            userCa: props.userCa,
            snatEntry: props.snatEntry === undefined || props.snatEntry === null ? true : props.snatEntry,
            masterDataDisk: props.masterDataDisk === undefined || props.masterDataDisk === null ? false : props.masterDataDisk,
            masterSystemDiskSnapshotPolicyId: props.masterSystemDiskSnapshotPolicyId,
            periodUnit: props.periodUnit,
            formatDisk: props.formatDisk,
            userData: props.userData,
            autoRenew: props.autoRenew,
            addons: props.addons,
            masterSystemDiskSize: props.masterSystemDiskSize === undefined || props.masterSystemDiskSize === null ? 120 : props.masterSystemDiskSize,
            workerSystemDiskCategory: props.workerSystemDiskCategory === undefined || props.workerSystemDiskCategory === null ? 'cloud_efficiency' : props.workerSystemDiskCategory,
            nodePortRange: props.nodePortRange === undefined || props.nodePortRange === null ? '30000-65535' : props.nodePortRange,
            workerSystemDiskSize: props.workerSystemDiskSize === undefined || props.workerSystemDiskSize === null ? 120 : props.workerSystemDiskSize,
            masterVSwitchIds: props.masterVSwitchIds,
            cloudMonitorFlags: props.cloudMonitorFlags === undefined || props.cloudMonitorFlags === null ? false : props.cloudMonitorFlags,
            serviceCidr: props.serviceCidr === undefined || props.serviceCidr === null ? '172.19.0.0/20' : props.serviceCidr,
            podVswitchIds: props.podVswitchIds,
            workerInstanceTypes: props.workerInstanceTypes,
            loginPassword: props.loginPassword,
            autoRenewPeriod: props.autoRenewPeriod,
            kubernetesVersion: props.kubernetesVersion,
            masterInstanceTypes: props.masterInstanceTypes,
            masterSystemDiskPerformanceLevel: props.masterSystemDiskPerformanceLevel,
            workerDataDisks: props.workerDataDisks,
            securityGroupId: props.securityGroupId,
            timeoutMins: props.timeoutMins === undefined || props.timeoutMins === null ? 60 : props.timeoutMins,
            cisEnabled: props.cisEnabled,
            workerDataDisk: props.workerDataDisk === undefined || props.workerDataDisk === null ? false : props.workerDataDisk,
            numOfNodes: props.numOfNodes === undefined || props.numOfNodes === null ? 3 : props.numOfNodes,
            keepInstanceName: props.keepInstanceName,
            chargeType: props.chargeType,
            workerSystemDiskSnapshotPolicyId: props.workerSystemDiskSnapshotPolicyId,
            workerVSwitchIds: props.workerVSwitchIds,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosKubernetesCluster;
        this.attrApiServerSlbId = rosKubernetesCluster.attrApiServerSlbId;
        this.attrClusterId = rosKubernetesCluster.attrClusterId;
        this.attrDefaultUserKubeConfig = rosKubernetesCluster.attrDefaultUserKubeConfig;
        this.attrNodes = rosKubernetesCluster.attrNodes;
        this.attrPrivateUserKubConfig = rosKubernetesCluster.attrPrivateUserKubConfig;
        this.attrScalingConfigurationId = rosKubernetesCluster.attrScalingConfigurationId;
        this.attrScalingGroupId = rosKubernetesCluster.attrScalingGroupId;
        this.attrScalingRuleId = rosKubernetesCluster.attrScalingRuleId;
        this.attrTaskId = rosKubernetesCluster.attrTaskId;
        this.attrWorkerRamRoleName = rosKubernetesCluster.attrWorkerRamRoleName;
    }
}
exports.KubernetesCluster = KubernetesCluster;
//# sourceMappingURL=data:application/json;base64,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