"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClusterAddons = exports.ClusterAddonsProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cs_generated_1 = require("./cs.generated");
Object.defineProperty(exports, "ClusterAddonsProperty", { enumerable: true, get: function () { return cs_generated_1.RosClusterAddons; } });
/**
 * A ROS resource type:  `ALIYUN::CS::ClusterAddons`
 */
class ClusterAddons extends ros.Resource {
    /**
     * Create a new `ALIYUN::CS::ClusterAddons`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosClusterAddons = new cs_generated_1.RosClusterAddons(this, id, {
            clusterId: props.clusterId,
            addons: props.addons,
            installedIgnore: props.installedIgnore === undefined || props.installedIgnore === null ? false : props.installedIgnore,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosClusterAddons;
        this.attrClusterId = rosClusterAddons.attrClusterId;
    }
}
exports.ClusterAddons = ClusterAddons;
//# sourceMappingURL=data:application/json;base64,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