from __future__ import annotations
from collections.abc import Callable
from typing import Any
from ...fable_modules.fable_library.option import default_arg
from ...fable_modules.fable_library.result import FSharpResult_2
from ...fable_modules.fable_library.string_ import (to_text, printf)
from ...fable_modules.thoth_json_core.types import IEncodable
from ...fable_modules.thoth_json_python.decode import Decode_fromString
from ...fable_modules.thoth_json_python.encode import to_string
from ...Core.Process.sample import Sample
from ...Json.encode import default_spaces
from ...Json.Process.sample import (ISAJson_decoder, ISAJson_encoder, ROCrate_decoder, ROCrate_encoder)

def ARCtrl_Process_Sample__Sample_fromISAJsonString_Static_Z721C83C5(s: str) -> Sample:
    match_value: FSharpResult_2[Sample, str] = Decode_fromString(ISAJson_decoder, s)
    if match_value.tag == 1:
        raise Exception(to_text(printf("Error decoding string: %O"))(match_value.fields[0]))

    else: 
        return match_value.fields[0]



def ARCtrl_Process_Sample__Sample_toISAJsonString_Static_Z3B036AA(spaces: int | None=None, use_idreferencing: bool | None=None) -> Callable[[Sample], str]:
    id_map: Any | None = dict([]) if default_arg(use_idreferencing, False) else None
    def _arrow3003(f: Sample, spaces: Any=spaces, use_idreferencing: Any=use_idreferencing) -> str:
        value_1: IEncodable = ISAJson_encoder(id_map, f)
        return to_string(default_spaces(spaces), value_1)

    return _arrow3003


def ARCtrl_Process_Sample__Sample_ToISAJsonString_Z3B036AA(this: Sample, spaces: int | None=None, use_idreferencing: bool | None=None) -> str:
    return ARCtrl_Process_Sample__Sample_toISAJsonString_Static_Z3B036AA(spaces, use_idreferencing)(this)


def ARCtrl_Process_Sample__Sample_fromROCrateString_Static_Z721C83C5(s: str) -> Sample:
    match_value: FSharpResult_2[Sample, str] = Decode_fromString(ROCrate_decoder, s)
    if match_value.tag == 1:
        raise Exception(to_text(printf("Error decoding string: %O"))(match_value.fields[0]))

    else: 
        return match_value.fields[0]



def ARCtrl_Process_Sample__Sample_toROCrateString_Static_71136F3F(spaces: int | None=None) -> Callable[[Sample], str]:
    def _arrow3004(f: Sample, spaces: Any=spaces) -> str:
        value: IEncodable = ROCrate_encoder(f)
        return to_string(default_spaces(spaces), value)

    return _arrow3004


def ARCtrl_Process_Sample__Sample_ToROCrateString_71136F3F(this: Sample, spaces: int | None=None) -> str:
    return ARCtrl_Process_Sample__Sample_toROCrateString_Static_71136F3F(spaces)(this)


__all__ = ["ARCtrl_Process_Sample__Sample_fromISAJsonString_Static_Z721C83C5", "ARCtrl_Process_Sample__Sample_toISAJsonString_Static_Z3B036AA", "ARCtrl_Process_Sample__Sample_ToISAJsonString_Z3B036AA", "ARCtrl_Process_Sample__Sample_fromROCrateString_Static_Z721C83C5", "ARCtrl_Process_Sample__Sample_toROCrateString_Static_71136F3F", "ARCtrl_Process_Sample__Sample_ToROCrateString_71136F3F"]

