# mypy-boto3-workdocs

[![PyPI - mypy-boto3-workdocs](https://img.shields.io/pypi/v/mypy-boto3-workdocs.svg?color=blue)](https://pypi.org/project/mypy-boto3-workdocs)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-workdocs.svg?color=blue)](https://pypi.org/project/mypy-boto3-workdocs)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.WorkDocs 1.14.52](https://boto3.amazonaws.com/v1/documentation/api/1.14.52/reference/services/workdocs.html#WorkDocs) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.3.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `WorkDocs` service.

```bash
python -m pip install boto3-stubs[workdocs]
```

## How to use

### Client annotations

`WorkDocsClient` provides annotations for `boto3.client("workdocs")`.

```python
import boto3

from mypy_boto3_workdocs import WorkDocsClient
from mypy_boto3_workdocs.paginator import (
    DescribeActivitiesPaginator,
    DescribeCommentsPaginator,
    DescribeDocumentVersionsPaginator,
    DescribeFolderContentsPaginator,
    DescribeGroupsPaginator,
    DescribeNotificationSubscriptionsPaginator,
    DescribeResourcePermissionsPaginator,
    DescribeRootFoldersPaginator,
    DescribeUsersPaginator,
)
from mypy_boto3_workdocs.type_defs import ActivityTypeDef, ...

client: WorkDocsClient = boto3.client("workdocs")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: WorkDocsClient = session.client("workdocs")
```

### Paginators annotations

`mypy_boto3_workdocs.paginator` module contains type annotations for all paginators.

```python

client: WorkDocsClient = boto3.client("workdocs")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_activities_paginator: DescribeActivitiesPaginator = client.get_paginator("describe_activities")
describe_comments_paginator: DescribeCommentsPaginator = client.get_paginator("describe_comments")
describe_document_versions_paginator: DescribeDocumentVersionsPaginator = client.get_paginator("describe_document_versions")
describe_folder_contents_paginator: DescribeFolderContentsPaginator = client.get_paginator("describe_folder_contents")
describe_groups_paginator: DescribeGroupsPaginator = client.get_paginator("describe_groups")
describe_notification_subscriptions_paginator: DescribeNotificationSubscriptionsPaginator = client.get_paginator("describe_notification_subscriptions")
describe_resource_permissions_paginator: DescribeResourcePermissionsPaginator = client.get_paginator("describe_resource_permissions")
describe_root_folders_paginator: DescribeRootFoldersPaginator = client.get_paginator("describe_root_folders")
describe_users_paginator: DescribeUsersPaginator = client.get_paginator("describe_users")
```







### Typed dictionations

`mypy_boto3_workdocs.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> ActivityTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_workdocs` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("workdocs")

session_client = boto3.Session().client("workdocs")
```
