/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.graph.matrix.AdjacencyMatrix;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class TopologicalDescriptor
implements IMolecularDescriptor {
    public static final String[] names = new String[]{"topoRadius", "topoDiameter", "topoShape"};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("topoDistance", this.getClass().getName(), "$Id: TopologicalDescriptor.java 1 2013-05-31 14:29:01Z yapchunwei $", "PaDEL");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception exception) {
        int n = this.getDescriptorNames().length;
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult(n);
        for (int i = 0; i < n; ++i) {
            doubleArrayResult.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames(), exception);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        int n;
        int n2;
        IAtomContainer iAtomContainer2 = AtomContainerManipulator.removeHydrogens(iAtomContainer);
        int n3 = iAtomContainer2.getAtomCount();
        int[][] nArray = AdjacencyMatrix.getMatrix(iAtomContainer2);
        int[][] nArray2 = PathTools.computeFloydAPSP(nArray);
        int[] nArray3 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            n = -99999;
            for (int i = 0; i < n3; ++i) {
                if (nArray2[n2][i] <= n) continue;
                n = nArray2[n2][i];
            }
            nArray3[n2] = n;
        }
        n2 = 999999;
        n = -999999;
        for (int n4 : nArray3) {
            if (n4 < n2) {
                n2 = n4;
            }
            if (n4 <= n) continue;
            n = n4;
        }
        double d = (double)(n - n2) / (double)n2;
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
        doubleArrayResult.add(n2);
        doubleArrayResult.add(n);
        doubleArrayResult.add(d);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, names);
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(names.length);
    }
}

