/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.WeightDescriptorTest")
public class PaDELWeightDescriptor
implements IMolecularDescriptor {
    private String elementName = "*";

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#weight", this.getClass().getName(), "$Id: 9927243df29a118e9bfd0b8624bc8d77d3c6db07 $", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] objectArray) throws CDKException {
        if (objectArray.length > 1) {
            throw new CDKException("weight only expects one parameter");
        }
        if (!(objectArray[0] instanceof String)) {
            throw new CDKException("The parameter must be of type String");
        }
        this.elementName = (String)objectArray[0];
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        Object[] objectArray = new Object[]{this.elementName};
        return objectArray;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        String string = "w";
        if (this.elementName.equals("*")) {
            return new String[]{"MW", "AMW"};
        }
        string = string + this.elementName;
        return new String[]{string};
    }

    private DescriptorValue getDummyDescriptorValue(Exception exception) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), this.getDescriptorNames(), exception);
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        double d = 0.0;
        if (this.elementName.equals("*")) {
            try {
                int n = 0;
                for (int i = 0; i < iAtomContainer.getAtomCount(); ++i) {
                    d += IsotopeFactory.getInstance(iAtomContainer.getBuilder()).getMajorIsotope(iAtomContainer.getAtom(i).getSymbol()).getExactMass().doubleValue();
                    Integer n2 = iAtomContainer.getAtom(i).getImplicitHydrogenCount();
                    if (n2 == CDKConstants.UNSET) {
                        n2 = 0;
                    }
                    d += (double)n2.intValue() * 1.00782504;
                    n += 1 + n2;
                }
                DoubleArrayResult doubleArrayResult = new DoubleArrayResult(2);
                doubleArrayResult.add(d);
                if (n > 0) {
                    doubleArrayResult.add(d / (double)n);
                } else {
                    doubleArrayResult.add(Double.NaN);
                }
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames());
            }
            catch (Exception exception) {
                DoubleArrayResult doubleArrayResult = new DoubleArrayResult(2);
                doubleArrayResult.add(Double.NaN);
                doubleArrayResult.add(Double.NaN);
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames(), exception);
            }
        }
        if (this.elementName.equals("H")) {
            try {
                IIsotope iIsotope = IsotopeFactory.getInstance(iAtomContainer.getBuilder()).getMajorIsotope("H");
                for (int i = 0; i < iAtomContainer.getAtomCount(); ++i) {
                    if (iAtomContainer.getAtom(i).getSymbol().equals(this.elementName)) {
                        d += IsotopeFactory.getInstance(iAtomContainer.getBuilder()).getMajorIsotope(iAtomContainer.getAtom(i).getSymbol()).getExactMass().doubleValue();
                        continue;
                    }
                    d += (double)iAtomContainer.getAtom(i).getImplicitHydrogenCount().intValue() * iIsotope.getExactMass();
                }
            }
            catch (Exception exception) {
                return this.getDummyDescriptorValue(exception);
            }
        }
        try {
            for (int i = 0; i < iAtomContainer.getAtomCount(); ++i) {
                if (!iAtomContainer.getAtom(i).getSymbol().equals(this.elementName)) continue;
                d += IsotopeFactory.getInstance(iAtomContainer.getBuilder()).getMajorIsotope(iAtomContainer.getAtom(i).getSymbol()).getExactMass().doubleValue();
            }
        }
        catch (Exception exception) {
            return this.getDummyDescriptorValue(exception);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(d), this.getDescriptorNames());
    }

    @Override
    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        if (this.elementName.equals("*")) {
            return new DoubleArrayResultType(2);
        }
        return new DoubleResult(0.0);
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        String[] stringArray = new String[]{"elementSymbol"};
        return stringArray;
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String string) {
        return "";
    }
}

