# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pydatafaker']

package_data = \
{'': ['*']}

install_requires = \
['faker>=4.1.2,<5.0.0', 'pandas>=1.1.1,<2.0.0']

setup_kwargs = {
    'name': 'pydatafaker',
    'version': '0.1.1a4',
    'description': 'A python package to create fake data with relationships between tables.',
    'long_description': "\n![logo](docs/source/_static/logo_with_grey_text.png)\n\n![test\\_with\\_pytest](https://github.com/SamEdwardes/pydatafaker/workflows/test_with_pytest/badge.svg)\n[![Documentation\nStatus](https://readthedocs.org/projects/pydatafaker/badge/?version=latest)](https://pydatafaker.readthedocs.io/en/latest/?badge=latest)\n\nPyDataFaker is a python package to create fake data with relationships\nbetween tables. Creating fake data can be useful for many different\napplications such as creating product demos or testing software.\n\nPython already has a great package for creating fake data called Faker\n<https://faker.readthedocs.io/en/master/>. Faker is great for creating\nindividual fake units of data, but it can be time consuming to create\nmore complicated fake data that is actually related to one another.\n\nImagine you are developing a new enterprise resource planning (ERP)\nsoftware to challenge SAP. You may need to create some fake data to test\nyour application. You will need an invoice table, a vendor listing,\npurchase order table, and more. PyDataFaker allows your to quickly\ncreate these tables and generates relationships between them\\!\n\nPyDataFaker is currently under development. At this time it is possible\nto create the following entities:\n\n  - **Business**: create a fake business with common ERP like tables\n  - **School**: create a fake school\n\nMore entities are currently being developed. If you have any ideas of\nadditional entities that should be included please submit an issue here:\n<https://github.com/SamEdwardes/pydatafaker/issues>.\n\n## Table of contents\n\n  - [Installation](#installation)\n  - [Documentation](#documentation)\n  - [Usage](#usage)\n  - [Contributing](#contributing)\n  - [Credits](#credits)\n\n## Installation\n\n``` bash\npip install pydatafaker\n```\n\n## Documentation\n\nDocumentation can be found at\n<https://pydatafaker.readthedocs.io/en/latest/index.html>. The package\nis distributed through PyPi at <https://pypi.org/project/pydatafaker/>\n\n## Usage\n\n### Business\n\nThe business module allows you to create fake business data. Calling\n`business.create_business()` will return a dictionary of related tables.\n\n``` python\nimport pandas as pd\nfrom pydatafaker import business\nbiz =  business.create_business()\nbiz.keys()\n```\n\n    ## dict_keys(['vendor_table', 'po_table', 'invoice_summary_table', 'invoice_line_item_table', 'employee_table', 'contract_table', 'rate_sheet_table', 'timesheet_table'])\n\nEach value inside the dictionary contains a Pandas DataFrame.\n\n``` python\nbiz['invoice_summary_table']\n```\n\n    ##     invoice_id  amount invoice_date     po_id     vendor_id\n    ## 0    inv_00001  112392   2016-01-10  po_00003  vendor_00093\n    ## 1    inv_00002  155508   2000-02-18  po_00095  vendor_00033\n    ## 2    inv_00003   78362   2014-12-01  po_00001  vendor_00025\n    ## 3    inv_00004  123528   2000-03-14  po_00001  vendor_00025\n    ## 4    inv_00005   49888   2015-03-23  po_00081  vendor_00075\n    ## ..         ...     ...          ...       ...           ...\n    ## 245  inv_00246  155793   2011-11-15  po_00081  vendor_00075\n    ## 246  inv_00247   95235   2009-08-12  po_00083  vendor_00088\n    ## 247  inv_00248  126292   2010-05-07  po_00086  vendor_00088\n    ## 248  inv_00249   96395   2010-08-05  po_00065  vendor_00036\n    ## 249  inv_00250   61256   2018-04-28  po_00078  vendor_00091\n    ## \n    ## [250 rows x 5 columns]\n\nTables can be joined together to add additional details.\n\n``` python\ninvoice_summary = biz['invoice_summary_table']\nvendors = biz['vendor_table']\n\npd.merge(invoice_summary, vendors, how='left', on='vendor_id')\n```\n\n    ##     invoice_id  amount  ...                phone                       email\n    ## 0    inv_00001  112392  ...  (878)925-9060x48837        joanne31@example.net\n    ## 1    inv_00002  155508  ...  (085)250-3658x57756  simpsonmatthew@example.net\n    ## 2    inv_00003   78362  ...     001-060-773-3423      juliashort@example.org\n    ## 3    inv_00004  123528  ...     001-060-773-3423      juliashort@example.org\n    ## 4    inv_00005   49888  ...   516-622-9334x65178        andrew77@example.org\n    ## ..         ...     ...  ...                  ...                         ...\n    ## 245  inv_00246  155793  ...   516-622-9334x65178        andrew77@example.org\n    ## 246  inv_00247   95235  ...         785-421-2374   crystalsutton@example.org\n    ## 247  inv_00248  126292  ...         785-421-2374   crystalsutton@example.org\n    ## 248  inv_00249   96395  ...   (126)191-5842x2835         logan03@example.org\n    ## 249  inv_00250   61256  ...        (396)940-5345         gmurphy@example.com\n    ## \n    ## [250 rows x 10 columns]\n\n### School\n\n``` python\nimport pandas as pd\nfrom pydatafaker import school\nskool =  school.create_school()\nskool.keys()\n```\n\n    ## dict_keys(['student_table', 'teacher_table', 'room_table', 'grade_table'])\n\n``` python\nskool['student_table']\n```\n\n    ##       student_id              name  grade    teacher_id\n    ## 0   student_0023   Samantha Hebert      1  teacher_0010\n    ## 1   student_0024  Dustin Hernandez      1  teacher_0003\n    ## 2   student_0032       Sylvia Reed      1  teacher_0010\n    ## 3   student_0034          Glen Kim      1  teacher_0010\n    ## 4   student_0049     Cynthia Huynh      1  teacher_0010\n    ## ..           ...               ...    ...           ...\n    ## 37  student_0273      Steven Scott      7  teacher_0005\n    ## 38  student_0284    Julie Martinez      7  teacher_0005\n    ## 39  student_0287        Sarah Ross      7  teacher_0005\n    ## 40  student_0295        Jill Jones      7  teacher_0005\n    ## 41  student_0299       Stacy Smith      7  teacher_0005\n    ## \n    ## [300 rows x 4 columns]\n\n## Contributing\n\nPlease see [docs/source/contributing.rst](docs/source/contributing.rst).\n\n## Credits\n\nDeveloped by:\n\n  - Sam Edwardes\n\nLogo:\n\n  - Icon made by [Freepik](https://www.flaticon.com/authors/freepik)\n    from [www.flaticon.com](https://www.flaticon.com/)\n  - Front from\n    [fontmeme.com/retro-fonts/](https://fontmeme.com/retro-fonts/)\n  - Logo generated using [logomakr.com](logomakr.com/7scB4)\n",
    'author': 'Sam Edwardes',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/SamEdwardes/pydatafaker',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
