# Generated by Django 3.1.7 on 2021-02-26 05:37

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Area',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64)),
                ('notes', models.TextField(blank=True)),
                ('parent', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='tickle.area')),
            ],
        ),
        migrations.CreateModel(
            name='Boulder',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64)),
                ('difficulty', models.CharField(choices=[('v0', 'v0'), ('v1', 'v1'), ('v2', 'v2'), ('v3', 'v3'), ('v4', 'v4'), ('v5', 'v5'), ('v6', 'v6'), ('v7', 'v7'), ('v8', 'v8'), ('v9', 'v9'), ('v10', 'v10'), ('v11', 'v11'), ('v12', 'v12'), ('v13', 'v13'), ('v14', 'v14'), ('v15', 'v15'), ('v16', 'v16')], max_length=8)),
                ('mountainproject', models.URLField(blank=True)),
                ('notes', models.TextField(blank=True)),
                ('area', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='tickle.area')),
            ],
        ),
        migrations.CreateModel(
            name='Route',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64)),
                ('protection_style', models.CharField(choices=[('sport', 'Sport'), ('toprope', 'Top Rope'), ('trad', 'Trad')], max_length=8)),
                ('mountainproject', models.URLField(blank=True)),
                ('notes', models.TextField(blank=True)),
                ('area', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='tickle.area')),
            ],
        ),
        migrations.CreateModel(
            name='Todo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('notes', models.TextField(blank=True)),
                ('protection', models.CharField(choices=[('none', 'None'), ('bolts', 'Bolts'), ('gear', 'Gear'), ('pad', 'Pad'), ('tr', 'Top Rope')], max_length=8)),
                ('style', models.CharField(choices=[('onsight', 'On Sight'), ('flash', 'Flash'), ('project', 'Project'), ('other', 'Other')], max_length=8)),
                ('boulder', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='todos', to='tickle.boulder')),
                ('route', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='todos', to='tickle.route')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('route__name',),
            },
        ),
        migrations.CreateModel(
            name='Pitch',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.PositiveSmallIntegerField()),
                ('difficulty', models.CharField(choices=[('3', '3'), ('4', '4'), ('5.0', '5.0'), ('5.1', '5.1'), ('5.2', '5.2'), ('5.3', '5.3'), ('5.4', '5.4'), ('5.5', '5.5'), ('5.6', '5.6'), ('5.7', '5.7'), ('5.7+', '5.7+'), ('5.8', '5.8'), ('5.8+', '5.8+'), ('5.9', '5.9'), ('5.9+', '5.9+'), ('5.10a', '5.10a'), ('5.10b', '5.10b'), ('5.10c', '5.10c'), ('5.10d', '5.10d'), ('5.11a', '5.11a'), ('5.11b', '5.11b'), ('5.11c', '5.11c'), ('5.11d', '5.11d'), ('5.12a', '5.12a'), ('5.12b', '5.12b'), ('5.12c', '5.12c'), ('5.12d', '5.12d'), ('5.13a', '5.13a'), ('5.13b', '5.13b'), ('5.13c', '5.13c'), ('5.13d', '5.13d'), ('5.14a', '5.14a'), ('5.14b', '5.14b'), ('5.14c', '5.14c'), ('5.14d', '5.14d'), ('5.15a', '5.15a'), ('5.15b', '5.15b'), ('5.15c', '5.15c'), ('5.15d', '5.15d')], max_length=8)),
                ('name', models.CharField(blank=True, max_length=32)),
                ('notes', models.TextField(blank=True)),
                ('route', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='pitches', to='tickle.route')),
            ],
            options={
                'ordering': ('order',),
            },
        ),
        migrations.CreateModel(
            name='Attempt',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField()),
                ('notes', models.TextField(blank=True)),
                ('result', models.CharField(choices=[('send', 'Sent'), ('fall', 'Fall')], max_length=8)),
                ('prior_knowledge', models.BooleanField(default=True)),
                ('protection_used', models.CharField(choices=[('none', 'None'), ('bolts', 'Bolts'), ('gear', 'Gear'), ('pad', 'Pad'), ('tr', 'Top Rope')], max_length=8)),
                ('boulder', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='attempts', to='tickle.boulder')),
                ('route', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='attempts', to='tickle.route')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('date',),
            },
        ),
        migrations.AddConstraint(
            model_name='todo',
            constraint=models.CheckConstraint(check=models.Q(models.Q(('boulder__isnull', True), models.Q(_negated=True, route__isnull=True)), models.Q(models.Q(_negated=True, boulder__isnull=True), ('route__isnull', True)), _connector='OR'), name='todo_boulder_xor_route'),
        ),
        migrations.AddConstraint(
            model_name='attempt',
            constraint=models.CheckConstraint(check=models.Q(models.Q(('boulder__isnull', True), models.Q(_negated=True, route__isnull=True)), models.Q(models.Q(_negated=True, boulder__isnull=True), ('route__isnull', True)), _connector='OR'), name='attempt_boulder_xor_route'),
        ),
    ]
