# Generated by Django 2.2.4 on 2019-08-20 19:55

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='EveEntity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128)),
                ('portrait', models.URLField(blank=True, max_length=255, null=True)),
                ('external_id', models.IntegerField(unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='EveScope',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name='EveAlliance',
            fields=[
                ('eveentity_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='django_eveonline_connector.EveEntity')),
                ('ticker', models.CharField(max_length=5)),
            ],
            bases=('django_eveonline_connector.eveentity',),
        ),
        migrations.CreateModel(
            name='EveCharacter',
            fields=[
                ('eveentity_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='django_eveonline_connector.EveEntity')),
            ],
            bases=('django_eveonline_connector.eveentity',),
        ),
        migrations.CreateModel(
            name='EveWalletTransaction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('client_id', models.IntegerField()),
                ('date', models.DateTimeField()),
                ('is_buy', models.BooleanField()),
                ('is_personal', models.BooleanField()),
                ('journal_ref_id', models.IntegerField()),
                ('location_id', models.IntegerField()),
                ('quantity', models.IntegerField()),
                ('transcation_id', models.IntegerField()),
                ('type_id', models.IntegerField()),
                ('type_name', models.CharField(max_length=32)),
                ('unit_price', models.FloatField()),
                ('entity', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_eveonline_connector.EveEntity')),
            ],
        ),
        migrations.CreateModel(
            name='EveClient',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('esi_base_url', models.URLField(default='https://esi.evetech.net/latest/swagger.json?datasource=tranquility')),
                ('esi_callback_url', models.URLField()),
                ('esi_sso_url', models.URLField(editable=False)),
                ('esi_client_id', models.CharField(max_length=255)),
                ('esi_secret_key', models.CharField(max_length=255)),
                ('esi_scopes', models.ManyToManyField(blank=True, to='django_eveonline_connector.EveScope')),
            ],
        ),
        migrations.CreateModel(
            name='EveToken',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('access_token', models.TextField()),
                ('refresh_token', models.TextField()),
                ('expires_in', models.IntegerField(default=0)),
                ('expiry', models.DateTimeField(auto_now_add=True)),
                ('scopes', models.ManyToManyField(blank=True, to='django_eveonline_connector.EveScope')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('character', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='eve_token', to='django_eveonline_connector.EveCharacter')),
            ],
        ),
        migrations.CreateModel(
            name='EveCorporation',
            fields=[
                ('eveentity_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='django_eveonline_connector.EveEntity')),
                ('ticker', models.CharField(max_length=5)),
                ('alliance', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_eveonline_connector.EveAlliance')),
                ('ceo', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_eveonline_connector.EveCharacter')),
            ],
            bases=('django_eveonline_connector.eveentity',),
        ),
        migrations.AddField(
            model_name='evecharacter',
            name='corporation',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_eveonline_connector.EveCorporation'),
        ),
        migrations.AddField(
            model_name='evealliance',
            name='executor',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_eveonline_connector.EveCorporation'),
        ),
    ]
