# ESPMega Light Show
This is a program made for the ESPMega PLCs for easily programming light show and running light show script

## Features
- User Interface for configuring controller<br/>
![](/images/setup_window.png)
- Light Grid Generator<br/>
![](/images/generate_map.png)
- Easy Clickable Light Programming<br/>
![](/images/mainwindow.png)
- Dynamic Physical Light Configuration<br/>
![](/images/light_config.png)
- Custom Script using Python<br/>
![](/images/run_script.png)
- BPM Counter<br/>
![](/images/bpm_counter.png)
- Quick Load Preset<br/>
![](/images/quickload.png)

## Installation
- For Windows, run the following command in a powershell windows with admin rights
  ```powershell
  Set-ExecutionPolicy Bypass -Scope Process -Force; [System.Net.ServicePointManager]::SecurityProtocol = [System.Net.ServicePointManager]::SecurityProtocol -bor 3072; iex ((New-Object System.Net.WebClient).DownloadString('https://raw.githubusercontent.com/SiwatINC/espmega-lightshow/main/installer_win.ps1'))
  ```
- Ubuntu Linux
  ```bash
  bash <(curl -s https://raw.githubusercontent.com/SiwatINC/espmega-lightshow/main/installer_ubuntu.sh)
  ```

## Running
- The program can be run from the CLI using the command:
```bash
python -m espmega_lightshow
```
- The program can also be run from the desktop/startmenu shortcut after installation.

## Scripting
This template script can be used to program custom lightshow
```python
from espmega_lightshow.scripting import UserScript
class CustomUserScript (UserScript):
    def draw_frame(self, current_time: float):
        # This function is called every frame
        # You can use self.rows and self.columns to get the number of rows and columns
        # You can use self.set_tile_state(row, column, state) to set the state of a light at row, column
        # You can use self.get_tile_state(row, column) to get the state of a light at row, column
        # You can use current_time to get the current time elapsed in seconds
        # You can use self.frame_count to get the number of frames that have passed
        pass
```

The script can be run by going to **File** &rarr; **Run Script**