# Generated by Django 3.2.13 on 2022-05-16 23:53

import django.core.serializers.json
from django.db import migrations, models
import django.db.models.deletion
import nautobot.extras.models.mixins
import nautobot.extras.models.statuses
import nautobot.ipam.fields
import nautobot_firewall_models.validators
import taggit.managers
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("extras", "0033_add__optimized_indexing"),
        ("tenancy", "0002_auto_slug"),
        ("dcim", "0009_add_natural_indexing"),
        ("ipam", "0007_add_natural_indexing"),
    ]

    operations = [
        migrations.CreateModel(
            name="AddressObject",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("description", models.CharField(blank=True, max_length=200)),
                ("name", models.CharField(max_length=100, unique=True)),
            ],
            options={
                "verbose_name_plural": "Address Objects",
                "ordering": ["name"],
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin),
        ),
        migrations.CreateModel(
            name="AddressObjectGroup",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("description", models.CharField(blank=True, max_length=200)),
                ("name", models.CharField(max_length=100, unique=True)),
            ],
            options={
                "verbose_name_plural": "Address Object Groups",
                "ordering": ["name"],
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin),
        ),
        migrations.CreateModel(
            name="DestAddrGroupM2M",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                (
                    "addr_group",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT, to="nautobot_firewall_models.addressobjectgroup"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="DestAddrM2M",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="FQDN",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("description", models.CharField(blank=True, max_length=200)),
                ("name", models.CharField(max_length=254, unique=True)),
            ],
            options={
                "verbose_name": "FQDN",
                "verbose_name_plural": "FQDNs",
                "ordering": ["name"],
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin),
        ),
        migrations.CreateModel(
            name="Policy",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("description", models.CharField(blank=True, max_length=200)),
                ("name", models.CharField(max_length=100, unique=True)),
            ],
            options={
                "verbose_name_plural": "Policies",
                "ordering": ["name"],
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin),
        ),
        migrations.CreateModel(
            name="PolicyRule",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("name", models.CharField(max_length=100)),
                ("action", models.CharField(max_length=20)),
                ("log", models.BooleanField(default=False)),
                ("request_id", models.CharField(blank=True, max_length=100, null=True)),
                (
                    "destination_address",
                    models.ManyToManyField(
                        related_name="destination_policy_rules",
                        through="nautobot_firewall_models.DestAddrM2M",
                        to="nautobot_firewall_models.AddressObject",
                    ),
                ),
                (
                    "destination_address_group",
                    models.ManyToManyField(
                        related_name="destination_policy_rules",
                        through="nautobot_firewall_models.DestAddrGroupM2M",
                        to="nautobot_firewall_models.AddressObjectGroup",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Policy Rules",
                "ordering": ["name"],
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin),
        ),
        migrations.CreateModel(
            name="ServiceObject",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("description", models.CharField(blank=True, max_length=200)),
                ("name", models.CharField(max_length=100)),
                (
                    "port",
                    models.CharField(
                        blank=True,
                        max_length=20,
                        null=True,
                        validators=[nautobot_firewall_models.validators.validate_port],
                    ),
                ),
                ("ip_protocol", models.CharField(max_length=20)),
                (
                    "status",
                    nautobot.extras.models.statuses.StatusField(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="nautobot_firewall_models_serviceobject_related",
                        to="extras.status",
                    ),
                ),
                ("tags", taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag")),
            ],
            options={
                "verbose_name_plural": "Service Objects",
                "ordering": ["name"],
                "unique_together": {("port", "ip_protocol")},
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin),
        ),
        migrations.CreateModel(
            name="ServiceObjectGroup",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("description", models.CharField(blank=True, max_length=200)),
                ("name", models.CharField(max_length=100, unique=True)),
            ],
            options={
                "verbose_name_plural": "Service Object Groups",
                "ordering": ["name"],
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin),
        ),
        migrations.CreateModel(
            name="UserObject",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("username", models.CharField(max_length=100, unique=True)),
                ("name", models.CharField(blank=True, max_length=100)),
                (
                    "status",
                    nautobot.extras.models.statuses.StatusField(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="nautobot_firewall_models_userobject_related",
                        to="extras.status",
                    ),
                ),
                ("tags", taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag")),
            ],
            options={
                "verbose_name_plural": "User Objects",
                "ordering": ["username"],
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin),
        ),
        migrations.CreateModel(
            name="UserObjectGroup",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("description", models.CharField(blank=True, max_length=200)),
                ("name", models.CharField(max_length=100, unique=True)),
                (
                    "status",
                    nautobot.extras.models.statuses.StatusField(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="nautobot_firewall_models_userobjectgroup_related",
                        to="extras.status",
                    ),
                ),
                ("tags", taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag")),
            ],
            options={
                "verbose_name_plural": "User Object Groups",
                "ordering": ["name"],
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin),
        ),
        migrations.CreateModel(
            name="Zone",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("description", models.CharField(blank=True, max_length=200)),
                ("name", models.CharField(max_length=100, unique=True)),
            ],
            options={
                "verbose_name_plural": "Zones",
                "ordering": ["name"],
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin),
        ),
        migrations.CreateModel(
            name="ZoneVRFM2M",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("vrf", models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to="ipam.vrf")),
                (
                    "zone",
                    models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="nautobot_firewall_models.zone"),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ZoneInterfaceM2M",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("interface", models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to="dcim.interface")),
                (
                    "zone",
                    models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="nautobot_firewall_models.zone"),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="zone",
            name="interfaces",
            field=models.ManyToManyField(
                blank=True,
                related_name="zones",
                through="nautobot_firewall_models.ZoneInterfaceM2M",
                to="dcim.Interface",
            ),
        ),
        migrations.AddField(
            model_name="zone",
            name="status",
            field=nautobot.extras.models.statuses.StatusField(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="nautobot_firewall_models_zone_related",
                to="extras.status",
            ),
        ),
        migrations.AddField(
            model_name="zone",
            name="tags",
            field=taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag"),
        ),
        migrations.AddField(
            model_name="zone",
            name="vrfs",
            field=models.ManyToManyField(
                blank=True, related_name="zones", through="nautobot_firewall_models.ZoneVRFM2M", to="ipam.VRF"
            ),
        ),
        migrations.CreateModel(
            name="UserObjectGroupM2M",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT, to="nautobot_firewall_models.userobject"
                    ),
                ),
                (
                    "user_group",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="nautobot_firewall_models.userobjectgroup"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="userobjectgroup",
            name="user_objects",
            field=models.ManyToManyField(
                blank=True,
                related_name="user_object_groups",
                through="nautobot_firewall_models.UserObjectGroupM2M",
                to="nautobot_firewall_models.UserObject",
            ),
        ),
        migrations.CreateModel(
            name="SvcM2M",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                (
                    "pol_rule",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="nautobot_firewall_models.policyrule"
                    ),
                ),
                (
                    "svc",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT, to="nautobot_firewall_models.serviceobject"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SvcGroupM2M",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                (
                    "pol_rule",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="nautobot_firewall_models.policyrule"
                    ),
                ),
                (
                    "svc_group",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT, to="nautobot_firewall_models.serviceobjectgroup"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SrcUserM2M",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                (
                    "pol_rule",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="nautobot_firewall_models.policyrule"
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT, to="nautobot_firewall_models.userobject"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SrcUserGroupM2M",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                (
                    "pol_rule",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="nautobot_firewall_models.policyrule"
                    ),
                ),
                (
                    "user_group",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT, to="nautobot_firewall_models.userobjectgroup"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SrcAddrM2M",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                (
                    "addr",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT, to="nautobot_firewall_models.addressobject"
                    ),
                ),
                (
                    "pol_rule",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="nautobot_firewall_models.policyrule"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SrcAddrGroupM2M",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                (
                    "addr_group",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT, to="nautobot_firewall_models.addressobjectgroup"
                    ),
                ),
                (
                    "pol_rule",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="nautobot_firewall_models.policyrule"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ServiceObjectGroupM2M",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                (
                    "service",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT, to="nautobot_firewall_models.serviceobject"
                    ),
                ),
                (
                    "service_group",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="nautobot_firewall_models.serviceobjectgroup"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="serviceobjectgroup",
            name="service_objects",
            field=models.ManyToManyField(
                blank=True,
                related_name="service_object_groups",
                through="nautobot_firewall_models.ServiceObjectGroupM2M",
                to="nautobot_firewall_models.ServiceObject",
            ),
        ),
        migrations.AddField(
            model_name="serviceobjectgroup",
            name="status",
            field=nautobot.extras.models.statuses.StatusField(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="nautobot_firewall_models_serviceobjectgroup_related",
                to="extras.status",
            ),
        ),
        migrations.AddField(
            model_name="serviceobjectgroup",
            name="tags",
            field=taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag"),
        ),
        migrations.CreateModel(
            name="PolicyRuleM2M",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("index", models.PositiveSmallIntegerField(blank=True, null=True)),
                (
                    "policy",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="nautobot_firewall_models.policy"
                    ),
                ),
                (
                    "rule",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT, to="nautobot_firewall_models.policyrule"
                    ),
                ),
            ],
            options={
                "ordering": ["index"],
            },
        ),
        migrations.AddField(
            model_name="policyrule",
            name="destination_zone",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="destination_policy_rules",
                to="nautobot_firewall_models.zone",
            ),
        ),
        migrations.AddField(
            model_name="policyrule",
            name="service",
            field=models.ManyToManyField(
                related_name="policy_rules",
                through="nautobot_firewall_models.SvcM2M",
                to="nautobot_firewall_models.ServiceObject",
            ),
        ),
        migrations.AddField(
            model_name="policyrule",
            name="service_group",
            field=models.ManyToManyField(
                related_name="policy_rules",
                through="nautobot_firewall_models.SvcGroupM2M",
                to="nautobot_firewall_models.ServiceObjectGroup",
            ),
        ),
        migrations.AddField(
            model_name="policyrule",
            name="source_address",
            field=models.ManyToManyField(
                related_name="source_policy_rules",
                through="nautobot_firewall_models.SrcAddrM2M",
                to="nautobot_firewall_models.AddressObject",
            ),
        ),
        migrations.AddField(
            model_name="policyrule",
            name="source_address_group",
            field=models.ManyToManyField(
                related_name="source_policy_rules",
                through="nautobot_firewall_models.SrcAddrGroupM2M",
                to="nautobot_firewall_models.AddressObjectGroup",
            ),
        ),
        migrations.AddField(
            model_name="policyrule",
            name="source_user",
            field=models.ManyToManyField(
                related_name="policy_rules",
                through="nautobot_firewall_models.SrcUserM2M",
                to="nautobot_firewall_models.UserObject",
            ),
        ),
        migrations.AddField(
            model_name="policyrule",
            name="source_user_group",
            field=models.ManyToManyField(
                related_name="policy_rules",
                through="nautobot_firewall_models.SrcUserGroupM2M",
                to="nautobot_firewall_models.UserObjectGroup",
            ),
        ),
        migrations.AddField(
            model_name="policyrule",
            name="source_zone",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="source_policy_rules",
                to="nautobot_firewall_models.zone",
            ),
        ),
        migrations.AddField(
            model_name="policyrule",
            name="status",
            field=nautobot.extras.models.statuses.StatusField(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="nautobot_firewall_models_policyrule_related",
                to="extras.status",
            ),
        ),
        migrations.AddField(
            model_name="policyrule",
            name="tags",
            field=taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag"),
        ),
        migrations.CreateModel(
            name="PolicyDynamicGroupM2M",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("weight", models.PositiveSmallIntegerField(default=100)),
                (
                    "dynamic_group",
                    models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to="extras.dynamicgroup"),
                ),
                (
                    "policy",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="nautobot_firewall_models.policy"
                    ),
                ),
            ],
            options={
                "ordering": ["weight"],
            },
        ),
        migrations.CreateModel(
            name="PolicyDeviceM2M",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("weight", models.PositiveSmallIntegerField(default=100)),
                ("device", models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to="dcim.device")),
                (
                    "policy",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="nautobot_firewall_models.policy"
                    ),
                ),
            ],
            options={
                "ordering": ["weight"],
            },
        ),
        migrations.AddField(
            model_name="policy",
            name="assigned_devices",
            field=models.ManyToManyField(
                related_name="firewall_policies", through="nautobot_firewall_models.PolicyDeviceM2M", to="dcim.Device"
            ),
        ),
        migrations.AddField(
            model_name="policy",
            name="assigned_dynamic_groups",
            field=models.ManyToManyField(
                related_name="firewall_policies",
                through="nautobot_firewall_models.PolicyDynamicGroupM2M",
                to="extras.DynamicGroup",
            ),
        ),
        migrations.AddField(
            model_name="policy",
            name="policy_rules",
            field=models.ManyToManyField(
                related_name="policies",
                through="nautobot_firewall_models.PolicyRuleM2M",
                to="nautobot_firewall_models.PolicyRule",
            ),
        ),
        migrations.AddField(
            model_name="policy",
            name="status",
            field=nautobot.extras.models.statuses.StatusField(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="nautobot_firewall_models_policy_related",
                to="extras.status",
            ),
        ),
        migrations.AddField(
            model_name="policy",
            name="tags",
            field=taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag"),
        ),
        migrations.AddField(
            model_name="policy",
            name="tenant",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="policies",
                to="tenancy.tenant",
            ),
        ),
        migrations.CreateModel(
            name="IPRange",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("start_address", nautobot.ipam.fields.VarbinaryIPField(db_index=True)),
                ("end_address", nautobot.ipam.fields.VarbinaryIPField(db_index=True)),
                ("description", models.CharField(blank=True, max_length=200)),
                ("size", models.PositiveIntegerField(editable=False)),
                (
                    "status",
                    nautobot.extras.models.statuses.StatusField(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="nautobot_firewall_models_iprange_related",
                        to="extras.status",
                    ),
                ),
                ("tags", taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag")),
                (
                    "vrf",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="ip_ranges",
                        to="ipam.vrf",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "IP Ranges",
                "ordering": ["start_address"],
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin),
        ),
        migrations.CreateModel(
            name="FQDNIPAddressM2M",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                (
                    "fqdn",
                    models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="nautobot_firewall_models.fqdn"),
                ),
                ("ip_address", models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to="ipam.ipaddress")),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="fqdn",
            name="ip_addresses",
            field=models.ManyToManyField(
                blank=True,
                related_name="fqdns",
                through="nautobot_firewall_models.FQDNIPAddressM2M",
                to="ipam.IPAddress",
            ),
        ),
        migrations.AddField(
            model_name="fqdn",
            name="status",
            field=nautobot.extras.models.statuses.StatusField(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="nautobot_firewall_models_fqdn_related",
                to="extras.status",
            ),
        ),
        migrations.AddField(
            model_name="fqdn",
            name="tags",
            field=taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag"),
        ),
        migrations.AddField(
            model_name="destaddrm2m",
            name="pol_rule",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="nautobot_firewall_models.policyrule"
            ),
        ),
        migrations.AddField(
            model_name="destaddrm2m",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, to="nautobot_firewall_models.addressobject"
            ),
        ),
        migrations.AddField(
            model_name="destaddrgroupm2m",
            name="pol_rule",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="nautobot_firewall_models.policyrule"
            ),
        ),
        migrations.CreateModel(
            name="AddressObjectGroupM2M",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                (
                    "address",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT, to="nautobot_firewall_models.addressobject"
                    ),
                ),
                (
                    "address_group",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="nautobot_firewall_models.addressobjectgroup"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="addressobjectgroup",
            name="address_objects",
            field=models.ManyToManyField(
                blank=True,
                related_name="address_object_groups",
                through="nautobot_firewall_models.AddressObjectGroupM2M",
                to="nautobot_firewall_models.AddressObject",
            ),
        ),
        migrations.AddField(
            model_name="addressobjectgroup",
            name="status",
            field=nautobot.extras.models.statuses.StatusField(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="nautobot_firewall_models_addressobjectgroup_related",
                to="extras.status",
            ),
        ),
        migrations.AddField(
            model_name="addressobjectgroup",
            name="tags",
            field=taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag"),
        ),
        migrations.AddField(
            model_name="addressobject",
            name="fqdn",
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to="nautobot_firewall_models.fqdn"
            ),
        ),
        migrations.AddField(
            model_name="addressobject",
            name="ip_address",
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to="ipam.ipaddress"
            ),
        ),
        migrations.AddField(
            model_name="addressobject",
            name="ip_range",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="nautobot_firewall_models.iprange",
            ),
        ),
        migrations.AddField(
            model_name="addressobject",
            name="prefix",
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to="ipam.prefix"
            ),
        ),
        migrations.AddField(
            model_name="addressobject",
            name="status",
            field=nautobot.extras.models.statuses.StatusField(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="nautobot_firewall_models_addressobject_related",
                to="extras.status",
            ),
        ),
        migrations.AddField(
            model_name="addressobject",
            name="tags",
            field=taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag"),
        ),
        migrations.AddConstraint(
            model_name="policyrulem2m",
            constraint=models.UniqueConstraint(fields=("policy", "rule", "index"), name="unique_with_index"),
        ),
        migrations.AddConstraint(
            model_name="policyrulem2m",
            constraint=models.UniqueConstraint(
                condition=models.Q(("index", None)), fields=("policy", "rule"), name="unique_without_index"
            ),
        ),
        migrations.AlterUniqueTogether(
            name="policydynamicgroupm2m",
            unique_together={("policy", "dynamic_group")},
        ),
        migrations.AlterUniqueTogether(
            name="policydevicem2m",
            unique_together={("policy", "device")},
        ),
        migrations.AddConstraint(
            model_name="iprange",
            constraint=models.UniqueConstraint(fields=("start_address", "end_address", "vrf"), name="unique_with_vrf"),
        ),
        migrations.AddConstraint(
            model_name="iprange",
            constraint=models.UniqueConstraint(
                condition=models.Q(("vrf", None)), fields=("start_address", "end_address"), name="unique_without_vrf"
            ),
        ),
    ]
