# -*- coding: utf-8 -*-
# Generated by Django 1.11.12 on 2018-10-16 10:11
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='CertificationCredential',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(
                    default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(
                    default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('accredible_id', models.IntegerField(blank=True, null=True)),
                ('status', models.CharField(choices=[('A', 'Pending'), ('B', 'Generated')], default='A', max_length=1)),
                ('object_id', models.PositiveIntegerField(null=True)),
                ('issued_on', models.DateField(blank=True, null=True)),
                ('accredible_url', models.URLField(blank=True, null=True)),
                ('seo_image', models.URLField(blank=True, null=True)),
                ('image', models.URLField(blank=True, null=True)),
                ('badge', models.URLField(blank=True, null=True)),
                ('content_type', models.ForeignKey(null=True,
                                                   on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CertificationGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(
                    default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(
                    default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=200)),
                ('description', models.TextField(null=True)),
                ('accredible_id', models.IntegerField(blank=True, null=True)),
                ('design_id', models.IntegerField(blank=True, null=True)),
                ('object_id', models.PositiveIntegerField(null=True)),
                ('_type', models.CharField(
                    choices=[
                        ('workshop', 'Workshop'),
                        ('consultantrolegroup', 'ConsultantRoleGroup')], max_length=100)),
                ('status', models.CharField(choices=[('A', 'Pending'), ('B', 'Generated')], default='A', max_length=1)),
                ('content_type', models.ForeignKey(null=True,
                                                   on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE,
                                                 related_name='certification_certificationgroup_related', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='certificationcredential',
            name='group',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                    related_name='credentials', to='certification.CertificationGroup'),
        ),
        migrations.AddField(
            model_name='certificationcredential',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                    related_name='certifications', to=settings.AUTH_USER_MODEL),
        ),
    ]
