# Copyright (c) OpenMMLab. All rights reserved.
from . import common, kie, textdet, textrecog
from .builder import (BACKBONES, CONVERTORS, DECODERS, DETECTORS, ENCODERS,
                      HEADS, LOSSES, NECKS, PREPROCESSOR, build_backbone,
                      build_convertor, build_decoder, build_detector,
                      build_encoder, build_loss, build_preprocessor)

from .common import *  # NOQA
from .kie import *  # NOQA
from .ner import *  # NOQA
from .textdet import *  # NOQA
from .textrecog import *  # NOQA

__all__ = [
    'BACKBONES', 'DETECTORS', 'HEADS', 'LOSSES', 'NECKS', 'build_backbone',
    'build_detector', 'build_loss', 'CONVERTORS', 'ENCODERS', 'DECODERS',
    'PREPROCESSOR', 'build_convertor', 'build_encoder', 'build_decoder',
    'build_preprocessor'
]
__all__ += common.__all__ + kie.__all__ + textdet.__all__ + textrecog.__all__
