/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.python.util;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseVector;
import breeze.linalg.SparseVector;
import com.alibaba.alink.common.linalg.Vector;
import com.alibaba.alink.operator.batch.classification.NaiveBayesModelInfo;
import com.alibaba.alink.operator.common.evaluation.BaseMetrics;
import com.alibaba.alink.operator.common.evaluation.BaseSimpleClassifierMetrics;
import com.alibaba.alink.operator.common.evaluation.BaseSimpleRegressionMetrics;
import com.alibaba.alink.operator.common.evaluation.BinaryClassMetrics;
import com.alibaba.alink.operator.common.evaluation.ClusterMetrics;
import com.alibaba.alink.operator.common.evaluation.MultiClassMetrics;
import com.alibaba.alink.operator.common.evaluation.RegressionMetrics;
import com.alibaba.alink.operator.common.statistics.ChiSquareTestResult;
import com.alibaba.alink.operator.common.statistics.basicstatistic.BaseSummary;
import com.alibaba.alink.operator.common.statistics.basicstatistic.BaseVectorSummary;
import com.alibaba.alink.operator.common.statistics.basicstatistic.CorrelationResult;
import com.alibaba.alink.operator.common.statistics.basicstatistic.DenseVectorSummary;
import com.alibaba.alink.operator.common.statistics.basicstatistic.SparseVectorSummary;
import com.alibaba.alink.operator.common.statistics.basicstatistic.TableSummary;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.codehaus.commons.nullanalysis.NotNull;
import scala.collection.immutable.VectorIterator;

public class GenerateAuxiliaryClasses {
    public static final int INDENT_SIZE = 4;

    public static String repeatSpaces(int n) {
        return StringUtils.repeat((char)' ', (int)n);
    }

    public static boolean isMethodStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static boolean isMethodOverridden(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass.equals(Object.class)) {
            return false;
        }
        try {
            Class<?> superclass = declaringClass.getSuperclass();
            if (null != superclass) {
                superclass.getMethod(method.getName(), method.getParameterTypes());
                return true;
            }
            return false;
        }
        catch (NoSuchMethodException e) {
            for (Class<?> iface : declaringClass.getInterfaces()) {
                try {
                    iface.getMethod(method.getName(), method.getParameterTypes());
                    return true;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
            return false;
        }
    }

    public static List<String> generateMethodDef(Method method) {
        ArrayList<String> lines = new ArrayList<String>();
        String name = method.getName();
        boolean isStatic = GenerateAuxiliaryClasses.isMethodStatic(method);
        Parameter[] parameters = method.getParameters();
        List jParamNames = Arrays.stream(parameters).map(Parameter::getName).collect(Collectors.toList());
        List types = Arrays.stream(parameters).map(Parameter::getType).collect(Collectors.toList());
        ArrayList pyParamNames = new ArrayList(jParamNames);
        if (!isStatic) {
            pyParamNames.add(0, "self");
        } else {
            pyParamNames.add(0, "cls");
            lines.add("@classmethod");
        }
        lines.add(String.format("def %s(%s):", name, String.join((CharSequence)", ", pyParamNames)));
        List pyUnwrapParamNames = Arrays.stream(parameters).map(d -> d.getName()).collect(Collectors.toList());
        Class<?> returnType = method.getReturnType();
        String pyReturnType = null;
        if (!ClassUtils.isPrimitiveOrWrapper(returnType)) {
            pyReturnType = returnType.getSimpleName();
        }
        if (isStatic) {
            String line = String.format("return get_java_class(cls.j_cls_name).%s(%s)\n", name, String.join((CharSequence)", ", pyUnwrapParamNames));
            lines.add(GenerateAuxiliaryClasses.repeatSpaces(4) + line);
        } else {
            String line = String.format("return self.%s(%s)\n", name, String.join((CharSequence)", ", pyUnwrapParamNames));
            lines.add(GenerateAuxiliaryClasses.repeatSpaces(4) + line);
        }
        return lines;
    }

    public static List<String> indentStrings(List<String> lines) {
        return lines.stream().map(d -> GenerateAuxiliaryClasses.repeatSpaces(4) + d).collect(Collectors.toList());
    }

    public static List<String> generateClassDef(Class<?> clz, @NotNull List<Class<?>> bases) {
        ArrayList<String> lines = new ArrayList<String>();
        List<String> pyBaseClasses = new ArrayList<String>();
        if (bases.size() == 0) {
            pyBaseClasses.add("JavaObjectWrapperWithAutoTypeConversion");
        } else {
            pyBaseClasses = bases.stream().map(Class::getSimpleName).collect(Collectors.toList());
        }
        lines.add(String.format("class %s(%s):", clz.getSimpleName(), String.join((CharSequence)", ", pyBaseClasses)));
        lines.add(GenerateAuxiliaryClasses.repeatSpaces(4) + String.format("j_cls_name = '%s'\n", clz.getName()));
        lines.add(GenerateAuxiliaryClasses.repeatSpaces(4) + "def __init__(self, j_obj):");
        lines.add(GenerateAuxiliaryClasses.repeatSpaces(8) + "self._j_obj = j_obj\n");
        lines.add(GenerateAuxiliaryClasses.repeatSpaces(4) + "def get_j_obj(self):");
        lines.add(GenerateAuxiliaryClasses.repeatSpaces(8) + "return self._j_obj\n");
        for (Method method : clz.getDeclaredMethods()) {
            if (GenerateAuxiliaryClasses.isMethodOverridden(method) || method.isBridge() || !Modifier.isPublic(method.getModifiers())) continue;
            lines.addAll(GenerateAuxiliaryClasses.indentStrings(GenerateAuxiliaryClasses.generateMethodDef(method)));
        }
        return lines;
    }

    public static List<String> generateImports() {
        return Arrays.asList("from .bases.j_obj_wrapper import JavaObjectWrapperWithAutoTypeConversion");
    }

    public static List<String> generatePyFile(List<Pair<Class<?>, List<Class<?>>>> classPairs) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.addAll(GenerateAuxiliaryClasses.generateImports());
        lines.add("\n");
        for (Pair<Class<?>, List<Class<?>>> pair : classPairs) {
            lines.addAll(GenerateAuxiliaryClasses.generateClassDef((Class)pair.getLeft(), (List)pair.getRight()));
        }
        return lines;
    }

    public static List<String> generateVectorPyFile() {
        List<Pair<Class<?>, List<Class<?>>>> classPairs = Arrays.asList(Pair.of(Vector.class, Arrays.asList(new Class[0])), Pair.of(DenseVector.class, Arrays.asList(Vector.class)), Pair.of(SparseVector.class, Arrays.asList(Vector.class)), Pair.of(DenseMatrix.class, Arrays.asList(new Class[0])), Pair.of(VectorIterator.class, Arrays.asList(new Class[0])));
        return GenerateAuxiliaryClasses.generatePyFile(classPairs);
    }

    public static List<String> generateStatisticsPyFile() {
        List<Pair<Class<?>, List<Class<?>>>> classPairs = Arrays.asList(Pair.of(BaseSummary.class, Arrays.asList(new Class[0])), Pair.of(TableSummary.class, Arrays.asList(BaseSummary.class)), Pair.of(BaseVectorSummary.class, Arrays.asList(BaseSummary.class)), Pair.of(SparseVectorSummary.class, Arrays.asList(BaseVectorSummary.class)), Pair.of(DenseVectorSummary.class, Arrays.asList(BaseVectorSummary.class)), Pair.of(CorrelationResult.class, Arrays.asList(new Class[0])), Pair.of(ChiSquareTestResult.class, Arrays.asList(new Class[0])));
        return GenerateAuxiliaryClasses.generatePyFile(classPairs);
    }

    public static List<String> generateMetricsPyFile() {
        List<Pair<Class<?>, List<Class<?>>>> classPairs = Arrays.asList(Pair.of(BaseMetrics.class, Arrays.asList(new Class[0])), Pair.of(BaseSimpleClassifierMetrics.class, Arrays.asList(BaseMetrics.class)), Pair.of(BaseSimpleRegressionMetrics.class, Arrays.asList(BaseMetrics.class)), Pair.of(BinaryClassMetrics.class, Arrays.asList(BaseSimpleClassifierMetrics.class)), Pair.of(MultiClassMetrics.class, Arrays.asList(BaseSimpleClassifierMetrics.class)), Pair.of(ClusterMetrics.class, Arrays.asList(BaseMetrics.class)), Pair.of(RegressionMetrics.class, Arrays.asList(BaseSimpleRegressionMetrics.class)));
        return GenerateAuxiliaryClasses.generatePyFile(classPairs);
    }

    public static List<String> generateFileSystemPyFile() {
        List<Pair<Class<?>, List<Class<?>>>> classPairs = Arrays.asList(new Pair[0]);
        return GenerateAuxiliaryClasses.generatePyFile(classPairs);
    }

    public static List<String> generateModelInfoPyFile() {
        List<Pair<Class<?>, List<Class<?>>>> classPairs = Arrays.asList(Pair.of(NaiveBayesModelInfo.class, Arrays.asList(new Class[0])));
        return GenerateAuxiliaryClasses.generatePyFile(classPairs);
    }

    public static void main(String[] args) {
        List<String> lines = GenerateAuxiliaryClasses.generateModelInfoPyFile();
        System.out.println(String.join((CharSequence)"\n", lines));
    }
}

