/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.types.logical.AnyType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class TypeInformationAnyType<T>
extends LogicalType {
    private static final String FORMAT = "ANY('%s', ?)";
    private static final Set<String> INPUT_OUTPUT_CONVERSION = TypeInformationAnyType.conversionSet(byte[].class.getName(), "org.apache.flink.table.dataformat.BinaryGeneric");
    private static final TypeInformation<?> DEFAULT_TYPE_INFO = Types.GENERIC(Object.class);
    private final TypeInformation<T> typeInfo;

    public TypeInformationAnyType(boolean isNullable, TypeInformation<T> typeInfo) {
        super(isNullable, LogicalTypeRoot.ANY);
        this.typeInfo = (TypeInformation)Preconditions.checkNotNull(typeInfo, (String)"Type information must not be null.");
    }

    public TypeInformationAnyType(TypeInformation<T> typeInfo) {
        this(true, typeInfo);
    }

    public TypeInformationAnyType() {
        this(true, DEFAULT_TYPE_INFO);
    }

    public TypeInformation<T> getTypeInformation() {
        return this.typeInfo;
    }

    @Internal
    public AnyType<T> resolve(ExecutionConfig config) {
        return new AnyType(this.isNullable(), this.typeInfo.getTypeClass(), this.typeInfo.createSerializer(config));
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new TypeInformationAnyType<T>(isNullable, this.typeInfo);
    }

    @Override
    public String asSummaryString() {
        return this.withNullability(FORMAT, this.typeInfo.getTypeClass().getName());
    }

    @Override
    public String asSerializableString() {
        throw new TableException("An any type backed by type information has no serializable string representation. It needs to be resolved into a proper any type.");
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        return this.typeInfo.getTypeClass().isAssignableFrom(clazz) || INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        return clazz.isAssignableFrom(this.typeInfo.getTypeClass()) || INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public Class<?> getDefaultConversion() {
        return this.typeInfo.getTypeClass();
    }

    @Override
    public List<LogicalType> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TypeInformationAnyType that = (TypeInformationAnyType)o;
        return this.typeInfo.equals(that.typeInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.typeInfo);
    }
}

